/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.gorod.server.bean;

import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class GorodParams {
    public static final String DEFAULT_PATTERN = "[${fio}][;${city}][,${street}][,${house}][${frac}][,${flat}][;${contractTitle}][;${summ}][;;;;${account}][:${contractId}]";
    private Preferences moduleSetup = null;
    private int paramAddress;
    private int paramFullName;
    private long groupMask;
    private String defaultAddress;
    private boolean isNote = false;
    private boolean isNoteDate = false;
    private boolean isRestGreaterZero = false;
    private boolean isReplaceTitleToCid = false;
    private boolean dropGFromAddress = true;
    private ParameterMap tagAccounts;
    private ParameterMap headerAccounts = null;
    private String summFunction = "SALDO";
    private String dateFormat = null;

    public GorodParams(Preferences moduleSetup) {
        this.moduleSetup = moduleSetup;
        this.paramAddress = moduleSetup.getInt("param.address", 0);
        this.paramFullName = moduleSetup.getInt("param.fullname", 0);
        this.tagAccounts = moduleSetup.sub("account.");
        this.groupMask = moduleSetup.getLong("group.mask", 0L);
        this.defaultAddress = moduleSetup.get("default.address", "");
        this.dropGFromAddress = Utils.parseInt((String)moduleSetup.get("drop.g.from.address", "0")) == 1;
        this.summFunction = moduleSetup.get("register.summ.macros", "SALDO");
        this.dateFormat = moduleSetup.get("register.date.format", "dd/MM/yyyy");
        String paramFieldNote = moduleSetup.get("param.note", "0");
        String paramFieldNoteDate = moduleSetup.get("param.note.content.date", "0");
        this.isNote = Utils.parseInt((String)paramFieldNote) == 1;
        this.isNoteDate = Utils.parseInt((String)paramFieldNoteDate) == 1;
        String paramRestGreaterZero = moduleSetup.get("param.rest.greater.zero", null);
        this.isRestGreaterZero = Utils.parseInt((String)paramRestGreaterZero) == 1;
        String paramReplaceTitleToCid = moduleSetup.get("param.replace.title.to.cid", "0");
        this.isReplaceTitleToCid = Utils.parseInt((String)paramReplaceTitleToCid) == 1;
        this.headerAccounts = moduleSetup.sub("header.account.");
    }

    public Preferences getModuleSetup() {
        return this.moduleSetup;
    }

    public void setModuleSetup(Preferences moduleSetup) {
        this.moduleSetup = moduleSetup;
    }

    public int getParamAddress() {
        return this.paramAddress;
    }

    public void setParamAddress(int paramAddress) {
        this.paramAddress = paramAddress;
    }

    public int getParamFullName() {
        return this.paramFullName;
    }

    public void setParamFullName(int paramFullName) {
        this.paramFullName = paramFullName;
    }

    public long getGroupMask() {
        return this.groupMask;
    }

    public void setGroupMask(long groupMask) {
        this.groupMask = groupMask;
    }

    public String getDefaultAddress() {
        return this.defaultAddress;
    }

    public void setDefaultAddress(String defaultAddress) {
        this.defaultAddress = defaultAddress;
    }

    public boolean isNote() {
        return this.isNote;
    }

    public void setNote(boolean isNote) {
        this.isNote = isNote;
    }

    public boolean isNoteDate() {
        return this.isNoteDate;
    }

    public void setNoteDate(boolean isNoteDate) {
        this.isNoteDate = isNoteDate;
    }

    public boolean isRestGreaterZero() {
        return this.isRestGreaterZero;
    }

    public void setRestGreaterZero(boolean isRestGreaterZero) {
        this.isRestGreaterZero = isRestGreaterZero;
    }

    public boolean isReplaceTitleToCid() {
        return this.isReplaceTitleToCid;
    }

    public void setReplaceTitleToCid(boolean isReplaceTitleToCid) {
        this.isReplaceTitleToCid = isReplaceTitleToCid;
    }

    public ParameterMap getTagAccounts() {
        return this.tagAccounts;
    }

    public void setTagAccounts(ParameterMap tagAccounts) {
        this.tagAccounts = tagAccounts;
    }

    public boolean isDropGFromAddress() {
        return this.dropGFromAddress;
    }

    public void setDropGFromAddress(boolean dropGFromAddress) {
        this.dropGFromAddress = dropGFromAddress;
    }

    public int getHeaderAccount(int key) {
        return Utils.parseInt((String)this.headerAccounts.get(String.valueOf(key), String.valueOf(-1)));
    }

    public String getSummFunction() {
        return this.summFunction;
    }

    public void setSummFunction(String summFunction) {
        this.summFunction = summFunction;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getRegisterPattern(String tagId) {
        return this.moduleSetup.get("register.pattern." + tagId, this.moduleSetup.get("register.pattern", DEFAULT_PATTERN));
    }

    public String getRegisterEncoding(String tagId) {
        return this.moduleSetup.get("register.encoding." + tagId, this.moduleSetup.get("register.encoding", "cp866"));
    }
}

