/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.hd.client.ContractPackageDomainEditor;
import ru.bitel.bgbilling.modules.hd.client.ContractPackageHostEditor;
import ru.bitel.bgbilling.modules.hd.client.ContractPackageHostingEditor;
import ru.bitel.bgbilling.modules.hd.client.ContractPackageNsEditor;
import ru.bitel.bgbilling.modules.hd.client.PackageEditorPanel;
import ru.bitel.bgbilling.modules.hd.client.ServicePropertiesPanel;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class ContractPackageEditor
extends BGPanel {
    private ServicePropertiesPanel servicePanel;
    private String packageId;
    private JTabbedPane editorsPanel = new JTabbedPane();
    private ContractPackageDomainEditor domainEditor = new ContractPackageDomainEditor(this);
    private ContractPackageNsEditor nsEditor = new ContractPackageNsEditor(this);
    private ContractPackageHostEditor hostEditor = new ContractPackageHostEditor(this);
    private ContractPackageHostingEditor hostingEditor = new ContractPackageHostingEditor(this);
    private List<PackageEditorPanel> editorList = new ArrayList<PackageEditorPanel>(4);
    private BGTextField domainName = new BGTextField();
    private BGComboBox<ComboBoxItem> zoneName = new BGComboBox();
    private JToggleButton domainActive = new JToggleButton("\u0410\u041a\u0422\u0418\u0412\u0415\u041d");
    private JToggleButton domainNotActive = new JToggleButton("\u041d\u0415 \u0410\u041a\u0422\u0418\u0412\u0415\u041d");
    private ButtonGroup statusButtonGroup = new ButtonGroup();

    public ContractPackageEditor(ServicePropertiesPanel servicePanel) {
        this.servicePanel = servicePanel;
        this.editorList.add(this.domainEditor);
        this.editorList.add(this.nsEditor);
        this.editorList.add(this.hostEditor);
        this.editorList.add(this.hostingEditor);
        this.jbInit();
    }

    private void jbInit() {
        JPanel topPanel = new JPanel(new GridBagLayout());
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        this.domainActive.setActionCommand("1");
        this.domainNotActive.setActionCommand("0");
        this.statusButtonGroup.add(this.domainActive);
        this.statusButtonGroup.add(this.domainNotActive);
        topPanel.add((Component)new JLabel("\u0414\u043e\u043c\u0435\u043d: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.domainName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.zoneName, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        topPanel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441 : "), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.domainActive, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.domainNotActive, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.add(topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.editorsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)okCancel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 5, 5), 0, 0));
        okCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContractPackageEditor.this.stopEdit(e.getActionCommand().equals("ok"));
            }
        });
    }

    public void setPackageId(String value) {
        this.packageId = value;
    }

    public void setData() {
        this.loadEditorForType();
        if (this.id.equals("new")) {
            for (PackageEditorPanel editor : this.editorList) {
                if (!editor.isVisible()) continue;
                editor.setData(null);
            }
            this.domainNotActive.setSelected(true);
        } else {
            Request req = new Request();
            req.setModule(this.module);
            req.setAction("ContractPackageGet");
            req.setModuleId(this.getModuleId());
            req.setAttribute("id", this.id);
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                Element data = XMLUtils.getElement((Document)doc, (String)"contract_package");
                this.domainName.setText(data.getAttribute("domain_name"));
                ClientUtils.setComboBoxSelection(this.zoneName, (Object)data.getAttribute("domain_zone_name"));
                if ("1".equals(data.getAttribute("status"))) {
                    this.domainActive.setSelected(true);
                } else {
                    this.domainNotActive.setSelected(true);
                }
                for (PackageEditorPanel editor : this.editorList) {
                    if (!editor.isVisible()) continue;
                    editor.setData(data);
                }
            }
        }
    }

    private void loadEditorForType() {
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("PackageGet");
        req.setModuleId(this.getModuleId());
        req.setAttribute("id", this.packageId);
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            Element packageEl = XMLUtils.getElement((Document)doc, (String)"package");
            this.domainEditor.updateEditor(packageEl);
            this.nsEditor.updateEditor(packageEl);
            this.hostEditor.updateEditor(packageEl);
            this.hostingEditor.updateEditor(packageEl);
            this.editorsPanel.removeAll();
            if (packageEl.getAttribute("domain").equals("1")) {
                this.editorsPanel.add((Component)((Object)this.domainEditor), " \u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u0434\u043e\u043c\u0435\u043d\u0430 ");
            }
            if (packageEl.getAttribute("ns").equals("1")) {
                this.editorsPanel.add((Component)((Object)this.nsEditor), " \u041f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0430 \u043d\u0430 NS \u0441\u0435\u0440\u0432\u0435\u0440\u0430\u0445 ");
            }
            if (packageEl.getAttribute("host").equals("1")) {
                this.editorsPanel.add((Component)((Object)this.hostEditor), " \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0437\u043e\u043d\u044b ");
            }
            if (packageEl.getAttribute("hosting").equals("1")) {
                this.editorsPanel.add((Component)((Object)this.hostingEditor), " \u0425\u043e\u0441\u0442\u0438\u043d\u0433 ");
            }
        }
    }

    public ContractPackageDomainEditor getDomainEditor() {
        return this.domainEditor;
    }

    public ContractPackageNsEditor getNsEditor() {
        return this.nsEditor;
    }

    public ContractPackageHostEditor getHostEditor() {
        return this.hostEditor;
    }

    public ContractPackageHostingEditor getHostingEditor() {
        return this.hostingEditor;
    }

    private void stopEdit(boolean save) {
        if (save) {
            Request req = new Request();
            req.setModule(this.module);
            req.setAction("ContractPackageUpdate");
            req.setModuleId(this.getModuleId());
            req.setContractId(this.getContractId());
            req.setAttribute("id", this.id);
            req.setAttribute("pid", this.packageId);
            for (PackageEditorPanel editor : this.editorList) {
                if (!editor.isVisible()) continue;
                editor.addToRequest(req);
            }
            Document doc = this.getDocument(req);
            if (!ClientUtils.checkStatus((Document)doc)) {
                this.id = doc.getDocumentElement().getAttribute("id");
            }
        }
    }
}

