/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.im.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGControlPanelButtonGroup;
import bitel.billing.module.common.BGHtmlPane;
import bitel.billing.module.common.BGTabbedPane;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.plugins.im.client.PluginClientListener;
import ru.bitel.bgbilling.plugins.im.common.IMConstants;
import ru.bitel.bgbilling.plugins.im.common.IMMessage;
import ru.bitel.bgbilling.plugins.im.common.IMMessageList;
import ru.bitel.bgbilling.plugins.im.common.IMUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;

public class IMManagerChatTab
extends BGTabPanel {
    private BGPluginClient plugin;
    private JPanel cardPanelChat = new JPanel(new GridBagLayout());
    private JPanel cardPanelHistory = new JPanel(new GridBagLayout());
    private JLabel infoStatusField = new JLabel();
    private BGHtmlPane paneHtmlChat = new BGHtmlPane();
    private JTextArea textMessageChat = new JTextArea();
    private JSplitPane jSplitPaneMessageChat = new JSplitPane(0);
    private BGControlPanelPeriodNoB periodPanel = new BGControlPanelPeriodNoB();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private IMConstants.GETHISTORYMODE _DateHistoryMode = IMConstants.GETHISTORYMODE.DAY;
    private BGHtmlPane paneHtmlHistory = new BGHtmlPane();
    private static final String TEMPLATE_MESSAGE = "<div class='plugins_im_notice_%%INOUT%%'><table cellspacing='1' ><tr><th width='100%' id='headmessage%%ID%%'><b>[%%TIME%%]</b> %%NAME%%</th><th><a class='commandLink' href='bgbilling://ru.bitel.bgbilling.plugins.im.client.IMManagerChatTab?%%ID%%'>\u0426\u0438\u0442\u0430\u0442\u0430</a></th></tr><tr><td colspan='2' id='message%%ID%%'>%%MESSAGE%%</td></tr></table></div>";
    public static final DateFormat dateFormatChat = new SimpleDateFormat("HH:mm:ss");
    public static final DateFormat dateFormatHistory = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    private static final String CSS_URI = "/ru/bitel/bgbilling/plugins/im/client/stylesheet.css";
    private static final String CSS_ENCODE = "UTF-8";
    private boolean wasInit = false;
    private Icon tabIconSetted = null;

    public IMManagerChatTab(String jid, String name, BGPluginClient plugin, Icon icon) {
        super(jid, name);
        this.tabIcon = icon;
        this.plugin = plugin;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void renameTab(String jid, String name, Icon icon) {
        if (jid != null) {
            this.setTabId(jid);
        }
        if (name != null) {
            this.setTabTitle(name);
        }
        this.infoStatusField.setText(this.tabTitle + " <" + this.tabID + ">");
        if (icon != null) {
            this.tabIconSetted = icon;
            this.setTabIcon(icon);
            this.infoStatusField.setIcon(icon);
        }
    }

    private void jbInit() throws IOException, BadLocationException {
        this.setLayout(new GridBagLayout());
        JPanel topPanelTab = new JPanel(new GridBagLayout());
        this.add(topPanelTab, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        final BGControlPanelButtonGroup cpButtonGroupCardChange = new BGControlPanelButtonGroup();
        cpButtonGroupCardChange.addButton(this.plugin.getResourceString("cpButtonGroupCardChange_ButtonChat"), "chat");
        cpButtonGroupCardChange.addButton(this.plugin.getResourceString("cpButtonGroupCardChange_ButtonHistory"), "history");
        cpButtonGroupCardChange.setSelectedCommand("chat");
        topPanelTab.add((Component)cpButtonGroupCardChange, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.infoStatusField.setText(this.tabTitle + " <" + this.tabID + ">");
        this.infoStatusField.setIcon(this.tabIcon);
        this.infoStatusField.setBorder((Border)new BGTitleBorder());
        topPanelTab.add((Component)this.infoStatusField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        BGButton bClose = new BGButton(this.plugin.getResourceString("button_bClose_Title"));
        bClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IMManagerChatTab.this.closeTab();
            }
        });
        topPanelTab.add((Component)bClose, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        final JPanel cardPanel = new JPanel(new CardLayout());
        this.add(cardPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        cardPanel.add((Component)this.cardPanelChat, "chat");
        cardPanel.add((Component)this.cardPanelHistory, "history");
        cpButtonGroupCardChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((CardLayout)cardPanel.getLayout()).show(cardPanel, cpButtonGroupCardChange.getSelectedCommand());
            }
        });
        JPanel topPanelCardChat = new JPanel(new GridBagLayout());
        topPanelCardChat.setBorder((Border)new BGTitleBorder("\u0427\u0430\u0442"));
        BGButton bClear = new BGButton(this.plugin.getResourceString("button_bClear_Title"));
        bClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IMManagerChatTab.this.clearTab();
            }
        });
        topPanelCardChat.add(Box.createGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanelCardChat.add((Component)bClear, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.cardPanelChat.add((Component)topPanelCardChat, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.paneHtmlChat.setStyleSheet(CSS_URI, CSS_ENCODE);
        this.paneHtmlChat.setEditable(false);
        JPanel panelPaneHtmlChat = new JPanel(new GridBagLayout());
        panelPaneHtmlChat.setBackground(Color.white);
        panelPaneHtmlChat.add((Component)this.paneHtmlChat, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 3), 0, 0));
        JScrollPane scrollPanePaneHtmlChat = new JScrollPane(panelPaneHtmlChat, 20, 30);
        JScrollPane scrollPaneMessageChat = new JScrollPane(this.textMessageChat);
        this.jSplitPaneMessageChat.add((Component)scrollPanePaneHtmlChat, "top");
        this.jSplitPaneMessageChat.add((Component)scrollPaneMessageChat, "bottom");
        this.cardPanelChat.add((Component)this.jSplitPaneMessageChat, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.paneHtmlChat.clear();
        this.textMessageChat.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && e.isControlDown()) {
                    IMManagerChatTab.this.sendMessage();
                }
            }
        });
        JPanel bottomPanelCardChat = new JPanel(new GridBagLayout());
        this.cardPanelChat.add((Component)bottomPanelCardChat, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGButton bSend = new BGButton(this.plugin.getResourceString("button_bSend_Title"));
        bSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IMManagerChatTab.this.sendMessage();
            }
        });
        bottomPanelCardChat.add(Box.createGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        bottomPanelCardChat.add((Component)bSend, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel topPanelCardHistory = new JPanel(new GridBagLayout());
        this.cardPanelHistory.add((Component)topPanelCardHistory, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanelCardHistory.setBorder((Border)new BGTitleBorder("\u0418\u0441\u0442\u043e\u0440\u0438\u044f"));
        topPanelCardHistory.add((Component)this.periodPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGButton bGetHistory = new BGButton(this.plugin.getResourceString("button_GetHistory_Title"));
        bGetHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IMManagerChatTab.this._DateHistoryMode = IMConstants.GETHISTORYMODE.PERIOD;
                IMManagerChatTab.this.setDataHistory();
            }
        });
        topPanelCardHistory.add((Component)bGetHistory, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGButton bLastWeek = new BGButton(this.plugin.getResourceString("button_LastWeek_Title"));
        bLastWeek.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IMManagerChatTab.this._DateHistoryMode = IMConstants.GETHISTORYMODE.WEEK;
                IMManagerChatTab.this.periodPanel.reset();
                IMManagerChatTab.this.setDataHistory();
            }
        });
        topPanelCardHistory.add((Component)bLastWeek, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        BGButton bLastDay = new BGButton(this.plugin.getResourceString("button_LastDay_Title"));
        bLastDay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IMManagerChatTab.this._DateHistoryMode = IMConstants.GETHISTORYMODE.DAY;
                IMManagerChatTab.this.periodPanel.reset();
                IMManagerChatTab.this.setDataHistory();
            }
        });
        topPanelCardHistory.add((Component)bLastDay, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGButton bLastHour = new BGButton(this.plugin.getResourceString("button_LastHour_Title"));
        bLastHour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IMManagerChatTab.this._DateHistoryMode = IMConstants.GETHISTORYMODE.HOUR;
                IMManagerChatTab.this.periodPanel.reset();
                IMManagerChatTab.this.setDataHistory();
            }
        });
        topPanelCardHistory.add((Component)bLastHour, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanelCardHistory.add((Component)this.pagePanel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        this.pagePanel.init();
        this.pagePanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if (propertyName != null && propertyName.startsWith("to")) {
                    IMManagerChatTab.this.setDataHistory();
                }
            }
        });
        this.paneHtmlHistory.setStyleSheet(CSS_URI, CSS_ENCODE);
        this.paneHtmlHistory.setEditable(false);
        JPanel panelHtmlHistory = new JPanel(new GridBagLayout());
        panelHtmlHistory.setBackground(Color.white);
        panelHtmlHistory.add((Component)this.paneHtmlHistory, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 3), 0, 0));
        JScrollPane scrollPaneHtmlHistory = new JScrollPane(panelHtmlHistory);
        this.cardPanelHistory.add((Component)scrollPaneHtmlHistory, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (PluginClientListener.imManager.isShowing()) {
                    PluginClientListener.imManager.eraseNewMessages4jid(IMManagerChatTab.this.tabID);
                    if (PluginClientListener.toolbarIMButton != null) {
                        PluginClientListener.toolbarIMButton.refreshNewMessagesCount();
                    }
                    IMManagerChatTab.this.textMessageChat.requestFocusInWindow();
                }
                if (!IMManagerChatTab.this.wasInit) {
                    IMManagerChatTab.this.wasInit = true;
                    BGTabbedPane par = (BGTabbedPane)IMManagerChatTab.this.getParent();
                    IMManagerChatTab.this.jSplitPaneMessageChat.setDividerLocation((par.getHeight() - par.getY()) / 2);
                }
            }
        });
        HyperlinkListener hll = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        URI uri = new URI(e.getDescription());
                        if ("bgbilling".equals(uri.getScheme())) {
                            BGHtmlPane sourcePaneHtml = (BGHtmlPane)e.getSource();
                            String quotedNick = sourcePaneHtml.getElementInnerHtml("headmessage" + uri.getQuery());
                            String quotedText = sourcePaneHtml.getElementInnerHtml("message" + uri.getQuery());
                            if (quotedNick != null && quotedText != null) {
                                String[] quotedTextLines;
                                IMManagerChatTab.this.textMessageChat.insert(">" + quotedNick, IMManagerChatTab.this.textMessageChat.getText().length());
                                for (String s : quotedTextLines = quotedText.split("\n")) {
                                    IMManagerChatTab.this.textMessageChat.insert(">" + s + "\n", IMManagerChatTab.this.textMessageChat.getText().length());
                                }
                            }
                        }
                    }
                    catch (URISyntaxException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        };
        this.paneHtmlChat.addHyperlinkListener(hll);
        this.paneHtmlHistory.addHyperlinkListener(hll);
    }

    private void clearTab() {
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f?", "\u0427\u0430\u0442", 0) == 0) {
            try {
                this.paneHtmlChat.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void sendMessage() {
        if (this.textMessageChat.getText().length() > 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("SendMessage");
            request.setAttribute("userto", this.tabID);
            request.setAttribute("text", this.textMessageChat.getText());
            Document doc = TransferManager.getDocument((Request)request);
            if (ClientUtils.checkStatus((Document)doc)) {
                PluginClientListener.imManager.setDocumentCheckStatus(doc);
                this.textMessageChat.setText("");
            }
        }
    }

    public void setDataHistory() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GetHistory");
        if (this.periodPanel.getDateCalendar1() != null) {
            request.setAttribute("datefrom", TimeUtils.clearToBeginDay((Calendar)this.periodPanel.getDateCalendar1()));
        }
        if (this.periodPanel.getDateCalendar2() != null) {
            request.setAttribute("dateto", TimeUtils.clearToBeginDay((Calendar)this.periodPanel.getDateCalendar2()));
        }
        request.setAttribute("GetHistoryMode", (Object)this._DateHistoryMode);
        request.setAttribute("jidfrom", IMUtils.getPureJID((String)this.tabID));
        request.setPageIndex(this.pagePanel.getPageIndex());
        request.setPageSize(this.pagePanel.getPageSize());
        Document doc = TransferManager.getDocument((Request)request);
        if (ClientUtils.checkStatus((Document)doc)) {
            IMMessageList messagesHistoryList = new IMMessageList();
            Element messageListElement = XMLUtils.selectElement((Node)doc, (String)"//messageList");
            messagesHistoryList.getXml(messageListElement);
            this.putMessagesHistory(messagesHistoryList);
            this.pagePanel.setPageInfo(messageListElement);
        }
    }

    private void putMessagesHistory(IMMessageList messageList) {
        try {
            this.paneHtmlHistory.clear();
            for (IMMessage message : messageList.getList()) {
                String s = TEMPLATE_MESSAGE.replaceAll("%%TIME%%", dateFormatHistory.format(message.getTime())).replaceAll("%%NAME%%", PluginClientListener.imManager.getNameFromJid(message.getFrom())).replaceAll("%%INOUT%%", message.isIncoming() ? "in" : "out").replaceAll("%%MESSAGE%%", message.getText().replaceAll("\n", "<br/>")).replaceAll("%%ID%%", String.valueOf(message.getId()));
                this.paneHtmlHistory.putHhml(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void putMessage(IMMessage message) {
        try {
            String s = TEMPLATE_MESSAGE.replaceAll("%%TIME%%", dateFormatChat.format(message.getTime())).replaceAll("%%NAME%%", PluginClientListener.imManager.getNameFromJid(message.getFrom())).replaceAll("%%INOUT%%", message.isIncoming() ? "in" : "out").replaceAll("%%MESSAGE%%", message.getText().replaceAll("\n", "<br/>")).replaceAll("%%ID%%", String.valueOf(message.getId()));
            this.paneHtmlChat.putHhml(s);
            this.scrollMessageChat();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void scrollMessageChat() {
        this.paneHtmlChat.scrollRectToVisible(new Rectangle(0, this.paneHtmlChat.getHeight(), 1, this.paneHtmlChat.getHeight()));
    }

    public void setMessaged(boolean hasNewMessage) {
        if (hasNewMessage) {
            this.setTabIcon(PluginClientListener.emailIcon);
        } else {
            this.setTabIcon(this.tabIconSetted);
        }
    }
}

