/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.event.accounting;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.common.SerialUtils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;

@XmlRootElement
@EventType(timeToLive=3600000L)
public class InetDetailCreateEvent
extends QueueEvent {
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(InetDetailCreateEvent.class);
    @XmlAttribute
    private final int accountingRootDeviceId;
    @XmlAttribute
    private final int deviceId;
    @XmlAttribute
    private final int inetServId;
    @XmlAttribute
    private final String inetServTitle;
    @XmlAttribute
    private final Date timeFrom;
    @XmlAttribute
    private final Date timeTo;
    @XmlElementWrapper
    @XmlElements(value={@XmlElement(name="session")})
    private final List<SessionInfo> sessionList;
    @XmlAttribute
    private final String email;

    protected InetDetailCreateEvent() {
        this.accountingRootDeviceId = -1;
        this.deviceId = -1;
        this.inetServId = -1;
        this.inetServTitle = null;
        this.timeFrom = null;
        this.timeTo = null;
        this.sessionList = null;
        this.email = null;
    }

    public InetDetailCreateEvent(int moduleId, int accountingRootDeviceId, int deviceId, int inetServId, String inetServTitle, Date timeFrom, Date timeTo, List<SessionInfo> sessionList, String email) {
        super(moduleId, CONTRACT_GLOBAL, -1);
        this.accountingRootDeviceId = accountingRootDeviceId;
        this.deviceId = deviceId;
        this.inetServId = inetServId;
        this.inetServTitle = inetServTitle;
        this.timeFrom = timeFrom;
        this.timeTo = timeTo;
        this.sessionList = sessionList;
        this.email = email;
    }

    public InetDetailCreateEvent(int moduleId, int accountingRootDeviceId, int deviceId, int inetServId, String inetServTitle, Date timeFrom, Date timeTo, int agentDeviceId, Set<Integer> ifaces, IpAddress addressFrom, IpAddress addressTo, IpAddress prefix, short prefixLength, List<IpNet> routeNetList, String email) {
        super(moduleId, CONTRACT_GLOBAL, -1);
        this.accountingRootDeviceId = accountingRootDeviceId;
        this.deviceId = deviceId;
        this.inetServId = inetServId;
        this.inetServTitle = inetServTitle;
        this.timeFrom = timeFrom;
        this.timeTo = timeTo;
        this.sessionList = new ArrayList<SessionInfo>();
        this.sessionList.add(new SessionInfo(timeFrom, timeTo, agentDeviceId, ifaces, addressFrom, addressTo, prefix, prefixLength, routeNetList));
        this.email = email;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("accountingRootDeviceId", this.accountingRootDeviceId);
        message.setIntProperty("deviceId", this.deviceId);
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getInetServId() {
        return this.inetServId;
    }

    public String getInetServTitle() {
        return this.inetServTitle;
    }

    public Date getTimeFrom() {
        return this.timeFrom;
    }

    public Date getTimeTo() {
        return this.timeTo;
    }

    public List<SessionInfo> getSessionList() {
        return this.sessionList;
    }

    public String getEmail() {
        return this.email;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class SessionInfo {
        @XmlAttribute
        private final Date timeFrom;
        @XmlAttribute
        private final Date timeTo;
        @XmlAttribute
        private int agentDeviceId;
        @XmlAttribute
        private Set<Integer> ifaces;
        private IpAddress addressFrom;
        private IpAddress addressTo;
        private IpAddress prefix;
        private short prefixLength;
        private List<IpNet> routeNetList;

        public SessionInfo() {
            this.timeFrom = null;
            this.timeTo = null;
            this.agentDeviceId = -1;
            this.ifaces = null;
            this.addressFrom = null;
            this.addressTo = null;
            this.routeNetList = null;
            this.prefix = null;
            this.prefixLength = 0;
        }

        public SessionInfo(Date timeFrom, Date timeTo, int agentDeviceId, Set<Integer> ifaces, IpAddress addressFrom, IpAddress addressTo, IpAddress prefix, short prefixLength, List<IpNet> routeNetList) {
            this.timeFrom = timeFrom;
            this.timeTo = timeTo;
            this.agentDeviceId = agentDeviceId;
            this.ifaces = ifaces;
            this.addressFrom = addressFrom;
            this.addressTo = addressTo;
            this.prefix = prefix;
            this.prefixLength = prefixLength;
            this.routeNetList = routeNetList;
        }

        public Date getTimeFrom() {
            return this.timeFrom;
        }

        public Date getTimeTo() {
            return this.timeTo;
        }

        public int getAgentDeviceId() {
            return this.agentDeviceId;
        }

        public void setAgentDeviceId(int agentDeviceId) {
            this.agentDeviceId = agentDeviceId;
        }

        public Set<Integer> getIfaces() {
            return this.ifaces;
        }

        public void setIfaces(Set<Integer> ifaces) {
            this.ifaces = ifaces;
        }

        public IpAddress getAddressFrom() {
            return this.addressFrom;
        }

        public void setAddressFrom(IpAddress addressFrom) {
            this.addressFrom = addressFrom;
        }

        public IpAddress getAddressTo() {
            return this.addressTo;
        }

        public void setAddressTo(IpAddress addressTo) {
            this.addressTo = addressTo;
        }

        public List<IpNet> getRouteNetList() {
            return this.routeNetList;
        }

        public void setRouteNetList(List<IpNet> routeNetList) {
            this.routeNetList = routeNetList;
        }

        public IpAddress getPrefix() {
            return this.prefix;
        }

        public short getPrefixLength() {
            return this.prefixLength;
        }
    }
}

