/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.event.sa;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionManager;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivatorEvent;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivatorEventType;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.PartitionedQueueEvent;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.AccessCodes;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaServModifyEvent;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.runtime.AuthResult;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.common.sql.ConnectionSet;

@EventType(autoAcknowledge=false, timeToLive=432000000L, deliveryMode=1)
@XmlRootElement
public class InetSaStateModifyEvent
extends PartitionedQueueEvent {
    private static final transient Logger logger = LogManager.getLogger();
    @XmlAttribute
    private final int deviceId;
    @XmlAttribute
    private final int inetServId;
    @XmlAttribute
    private final long connectionId;
    @XmlAttribute
    private final short state;
    @XmlAttribute
    private final int accessCode;
    @XmlAttribute
    private final boolean recheck;
    @XmlAttribute
    private final boolean force;
    @XmlAttribute
    private Set<Integer> oldOptions;

    protected InetSaStateModifyEvent() {
        this.deviceId = -1;
        this.inetServId = -1;
        this.connectionId = -1L;
        this.state = (short)-1;
        this.accessCode = -1;
        this.recheck = false;
        this.force = false;
    }

    public InetSaStateModifyEvent(int moduleId, int userId, InetConnection connection, short state, int accessCode) {
        this(moduleId, connection.getContractId(), userId, connection.getDeviceId(), connection.getServId(), connection.getId(), state, accessCode, false);
    }

    public InetSaStateModifyEvent(int moduleId, int userId, InetServ inetServ, short state, int accessCode) {
        this(moduleId, inetServ.getContractId(), userId, inetServ.getDeviceId(), inetServ.getId(), 0L, state, accessCode, false);
    }

    public InetSaStateModifyEvent(int moduleId, int userId, InetServ inetServ, short state, int accessCode, boolean recheck) {
        this(moduleId, inetServ.getContractId(), userId, inetServ.getDeviceId(), inetServ.getId(), 0L, state, accessCode, recheck);
    }

    public InetSaStateModifyEvent(int moduleId, int contractId, int userId, int deviceId, int inetServId, long connectionId, short state, int accessCode, boolean recheck) {
        this(moduleId, contractId, userId, deviceId, inetServId, connectionId, state, accessCode, recheck, false);
    }

    public InetSaStateModifyEvent(int moduleId, int contractId, int userId, int deviceId, int inetServId, long connectionId, short state, int accessCode, boolean recheck, boolean force) {
        super(moduleId, contractId, userId);
        this.deviceId = deviceId;
        this.inetServId = inetServId;
        this.connectionId = connectionId;
        this.state = state;
        this.accessCode = accessCode;
        this.recheck = recheck;
        this.force = force;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("deviceId", this.deviceId);
        message.setIntProperty("servId", this.inetServId);
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getInetServId() {
        return this.inetServId;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public short getState() {
        return this.state;
    }

    public int getAccessCode() {
        return this.accessCode;
    }

    protected void toString(StringBuilder sb) {
        sb.append("; deviceId: ");
        sb.append(this.deviceId);
        sb.append("; inetServId: ");
        sb.append(this.inetServId);
        sb.append("; connectionId: ");
        sb.append(this.connectionId);
        sb.append("; state: ");
        sb.append(this.state);
        sb.append("; accessCode: ");
        sb.append(this.accessCode);
    }

    public ServiceActivatorEvent toSaEvent(Access access, ConnectionSet connectionSet, boolean manageConnections, InetConnectionManager connectionManager, Date now) throws BGException {
        List childrenServs;
        String realm;
        Set<Integer> oldOptionSet;
        short oldState;
        InetServRuntime inetServRuntime = access.inetServRuntimeMap.get(Integer.valueOf(this.getInetServId()));
        if (inetServRuntime == null) {
            logger.error("InetServ not found with id=" + this.getInetServId());
            return null;
        }
        InetServ inetServ = inetServRuntime.getInetServ();
        InetConnectionRuntime connectionRuntime = null;
        InetConnection connection = null;
        short newState = this.state;
        Set newOptionSet = null;
        if (this.getConnectionId() > 0L) {
            if (!manageConnections) {
                logger.debug("Not manage connections");
                return null;
            }
            List connectionList = connectionManager.getByServId(Integer.valueOf(this.getInetServId()));
            if (connectionList != null) {
                int size = connectionList.size();
                for (int i = 0; i < size; ++i) {
                    InetConnectionRuntime con = (InetConnectionRuntime)connectionList.get(i);
                    if (con.connection.getId() != this.getConnectionId()) continue;
                    connectionRuntime = con;
                    connection = con.connection;
                    break;
                }
            }
            if (connection == null) {
                logger.warn("Connection not found with id=" + this.getConnectionId() + " (may closed already)");
                return null;
            }
            oldState = connection.getDeviceState();
            oldOptionSet = this.force && this.oldOptions != null ? this.oldOptions : connection.getDeviceOptions();
            if (!this.force && oldState == newState && !AccessCodes.isNeededDisconnect(this.accessCode)) {
                logger.debug("Connection state already " + newState);
                return null;
            }
            realm = InetUtils.getRealm((String)connection.getUsername());
        } else {
            boolean forceRecheck;
            oldState = inetServ.getDeviceState();
            oldOptionSet = inetServ.getDeviceOptions();
            if (inetServ.getParentId() > 0) {
                logger.error("InetServ is child " + this.inetServId);
                return null;
            }
            if (oldState == newState) {
                logger.debug("InetServ state already " + newState);
                return null;
            }
            boolean bl = forceRecheck = System.currentTimeMillis() - this.getTimestamp() > 3600000L;
            if (forceRecheck || this.recheck) {
                switch (newState) {
                    case 0: {
                        AuthResult authResult;
                        if (forceRecheck) {
                            logger.info("Recieved old event, force reauthorization");
                            authResult = access.authorization(inetServRuntime, inetServRuntime, true, inetServRuntime.getInetServ().getDeviceId(), inetServRuntime.getInetServ().getDeviceId(), null, null, 0, null, 0, 0, false, null, null, false, BigDecimal.ZERO, false);
                            short s = newState = authResult.accessCode == 0 ? (short)1 : 0;
                            if (oldState == newState) {
                                logger.debug("InetServ state already " + newState);
                                return null;
                            }
                            if (authResult.accessCode != 0) break;
                            newOptionSet = authResult.optionSet;
                            break;
                        }
                        if (this.accessCode != 12) break;
                        authResult = access.authorization(inetServRuntime, inetServRuntime, true, inetServRuntime.getInetServ().getDeviceId(), inetServRuntime.getInetServ().getDeviceId(), null, null, 0, null, 0, 0, false, null, null, false, BigDecimal.ZERO, false);
                        if (authResult.req != null && authResult.req.isIgnoreBalanceInsufficient()) {
                            logger.info("Skip disable serv by balance (ignoreBalanceInsufficient)");
                            return null;
                        }
                        if (authResult.accessCode != 0) break;
                        newOptionSet = authResult.optionSet;
                        break;
                    }
                    case 1: {
                        AuthResult authResult = access.authorization(inetServRuntime, inetServRuntime, true, inetServRuntime.getInetServ().getDeviceId(), inetServRuntime.getInetServ().getDeviceId(), null, null, 0, null, 0, 0, false, null, null, false, BigDecimal.ZERO, false);
                        switch (authResult.accessCode) {
                            case 12: 
                            case 20: 
                            case 44: {
                                logger.info("Skip enable serv by accessCode=" + authResult.accessCode);
                                return null;
                            }
                            case 0: {
                                newOptionSet = authResult.optionSet;
                                break;
                            }
                        }
                        if (!forceRecheck) break;
                        logger.info("Recieved old event, force reauthorization");
                        short s = newState = authResult.accessCode == 0 ? (short)1 : 0;
                        if (oldState != newState) break;
                        logger.debug("InetServ state already " + newState);
                        return null;
                    }
                }
            }
            realm = null;
        }
        if (newState == -1) {
            logger.error("DeviceState DELETED in SaStateModifyEvent!");
            return null;
        }
        List childrenServRuntimes = access.getInetServRuntimeMap().listChildren(Integer.valueOf(inetServ.getId()));
        if (childrenServRuntimes != null) {
            childrenServs = new ArrayList(childrenServRuntimes.size());
            for (InetServRuntime servRuntime : childrenServRuntimes) {
                childrenServs.add(servRuntime.getInetServ());
            }
        } else {
            childrenServs = Collections.emptyList();
        }
        inetServ.setChildren(childrenServs);
        if (newOptionSet == null) {
            newOptionSet = access.inetServOptionSet(connectionSet, now.getTime(), inetServRuntime, realm);
        }
        ServiceActivatorEvent result = new ServiceActivatorEvent(access, (Event)this, 0, inetServRuntime, ServiceActivatorEventType.SERVICE_MODIFY.getCode(), inetServ.getId(), ((InetServTypeRuntime)inetServRuntime.inetServTypeRef.get()).inetServType, inetServ, inetServ, oldState, newState, oldOptionSet, newOptionSet, this.getAccessCode());
        result.setConnectionRuntime(connectionRuntime);
        return result;
    }

    protected String getPackageName() {
        return InetSaServModifyEvent.PACKAGE_NAME;
    }

    protected int getPartitionValue() {
        return this.deviceId;
    }

    public boolean isForce() {
        return this.force;
    }

    public Set<Integer> getOldOptions() {
        return this.oldOptions;
    }

    public void setOldOptions(Set<Integer> oldOptions) {
        this.oldOptions = oldOptions;
    }
}

