/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.recalculate.day;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.RangeCleaner;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.RecalculateDAO;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.RecalculateTask;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.SessionRecalculateTarifficationManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.RecalculateDayDAO;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.RecalculateDayTask;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.TrafficMaxRecalculateDayManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.TrafficMaxTarrificationDayManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.TrafficRangeRecalculateDayManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.TrafficRangeTarrificationDayManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntimeMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Pair;

public class SessionRecalculateDayTarifficationManager
extends SessionRecalculateTarifficationManager<TrafficRangeRecalculateDayManager> {
    public SessionRecalculateDayTarifficationManager(Accounting accounting, int idDivizor, int idRemainder, Set<Integer> cids, Date dateFrom, Date dateTo) throws BGException {
        super(accounting, idDivizor, idRemainder, cids, dateFrom, dateTo);
        int day = TimeUtils.convertDateToCalendar((Date)dateFrom).get(5);
        Date month = TimeUtils.getStartMonth((Date)dateFrom);
        accounting.tariffContext.maxTrafficManager = new TrafficMaxTarrificationDayManager(accounting.moduleId, month, day);
        accounting.tariffContext.rangedTrafficManager = new TrafficRangeTarrificationDayManager(accounting.moduleId, month, day);
    }

    @Override
    protected RecalculateDAO initDAO(Connection con) throws SQLException {
        RecalculateDayDAO dao = new RecalculateDayDAO(this.dateFrom, this.dateTo, this.accounting.moduleId, con);
        ((RecalculateDAO)dao).init();
        return dao;
    }

    @Override
    protected void initMaxAndRangeManagers(Connection con) throws SQLException {
        this.maxRecalculateManager = new TrafficMaxRecalculateDayManager(con, this.dateFrom, this.dateTo, this.accounting.moduleId, this.accounting.tariffContext.maxTrafficManager);
        this.rangeRecalculateManager = new TrafficRangeRecalculateDayManager(con, this.dateFrom, this.dateTo, this.accounting.moduleId, this.accounting.tariffContext.rangedTrafficManager);
    }

    @Override
    protected String addDetailFilter() {
        return " AND detail.day >= ? AND detail.day <= ?";
    }

    @Override
    protected int addDetailFilterParams(PreparedStatement ps) throws SQLException {
        Calendar calFrom = TimeUtils.convertDateToCalendar((Date)this.dateFrom);
        Calendar calTo = TimeUtils.convertDateToCalendar((Date)this.dateTo);
        int dayTo = TimeUtils.monthsDelta((Date)this.dateFrom, (Date)this.dateTo) == 0 ? calTo.get(5) - 1 : calFrom.getActualMaximum(5);
        int idx = 1;
        ps.setInt(idx++, calFrom.get(5));
        ps.setInt(idx++, dayTo);
        return idx;
    }

    @Override
    protected RecalculateTask createTask(InetServRuntimeMap inetServRuntimeMap, InetDeviceRuntimeMap deviceRuntimeMap) throws SQLException {
        return new RecalculateDayTask(this, this.accounting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeAllExtraData(Connection con) throws BGException, SQLException {
        int yy = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(1);
        int mm = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(2) + 1;
        RecalculateDAO recalculateDAO = this.initDAO(con);
        BalanceDao balanceDao = new BalanceDao(con);
        this.initMaxAndRangeManagers(con);
        try {
            recalculateDAO.removeAllExtraData(this.getInetServiceSet(), this.cids, this.idDivizor, this.idRemainder, this.affectedContracts);
            this.maxRecalculateManager.removeAllExtraData(this.dateFrom, this.cids, this.idDivizor, this.idRemainder, this.affectedContracts);
            ((RangeCleaner)this.rangeRecalculateManager).removeAllExtraData(this.dateFrom, this.cids, this.idDivizor, this.idRemainder, this.affectedContracts);
            Set<Pair<Integer, Integer>> contractsForUpdateBalance = recalculateDAO.getContractsForUpdateBalance();
            for (Pair<Integer, Integer> pair : contractsForUpdateBalance) {
                Integer contractId = (Integer)pair.getFirst();
                Integer superContractId = (Integer)pair.getSecond();
                ((RecalculateDayDAO)recalculateDAO).updateContractAccount(contractId, yy, mm, this.getInetServiceSet());
                BigDecimal balanceAccount = balanceDao.setBalanceAccount(contractId.intValue(), superContractId.intValue(), yy, mm);
                this.accounting.balanceEP.publish((Event)new ContractBalanceChangedEvent(contractId.intValue(), 2, yy, mm, balanceAccount));
            }
        }
        finally {
            this.maxRecalculateManager.close();
            ((TrafficRangeRecalculateDayManager)this.rangeRecalculateManager).close();
            recalculateDAO.recycle();
            balanceDao.recycle();
        }
    }
}

