/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.recalculate.part;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.RangeCleaner;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.RecalculateDAO;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.RecalculateTask;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.SessionRecalculateDayTarifficationManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.TrafficRangeRecalculateDayManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.part.RecalculateCurrentMonthPartTask;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.part.TrafficMaxRecalculateCurrentMonthPartManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.part.TrafficRangeRecalculateCurrentMonthPartManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntimeMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Pair;

public class SessionRecalculateCurrentMonthPartTarifficationManager
extends SessionRecalculateDayTarifficationManager {
    ConcurrentMap<Integer, Integer> changedContractsAndSubs = new ConcurrentHashMap<Integer, Integer>();

    public SessionRecalculateCurrentMonthPartTarifficationManager(Accounting accounting, int idDivizor, int idRemainder, Set<Integer> cids, Date dateFrom, Date dateTo) throws BGException {
        super(accounting, idDivizor, idRemainder, cids, dateFrom, dateTo);
    }

    public Map<Integer, Integer> getChangedContractsAndSubs() {
        return this.changedContractsAndSubs;
    }

    @Override
    protected void initMaxAndRangeManagers(Connection con) throws SQLException {
        this.maxRecalculateManager = new TrafficMaxRecalculateCurrentMonthPartManager(con, this.dateFrom, this.dateTo, this.accounting.moduleId, this.accounting.tariffContext.maxTrafficManager);
        this.rangeRecalculateManager = new TrafficRangeRecalculateCurrentMonthPartManager(con, this.dateFrom, this.dateTo, this.accounting.moduleId, this.accounting.tariffContext.rangedTrafficManager);
    }

    @Override
    protected RecalculateTask createTask(InetServRuntimeMap inetServRuntimeMap, InetDeviceRuntimeMap deviceRuntimeMap) throws SQLException {
        return new RecalculateCurrentMonthPartTask(this, this.accounting, this.changedContractsAndSubs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeAllExtraData(Connection con) throws BGException, SQLException {
        int yy = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(1);
        int mm = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(2) + 1;
        RecalculateDAO recalculateDAO = this.initDAO(con);
        this.initMaxAndRangeManagers(con);
        BalanceDao balanceDao = new BalanceDao(con);
        try {
            recalculateDAO.removeAllExtraData(this.getInetServiceSet(), this.cids, this.idDivizor, this.idRemainder, this.affectedContracts);
            this.maxRecalculateManager.removeAllExtraData(this.dateFrom, this.cids, this.idDivizor, this.idRemainder, this.affectedContracts);
            ((RangeCleaner)this.rangeRecalculateManager).removeAllExtraData(this.dateFrom, this.cids, this.idDivizor, this.idRemainder, this.affectedContracts);
            HashSet contractsForUpdateBalance = new HashSet();
            for (Pair pair : contractsForUpdateBalance) {
                Integer contractId = (Integer)pair.getFirst();
                Integer superContractId = (Integer)pair.getSecond();
                this.changedContractsAndSubs.put(contractId, superContractId);
            }
        }
        finally {
            balanceDao.recycle();
            this.maxRecalculateManager.close();
            ((TrafficRangeRecalculateDayManager)this.rangeRecalculateManager).close();
            recalculateDAO.recycle();
        }
    }
}

