/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.worker;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionCallRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.worker.AccountingWorkerTask;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaStateModifyEvent;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.FrequencyCounter;

public class SessionCountTrackingWorker
extends AccountingWorkerTask {
    private static final Logger logger = LogManager.getLogger();
    private final Accounting accounting;
    private final Set<Integer> servTypeIds;
    private Iterator<InetServRuntime> iterator;
    private final FrequencyCounter trackedPerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);

    public SessionCountTrackingWorker(Accounting accounting, ScheduledExecutorService scheduledExecutorService, ParameterMap params) {
        super(scheduledExecutorService, "", params);
        this.accounting = accounting;
        Set servTypeIds = Utils.toIntegerSet((String)params.get("servTypeIds", null));
        this.servTypeIds = servTypeIds == null || servTypeIds.size() == 0 ? null : servTypeIds;
        logger.info("Add session count worker: delay=" + this.getDelay() + ", batchSize=" + this.batchSize);
    }

    protected void runImpl() throws BGException {
        logger.trace("Run session count tracking...");
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.iterator = this.accounting.getInetServRuntimeMap().values().iterator();
        }
        EventProcessor ep = EventProcessor.getInstance();
        long millis = System.currentTimeMillis();
        ConnectionSet connectionSet = ((ServerContext)this.context).getConnectionSet();
        InetDeviceRuntime rootDeviceRuntime = this.accounting.deviceMap.get(this.accounting.rootDeviceId);
        int count = 0;
        int size = this.batchSize;
        while (count < size && this.iterator.hasNext()) {
            InetServRuntime inetServRuntime = this.iterator.next();
            if (!SessionCountTrackingWorker.process0(this.accounting, connectionSet, ep, rootDeviceRuntime, inetServRuntime, millis, this.servTypeIds, 100L)) continue;
            ++count;
        }
        long millis2 = System.currentTimeMillis();
        long duration = millis2 - millis;
        this.trackedPerMinute.add(millis2, (long)count);
        this.processTimePerMinute.add(millis2, duration);
        this.processTimePerTenMinutes.add(millis2, duration);
        this.invokePerMinute.add(millis2, 1L);
        this.invokePerTenMinutes.add(millis2, 1L);
        if (logger.isDebugEnabled() && count > 0) {
            logger.debug("Tracked " + count + " servs for session count for " + duration + " ms.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean process0(Accounting accounting, ConnectionSet connectionSet, EventProcessor ep, InetDeviceRuntime rootDeviceRuntime, InetServRuntime inetServRuntime, long millis, Set<Integer> servTypeIds, long lockWaitTimeout) throws BGException {
        block16: {
            InetServ inetServ = inetServRuntime.getInetServ();
            if (servTypeIds != null && !servTypeIds.contains(inetServ.getTypeId())) {
                return false;
            }
            if (rootDeviceRuntime != null && inetServ.getDeviceId() != rootDeviceRuntime.inetDeviceId.intValue() && !rootDeviceRuntime.descendantIds.contains(inetServ.getDeviceId())) {
                return false;
            }
            if (accounting.getDisableServIds().contains(inetServ.getId())) {
                return false;
            }
            if (lockWaitTimeout > 0L) {
                try {
                    if (!inetServRuntime.tryLock(lockWaitTimeout, TimeUnit.MILLISECONDS)) {
                        return false;
                    }
                    break block16;
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            inetServRuntime.lock();
        }
        try {
            List<InetConnectionCallRuntime> connectionList = accounting.connectionMapCall.getByServId(inetServRuntime.inetServId);
            if (connectionList == null) {
                boolean bl = true;
                return bl;
            }
            InetServRuntime parentInetServRuntime = inetServRuntime.getRootInetServRuntime(accounting);
            Iterator<InetConnectionCallRuntime> iterator = connectionList.iterator();
            while (iterator.hasNext()) {
                InetConnectionCallRuntime connectionRuntime;
                InetConnection connection = connectionRuntime.connection;
                connectionRuntime = iterator.next();
                if (accounting.checkSessionCount(parentInetServRuntime, inetServRuntime, connection, connectionRuntime.getRealm(), false)) continue;
                logger.info("Session count > limit for connection " + connection);
                if (millis < connectionRuntime.nextCloseBySessionCountMillis) {
                    logger.info("Already sent connection state modify event.");
                    boolean bl = true;
                    return bl;
                }
                logger.info("Send connection state modify event.");
                ep.publish((Event)new InetSaStateModifyEvent(accounting.moduleId, 0, connection, 0, 3));
                InetDeviceRuntime deviceRuntime = accounting.deviceMap.get(connection.getDeviceId());
                long delaySeconds = deviceRuntime != null ? connectionRuntime.getSuspendTimeout(deviceRuntime) + 20L : 600L;
                connectionRuntime.nextCloseBySessionCountMillis = millis + TimeUnit.MILLISECONDS.convert(delaySeconds, TimeUnit.SECONDS);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            inetServRuntime.unlock();
        }
        return true;
    }

    @MBeanAttribute
    public long getTrackedPerMinute() {
        return this.trackedPerMinute.get(System.currentTimeMillis());
    }
}

