/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpRange;
import ru.bitel.common.model.Node;
import ru.bitel.common.model.Page;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDaoSupport;
import ru.bitel.oss.kernel.entity.server.bean.InetServEntityAttrDaoSupport;

public class InetServDao
extends AbstractEntityDao<InetServ> {
    private final String deviceTable;
    private final String interfaceTable;
    private final String serviceTypeTable;
    private PreparedStatement updateCurrentStatePS = null;
    private PreparedStatement updateCurrentOptionsPS = null;
    private PreparedStatement updateCurrentStateAndOptionsPS = null;

    public InetServDao(Connection con, int moduleId) {
        super(con, moduleId, 0, "inet_serv", "inet_serv", (EntityAttrDaoSupport)new InetServEntityAttrDaoSupport());
        this.deviceTable = "inet_device_tree_" + moduleId;
        this.interfaceTable = "inet_interface_" + moduleId;
        this.serviceTypeTable = "inet_serv_type_" + moduleId;
    }

    public InetServ getInetServFromRS(ResultSet rs, boolean contractLoad, boolean typeAndDeviceLoad) throws SQLException, BGException {
        return this.getInetServFromRS(rs, contractLoad, typeAndDeviceLoad, false);
    }

    public InetServ getInetServFromRS(ResultSet rs, boolean contractLoad, boolean typeAndDeviceLoad, boolean entityAttributesLoad) throws SQLException, BGException {
        InetServ result = new InetServ();
        result.setId(rs.getInt("id"));
        result.setParentId(rs.getInt("parentId"));
        result.setContractId(rs.getInt("contractId"));
        if (contractLoad) {
            if (rs.getInt("contract.sub_mode") == 0) {
                result.setSuperContractId(rs.getInt("contract.scid"));
            }
            result.setContractTitle(rs.getString("contract.title"));
            result.setContractComment(rs.getString("contract.comment"));
        }
        result.setTypeId(rs.getInt("typeId"));
        result.setDeviceId(rs.getInt("deviceId"));
        result.setInterfaceId(rs.getInt("interfaceId"));
        result.setVlan(rs.getInt("vlan"));
        result.setIdentifierList(Utils.toList((String)rs.getString("identifier")));
        result.setMacAddressListBytes(rs.getBytes("macAddress"));
        result.setIpResourceId(rs.getInt("ipResourceId"));
        result.setIpResourceSubscriptionId(rs.getInt("ipResourceSubscriptionId"));
        result.setAddressFrom(rs.getBytes("addressFrom"));
        result.setAddressTo(rs.getBytes("addressTo"));
        result.setLogin(rs.getString("login"));
        result.setPassword(rs.getString("password"));
        result.setDateFrom((java.util.Date)rs.getDate("dateFrom"));
        result.setDateTo((java.util.Date)rs.getDate("dateTo"));
        result.setStatus(rs.getInt("status"));
        result.setComment(rs.getString("comment"));
        result.setSessionCountLimit(rs.getInt("sessionCountLimit"));
        result.setTitle(rs.getString("title"));
        if (typeAndDeviceLoad) {
            result.setTypeTitle(rs.getString("typeTitle"));
            result.setDeviceTitle(rs.getString("deviceTitle"));
            result.setInterfaceTitle(rs.getString("interfaceTitle"));
        }
        result.setDeviceState(rs.getShort("deviceState"));
        result.setAccessCode(rs.getInt("accessCode"));
        result.setDeviceOptions(Utils.toIntegerSet((String)rs.getString("deviceOptions")));
        result.setData(rs.getString("data"));
        result.setConfig(rs.getString("config"));
        result.setContractObjectId(rs.getInt("contractObjectId"));
        if (entityAttributesLoad) {
            result.setEntitySpecId(rs.getInt("entitySpecId"));
            result.setEntityAttributes(this.getEntityAttributes(result.getEntitySpecId(), result.getId(), false));
        }
        return result;
    }

    protected InetServ getById(int id) throws BGException, SQLException {
        PreparedStatement ps = this.getByIdPS;
        if (ps == null) {
            ps = this.getByIdPS = this.con.prepareStatement("SELECT serv.*, contract.scid, contract.sub_mode, t.entitySpecId as entitySpecId FROM `" + this.tableName + "` AS serv LEFT JOIN `contract` ON serv.contractId=contract.id LEFT JOIN `" + this.serviceTypeTable + "` AS t ON t.id=serv.typeId WHERE serv.id=?");
        }
        ps.setInt(1, id);
        InetServ result = null;
        try (ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result = this.getInetServFromRS(rs, false, false, true);
            }
        }
        return result;
    }

    protected void updateImpl(InetServ inetServ) throws BGException, SQLException {
        boolean insert = inetServ.getId() < 1;
        String query = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET parentId=?, contractId=?, typeId=?, deviceId=?, interfaceId=?, vlan=?, identifier=?, macAddress=?, ipResourceId=?, ipResourceSubscriptionId=?, addressFrom=?, addressTo=?, login=?, password=?, dateFrom=?, dateTo=?, comment=?, sessionCountLimit=?, status=?, title=?, config=?, contractObjectId=?, data=?" + (insert ? ", deviceState=?" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int parameterIndex = 1;
            ps.setInt(parameterIndex++, inetServ.getParentId());
            ps.setInt(parameterIndex++, inetServ.getContractId());
            ps.setInt(parameterIndex++, inetServ.getTypeId());
            ps.setInt(parameterIndex++, inetServ.getDeviceId());
            ps.setInt(parameterIndex++, inetServ.getInterfaceId());
            ps.setInt(parameterIndex++, inetServ.getVlan());
            List identifierList = inetServ.getIdentifierList();
            ps.setString(parameterIndex++, identifierList != null && identifierList.size() > 0 ? Utils.toString((Iterable)identifierList) : null);
            ps.setBytes(parameterIndex++, inetServ.getMacAddressListBytes());
            ps.setInt(parameterIndex++, inetServ.getIpResourceId());
            ps.setInt(parameterIndex++, inetServ.getIpResourceSubscriptionId());
            if (inetServ.getAddressFrom() != null) {
                ps.setBlob(parameterIndex++, new ByteArrayInputStream(inetServ.getAddressFrom()));
            } else {
                ps.setNull(parameterIndex++, 2004);
            }
            if (inetServ.getAddressTo() != null) {
                ps.setBlob(parameterIndex++, new ByteArrayInputStream(inetServ.getAddressTo()));
            } else {
                ps.setNull(parameterIndex++, 2004);
            }
            ps.setString(parameterIndex++, inetServ.getLogin());
            ps.setString(parameterIndex++, inetServ.getPassword());
            ps.setDate(parameterIndex++, TimeUtils.convertDateToSqlDate((java.util.Date)inetServ.getDateFrom()));
            ps.setDate(parameterIndex++, TimeUtils.convertDateToSqlDate((java.util.Date)inetServ.getDateTo()));
            ps.setString(parameterIndex++, Utils.maskNull((String)inetServ.getComment()));
            ps.setInt(parameterIndex++, inetServ.getSessionCountLimit());
            ps.setInt(parameterIndex++, inetServ.getStatus());
            ps.setString(parameterIndex++, inetServ.getTitle());
            ps.setString(parameterIndex++, Utils.isBlankString((String)inetServ.getConfig()) ? null : inetServ.getConfig());
            ps.setInt(parameterIndex++, inetServ.getContractObjectId());
            ps.setString(parameterIndex++, inetServ.getData() == null ? "{}" : inetServ.getData());
            if (insert) {
                ps.setInt(parameterIndex++, -1);
            } else {
                ps.setInt(parameterIndex++, inetServ.getId());
            }
            ps.executeUpdate();
            if (insert) {
                inetServ.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public List<InetServ> list(Set<Integer> servIds) throws BGException {
        ArrayList<InetServ> result = new ArrayList<InetServ>(50);
        if (servIds.size() == 0) {
            return result;
        }
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT serv.*, contract.scid, contract.sub_mode, contract.title, contract.comment  FROM inet_serv_" + this.moduleId + " AS serv LEFT JOIN " + this.serviceTypeTable + " AS serv_type ON serv_type.id=serv.typeId LEFT JOIN contract ON serv.contractId=contract.id WHERE serv.id IN (" + Utils.toString(servIds) + ")");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getInetServFromRS(rs, true, false));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<InetServ> listRuntime(int deviceId, Set<Integer> servIds, Set<Integer> contractIds) throws BGException {
        ArrayList<InetServ> result = new ArrayList<InetServ>(50);
        try {
            String query = "SELECT serv.* FROM inet_serv_" + this.moduleId + " AS serv LEFT JOIN " + this.serviceTypeTable + " AS serv_type ON serv_type.id=serv.typeId LEFT JOIN contract ON serv.contractId=contract.id WHERE serv.deviceId=? ";
            if (servIds != null && servIds.size() > 0) {
                query = query + " AND serv.id IN (" + Utils.toString(servIds) + ") ";
            }
            if (contractIds != null && contractIds.size() > 0) {
                query = query + " AND serv.contractId IN (" + Utils.toString(contractIds) + " ) ";
            }
            query = query + " ORDER BY parentId ASC";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, deviceId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                InetServ inetServ = this.getInetServFromRS(rs, false, false);
                inetServ.setComment(null);
                result.add(inetServ);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<InetServ> list(int contractId) throws BGException {
        return this.list(contractId, null);
    }

    public List<InetServ> list(int contractId, String orderBy) throws BGException {
        ArrayList<InetServ> result = new ArrayList<InetServ>(50);
        try {
            String query = "SELECT serv.*, serv.title as title, serv_type.title AS typeTitle, device.title AS deviceTitle, interface.title AS interfaceTitle FROM " + this.tableName + " AS serv LEFT JOIN " + this.serviceTypeTable + " AS serv_type ON serv.typeId=serv_type.id LEFT JOIN " + this.deviceTable + " AS device ON serv.deviceId=device.id LEFT JOIN inv_device_port_" + this.moduleId + " as interface ON interface.deviceId=device.invDeviceId AND interface.port=serv.interfaceId WHERE serv.contractId=?";
            if (Utils.notBlankString((String)orderBy)) {
                query = query + " ORDER BY " + orderBy;
            }
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getInetServFromRS(rs, false, true));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            this.processException(e);
        }
        return result;
    }

    public InetServ tree(int contractId) throws BGException {
        List<InetServ> list = this.list(contractId);
        return (InetServ)TreeUtils.tree(list, (Node)new InetServ());
    }

    public List<InetServ> list(String login, java.util.Date dateFrom, java.util.Date dateTo) throws BGException {
        try {
            ArrayList<InetServ> result = new ArrayList<InetServ>();
            String query = "SELECT serv.*, contract.scid, contract.sub_mode, contract.title, contract.comment  FROM " + this.tableName + " as serv LEFT JOIN contract ON serv.contractId=contract.id  WHERE serv.login=? AND (serv.dateFrom IS NULL OR ? IS NULL OR serv.dateFrom<=?) AND (serv.dateTo IS NULL OR ? IS NULL OR serv.dateTo>=?)";
            PreparedStatement ps = this.con.prepareStatement(query);
            int idx = 1;
            ps.setString(idx++, login);
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((java.util.Date)dateTo));
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((java.util.Date)dateTo));
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((java.util.Date)dateFrom));
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((java.util.Date)dateFrom));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getInetServFromRS(rs, true, false));
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<InetServ> list(Set<Integer> deviceIds, java.util.Date dateFrom, java.util.Date dateTo, Set<Integer> contractIds) throws BGException {
        try {
            ArrayList<InetServ> result = new ArrayList<InetServ>();
            String query = "SELECT serv.*, contract.scid, contract.sub_mode, contract.title, contract.comment  FROM " + this.tableName + " as serv LEFT JOIN contract ON serv.contractId=contract.id  WHERE serv.deviceId IN (" + Utils.toString(deviceIds) + " )   AND (serv.dateFrom IS NULL OR ? IS NULL OR serv.dateFrom<=?)  AND (serv.dateTo IS NULL OR ? IS NULL OR serv.dateTo>=?) ";
            if (contractIds != null && contractIds.size() > 0) {
                query = query + " serv.contractId IN " + Utils.toString(contractIds) + ")";
            }
            PreparedStatement ps = this.con.prepareStatement(query);
            int idx = 1;
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((java.util.Date)dateTo));
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((java.util.Date)dateTo));
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((java.util.Date)dateFrom));
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((java.util.Date)dateFrom));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getInetServFromRS(rs, true, false));
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    @Deprecated
    public InetServ get(java.util.Date time, String login) throws SQLException, BGException {
        InetServ result = null;
        String query = "SELECT serv.*, contract.scid, contract.sub_mode, contract.title, contract.comment  FROM " + this.tableName + " as serv LEFT JOIN contract ON serv.contractId=contract.id  WHERE serv.login=? AND (serv.dateFrom IS NULL OR serv.dateFrom<=?) AND (serv.dateTo IS NULL OR serv.dateTo>=?)";
        PreparedStatement ps = this.con.prepareStatement(query);
        Date sqlDate = TimeUtils.convertDateToSqlDate((java.util.Date)time);
        ps.setString(1, login);
        ps.setDate(2, sqlDate);
        ps.setDate(3, sqlDate);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = this.getInetServFromRS(rs, true, false);
        }
        rs.close();
        ps.close();
        return result;
    }

    @Deprecated
    public InetServ get(String login) throws BGException {
        InetServ result = null;
        try {
            String query = "SELECT serv.*, contract.scid, contract.sub_mode, contract.title, contract.comment  FROM " + this.tableName + " as serv LEFT JOIN contract ON serv.contractId=contract.id  WHERE serv.login=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, login);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getInetServFromRS(rs, false, false);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            this.processException(e);
        }
        return result;
    }

    public void updateDeviceStateAndOptions(int inetServId, short state, Set<Integer> inetOptions, int accessCode) throws BGException {
        try {
            PreparedStatement ps;
            if (state != -1000) {
                if (inetOptions != null) {
                    ps = this.updateCurrentStateAndOptionsPS;
                    if (ps == null) {
                        ps = this.updateCurrentStateAndOptionsPS = this.con.prepareStatement("UPDATE " + this.tableName + " SET deviceState=?, deviceOptions=?, accessCode=? WHERE id=?");
                    }
                    ArrayList<Integer> options = new ArrayList<Integer>(inetOptions);
                    Collections.sort(options);
                    ps.setShort(1, state);
                    ps.setString(2, Utils.toString(options));
                    ps.setInt(3, accessCode);
                    ps.setInt(4, inetServId);
                } else {
                    ps = this.updateCurrentStatePS;
                    if (ps == null) {
                        ps = this.updateCurrentStatePS = this.con.prepareStatement("UPDATE " + this.tableName + " SET deviceState=?, accessCode=? WHERE id=?");
                    }
                    ps.setShort(1, state);
                    ps.setInt(2, accessCode);
                    ps.setInt(3, inetServId);
                }
            } else {
                assert (inetOptions != null);
                ps = this.updateCurrentOptionsPS;
                if (ps == null) {
                    ps = this.updateCurrentOptionsPS = this.con.prepareStatement("UPDATE " + this.tableName + " SET deviceOptions=? WHERE id=?");
                }
                ArrayList<Integer> options = new ArrayList<Integer>(inetOptions);
                Collections.sort(options);
                ps.setString(1, Utils.toString(options));
                ps.setInt(2, inetServId);
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updateIpResource(int inetServId, int ipResource, int ipResourceSubscriptionId) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET ipResourceId=?, ipResourceSubscriptionId=? WHERE id=?");){
            ps.setInt(1, ipResource);
            ps.setInt(2, ipResourceSubscriptionId);
            ps.setInt(3, inetServId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public int lastNumericLogin(int max) throws BGException {
        int login = 0;
        try {
            String query = "SELECT MAX( CAST( login AS UNSIGNED ) ) FROM " + this.tableName + " WHERE (? OR CAST( login AS UNSIGNED )<=?) AND login REGEXP '^[0-9]+$' ";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setBoolean(1, max <= 0);
            ps.setInt(2, max);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                login = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            this.processException(e);
        }
        return login;
    }

    public List<InetServ> list(int deviceState, java.util.Date dateFrom, java.util.Date dateTo) throws BGException {
        return super.list("deviceState=? AND (dateFrom IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR dateTo>=?)", null, new Object[]{deviceState, TimeUtils.convertDateToSqlDate((java.util.Date)dateTo), TimeUtils.convertDateToSqlDate((java.util.Date)dateFrom)});
    }

    public List<InetServ> listToCreate(java.util.Date now) throws BGException {
        return super.list("deviceState=? AND (dateFrom IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR dateTo>=?) AND parentId<=0", null, new Object[]{(short)-1, TimeUtils.convertDateToSqlDate((java.util.Date)now), TimeUtils.convertDateToSqlDate((java.util.Date)now)});
    }

    public List<InetServ> listToCancel(java.util.Date now) throws BGException {
        return super.list("deviceState!=? AND (dateTo IS NOT NULL AND dateTo<?) AND parentId<=0", null, new Object[]{(short)-1, TimeUtils.convertDateToSqlDate((java.util.Date)now)});
    }

    public void deleteForContract(int contractId) throws BGException {
        for (InetServ serv : this.list(contractId)) {
            this.delete(serv.getId());
        }
    }

    public List<InetServ> searchInetServ(String login, IpRange address, int serviceTypeId, int vlan, String name, String identifier, String macAddress, boolean loginStrictCheck) throws BGException {
        ArrayList<InetServ> result = new ArrayList<InetServ>();
        try {
            String query = "SELECT serv.*, serv.title as title, serv_type.title AS typeTitle, device.title AS deviceTitle, interface.title AS interfaceTitle,  contract.sub_mode, contract.scid, contract.title, contract.comment FROM " + this.tableName + " AS serv LEFT JOIN " + this.serviceTypeTable + " AS serv_type ON serv.typeId=serv_type.id LEFT JOIN " + this.deviceTable + " AS device ON serv.deviceId=device.id LEFT JOIN " + this.interfaceTable + " AS interface ON device.deviceTypeId=interface.deviceTypeId AND interface.id=serv.interfaceId  LEFT JOIN contract ON serv.contractId=contract.id WHERE 1=1 ";
            if (Utils.notBlankString((String)login)) {
                query = query + (loginStrictCheck ? " AND serv.login=? " : "AND serv.login LIKE ? ");
            }
            if (address != null) {
                query = query + "AND serv.addressFrom IS NOT NULL AND ( serv.addressTo IS NULL AND serv.addressFrom>=? AND serv.addressFrom<= ? ) OR ( serv.addressTo IS NOT NULL AND serv.addressTo>=? AND serv.addressFrom<=?     ) ";
            }
            if (serviceTypeId > 0) {
                query = query + "AND serv.typeId=? ";
            }
            if (vlan > 0) {
                query = query + "AND serv.vlan=? ";
            }
            if (Utils.notBlankString((String)name)) {
                query = query + "AND serv.title LIKE ? ";
            }
            if (Utils.notBlankString((String)identifier)) {
                query = query + "AND serv.identifier LIKE ? ";
            }
            if (Utils.notBlankString((String)macAddress)) {
                query = query + "AND serv.macAddress=? ";
            }
            PreparedStatement ps = this.con.prepareStatement(query);
            int index = 1;
            if (Utils.notBlankString((String)login)) {
                if (loginStrictCheck) {
                    ps.setString(index++, login.trim());
                } else {
                    ps.setString(index++, "%" + login.trim() + "%");
                }
            }
            if (address != null) {
                ps.setBytes(index++, address.getAddressFrom());
                ps.setBytes(index++, address.getAddressTo());
                ps.setBytes(index++, address.getAddressFrom());
                ps.setBytes(index++, address.getAddressTo());
            }
            if (serviceTypeId > 0) {
                ps.setInt(index++, serviceTypeId);
            }
            if (vlan > 0) {
                ps.setInt(index++, vlan);
            }
            if (Utils.notBlankString((String)name)) {
                ps.setString(index++, "%" + name.trim() + "%");
            }
            if (Utils.notBlankString((String)identifier)) {
                ps.setString(index++, "%" + identifier.trim() + "%");
            }
            if (Utils.notBlankString((String)macAddress)) {
                ps.setBytes(index++, InetServ.parseMacAddress((String)macAddress));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getInetServFromRS(rs, true, true));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            this.processException(e);
        }
        return result;
    }

    public List<InetServ> listDevice(int deviceId) throws BGException {
        ArrayList<InetServ> result = new ArrayList<InetServ>();
        try {
            String query = "SELECT serv.*, contract.title, contract.sub_mode, contract.scid, contract.comment FROM inet_serv_" + this.moduleId + " AS serv INNER JOIN contract as contract ON contract.id=serv.contractId WHERE serv.deviceId = " + deviceId;
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getInetServFromRS(rs, true, false));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<InetServ> listChildren(int parentId) throws BGException {
        return super.list("parentId=?", "id", new Object[]{parentId});
    }

    public void updateMacAddress(int inetServId, byte[] macAddress) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET macAddress=? WHERE id=?");
            ps.setBytes(1, macAddress);
            ps.setInt(2, inetServId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updateIdentifier(int inetServId, List<String> identifierList) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET identifier=? WHERE id=?");
            if (identifierList != null && identifierList.size() > 0) {
                ps.setString(1, Utils.toString(identifierList));
            } else {
                ps.setString(1, null);
            }
            ps.setInt(2, inetServId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<InetServ> listByWrongIpResourceIds(java.util.Date date, Page page) throws BGException {
        try {
            ArrayList<InetServ> result = new ArrayList<InetServ>();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT serv.* FROM inet_serv_" + this.moduleId + " as serv");
            sb.append(" LEFT JOIN inv_ip_resource_" + this.moduleId + " as resource ON serv.ipResourceId=resource.id");
            sb.append(" WHERE serv.addressFrom IS NOT NULL");
            sb.append(" AND (? OR serv.dateTo IS NULL OR serv.dateTo>=?)");
            sb.append(" AND (resource.id IS NULL OR serv.addressFrom<resource.addressFrom OR (IFNULL(serv.addressTo,serv.addressFrom)>resource.addressTo))");
            if (page != null) {
                sb.append(page.sqlLimit());
            }
            try (PreparedStatement ps = this.con.prepareStatement(sb.toString());){
                ps.setBoolean(1, date == null);
                ps.setDate(2, date != null ? TimeUtils.convertDateToSqlDate((java.util.Date)date) : null);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        result.add(this.getInetServFromRS(rs, false, false));
                    }
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    protected InetServ getFromRS(ResultSet rs, boolean loadAttributes) throws SQLException, BGException {
        return this.getInetServFromRS(rs, false, false);
    }

    protected InetServ getFromRSImpl(ResultSet rs) throws SQLException, BGException {
        return null;
    }

    protected InetServ getFromRS(ResultSet rs) throws SQLException, BGException {
        return this.getInetServFromRS(rs, false, false);
    }

    protected InetServ getImpl(int id) throws BGException, SQLException {
        InetServ inetServ = (InetServ)super.getImpl(id);
        return inetServ;
    }
}

