/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.event;

import java.util.Date;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.common.SerialUtils;

@XmlRootElement
public class RequestLogInfoEvent
extends QueueEvent {
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(RequestLogInfoEvent.class);
    @XmlAttribute
    private int accountingRootDeviceId;
    private Date month;
    @XmlAttribute
    private int deviceId;
    private int[] logs = new int[31];

    protected RequestLogInfoEvent() {
    }

    public RequestLogInfoEvent(int moduleId, Date month, int accountingRootDeviceId, int deviceId) {
        super(moduleId, CONTRACT_GLOBAL, 0);
        this.month = month;
        this.accountingRootDeviceId = accountingRootDeviceId;
        this.deviceId = deviceId;
    }

    public int[] getLogs() {
        return this.logs;
    }

    public void addLogs(int[] logs) {
        if (this.logs == null) {
            this.logs = logs;
        } else {
            for (int i = 0; i < 31; ++i) {
                int n = i;
                this.logs[n] = this.logs[n] | logs[i];
            }
        }
    }

    public Date getMonth() {
        return this.month;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("accountingRootDeviceId", this.accountingRootDeviceId);
        message.setIntProperty("deviceId", this.deviceId);
    }
}

