/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn;

import bitel.billing.server.load.bean.Source;
import bitel.billing.server.netflow.ipn.NetFlowSetup;
import bitel.billing.server.netflow.ipn.SourceSelector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLog;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLogger;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.logging.BGNestedContext;

public class TaskGenerator
extends Thread {
    private Logger logger = LogManager.getLogger((String)"generator");
    private NetFlowSetup setup;
    private List<SourceSelector> ss;
    private IPHourlyDataLogger dataLogger;
    private Calendar lastTime;
    private int generateMinutes = 0;

    public TaskGenerator(NetFlowSetup setup, List<SourceSelector> ss, IPHourlyDataLogger dataLogger, boolean load) {
        this.setup = setup;
        this.ss = ss;
        this.dataLogger = dataLogger;
        this.generateMinutes = setup.getInt("generate.minutes", this.generateMinutes);
        if (load) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BGNestedContext.push((String)"taskGenerator");
        this.logger.info("Starting generator process tasks..");
        this.lastTime = new GregorianCalendar();
        GregorianCalendar now = this.lastTime;
        while (true) {
            boolean minGenerate;
            this.logger.debug("Looking..");
            now = new GregorianCalendar();
            boolean bl = minGenerate = this.generateMinutes > 0 && (now.getTimeInMillis() - this.lastTime.getTimeInMillis()) / (long)(60000 * this.generateMinutes) > 0L;
            if (minGenerate || now.get(11) != this.lastTime.get(11)) {
                Connection con = this.setup.getDBConnectionFromPool();
                try {
                    Calendar dtime = (Calendar)this.lastTime.clone();
                    TimeUtils.clear_MIN_MIL_SEC((Calendar)dtime);
                    long hour = dtime.getTimeInMillis() / 3600000L * 3600000L;
                    Future flushFuture = this.dataLogger.flush(Long.valueOf(hour));
                    this.logger.info("Flush dataLog writers...");
                    flushFuture.get();
                    this.logger.info("Flush dataLog writers ok");
                    this.logger.info("Generating process tasks..");
                    this.logger.debug("mid => " + this.setup.getModuleId() + "; time => " + TimeUtils.format((Calendar)dtime, (String)"dd.MM.yyyy HH"));
                    HashSet<Integer> sourceSet = new HashSet<Integer>();
                    for (SourceSelector selector : this.ss) {
                        for (Source source : selector.getSourceList()) {
                            if (!sourceSet.add(source.getId())) continue;
                            this.logger.debug("source => " + source.toString());
                            this.addTaskProcessAndSourceData(dtime, source.getId());
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    ServerUtils.closeConnection((Connection)con);
                }
                this.lastTime = now;
            }
            Connection userTaskCon = this.setup.getDBConnectionFromPool();
            try {
                HashSet<Integer> sourceSet = new HashSet<Integer>();
                for (SourceSelector selector : this.ss) {
                    for (Source source : selector.getSourceList()) {
                        if (!sourceSet.add(source.getId())) continue;
                        this.logger.debug("source => " + source.toString());
                        this.checkUserSourceLoadTasks(userTaskCon, source.getId());
                    }
                }
            }
            finally {
                ServerUtils.closeConnection((Connection)userTaskCon);
            }
            try {
                TaskGenerator.sleep(60000L);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void checkUserSourceLoadTasks(Connection con, int sourceId) {
        try {
            String query = "SELECT tl.id, tl.dt, tl.param FROM task_load as tl INNER JOIN source ON source.id=tl.param AND source.source_type = 3 AND source.id=?";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setInt(1, sourceId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int task_id = rs.getInt(1);
                int source_id = rs.getInt(3);
                Calendar hour = TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp(2));
                this.addTaskProcessAndSourceData(hour, source_id);
                this.removeLoadTask(con, task_id);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void removeLoadTask(Connection con, int id) {
        try {
            String query = "DELETE FROM task_load WHERE id=?";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskProcessAndSourceData(Calendar dtime, int source) {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            this.logger.info("Add process task " + this.setup.getModuleId() + ":" + source + " " + TimeUtils.format((Calendar)dtime, (String)"dd.MM.yyyy HH"));
            Object query = "DELETE FROM task_proccess WHERE mid=? AND dt=? AND param=?";
            PreparedStatement psDeleteTaskProcess = con.prepareStatement((String)query);
            psDeleteTaskProcess.setInt(1, this.setup.getModuleId());
            psDeleteTaskProcess.setTimestamp(2, TimeUtils.convertCalendarToTimestamp((Calendar)dtime));
            psDeleteTaskProcess.setInt(3, source);
            psDeleteTaskProcess.executeUpdate();
            this.logger.info("Generate source data..");
            String source_data = "source_data_" + TimeUtils.format((Calendar)dtime, (String)"yyyyMM");
            if (!ServerUtils.tableExists((Connection)con, (String)source_data)) {
                query = "CREATE TABLE IF NOT EXISTS " + source_data + " ( source_id int(10) unsigned NOT NULL default '0', dt datetime NOT NULL default '0000-00-00 00:00:00', size bigint(20) NOT NULL default '0', modtime bigint(20) NOT NULL default '0', process tinyint(4) NOT NULL default '0', KEY source_id (source_id,dt) )";
                Statement st = con.createStatement();
                st.execute((String)query);
                st.close();
            }
            query = "DELETE FROM " + source_data + " WHERE source_id=? AND dt=?";
            PreparedStatement psDeleteSourceData = con.prepareStatement((String)query);
            psDeleteSourceData.setInt(1, source);
            psDeleteSourceData.setTimestamp(2, TimeUtils.convertCalendarToTimestamp((Calendar)dtime));
            psDeleteSourceData.executeUpdate();
            psDeleteSourceData.close();
            IPHourlyDataLog dataLog = new IPHourlyDataLog((ParameterMap)this.setup, source, dtime);
            if (dataLog.exists()) {
                long size = dataLog.length();
                long time = dataLog.lastModified();
                query = "INSERT INTO " + source_data + " ( source_id, dt, size, modtime ) VALUES ( ?, ?, ?, ? )";
                PreparedStatement psInsertSourceData = con.prepareStatement((String)query);
                psInsertSourceData.setInt(1, source);
                psInsertSourceData.setTimestamp(2, TimeUtils.convertCalendarToTimestamp((Calendar)dtime));
                psInsertSourceData.setLong(3, size);
                psInsertSourceData.setLong(4, time);
                psInsertSourceData.executeUpdate();
                psInsertSourceData.close();
                query = "INSERT INTO task_proccess ( mid, dt, param ) VALUES ( ?, ?, ? )";
                PreparedStatement psInsertTaskProccess = con.prepareStatement((String)query);
                psInsertTaskProccess.setInt(1, this.setup.getModuleId());
                psInsertTaskProccess.setTimestamp(2, TimeUtils.convertCalendarToTimestamp((Calendar)dtime));
                psInsertTaskProccess.setInt(3, source);
                psInsertTaskProccess.executeUpdate();
                psInsertTaskProccess.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }
}

