/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import bitel.billing.server.contract.bean.ContractMemo;
import bitel.billing.server.contract.bean.ContractMemoManager;
import bitel.billing.server.contract.bean.ContractUtils;
import bitel.billing.server.load.bean.Source;
import bitel.billing.server.load.bean.SourceManager;
import bitel.billing.server.util.Iter;
import bitel.billing.server.util.MonthForRecalc;
import bitel.billing.server.util.db.ColumnValue;
import bitel.billing.server.util.db.TableCopier;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.ipn.common.bean.AddressRange;
import ru.bitel.bgbilling.modules.ipn.server.IPNRecalculator;
import ru.bitel.bgbilling.modules.ipn.server.MaxRecalculator;
import ru.bitel.bgbilling.modules.ipn.server.bean.Iface;
import ru.bitel.bgbilling.modules.ipn.server.bean.IfaceManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.RangeIface;
import ru.bitel.bgbilling.modules.ipn.server.bean.RangeIfaceManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

public class AddressRangeManager {
    protected Connection con;
    protected int mid = -1;
    private RangeIfaceManager rangeMan = null;
    private IfaceManager ifaceMan = null;
    private SourceManager sourceMan = null;

    public AddressRangeManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public List<AddressRange> getContractAddressRange(int cid) throws SQLException {
        return this.getContractAddressRange(cid, null, 0, null);
    }

    public List<AddressRange> getObjectAddressRange(int objectId) throws BGException {
        ArrayList<AddressRange> result = new ArrayList<AddressRange>();
        String query = null;
        PreparedStatement ps = null;
        try {
            query = "SELECT * FROM ipn_user_range_" + this.mid + " WHERE object_id=? ORDER BY addr1, date1";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, objectId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AddressRange range = new AddressRange();
                result.add(range);
                this.loadFromResultSet(rs, range);
            }
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    private List<AddressRange> getContractAddressRange(int cid, Calendar date, int objectId, Boolean isNet) throws SQLException {
        return this.getContractAddressRange(cid, date, null, objectId, isNet);
    }

    public List<AddressRange> getContractAddressRange(int cid, java.util.Date dateFrom, java.util.Date dateTo) throws SQLException {
        return this.getContractAddressRange(cid, TimeUtils.convertDateToCalendar((java.util.Date)dateFrom), TimeUtils.convertDateToCalendar((java.util.Date)dateTo), 0, null);
    }

    private List<AddressRange> getContractAddressRange(int cid, Calendar dateFrom, Calendar dateTo, int objectId, Boolean isNet) throws SQLException {
        ArrayList<AddressRange> result = new ArrayList<AddressRange>();
        String query = null;
        PreparedStatement ps = null;
        query = "SELECT * FROM ipn_user_range_" + this.mid + " WHERE cid=? ";
        if (objectId > 0) {
            query = query + " AND object_id=" + objectId;
        }
        if (isNet != null) {
            query = isNet != false ? query + " AND mask >= 0 " : query + " AND (mask IS NULL OR  mask < 0 )";
        }
        if (dateFrom != null && dateTo == null) {
            query = query + " AND ( date1 IS NULL OR date1<=? )  AND (date2 IS NULL OR date2>=?) ";
        } else if (dateFrom != null && dateTo != null) {
            query = query + " AND ( date1<=? OR date1 IS NULL OR ? IS NULL ) AND ( date2>=? OR date2 IS NULL OR ? IS NULL )";
        }
        query = query + " ORDER BY addr1, date1";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, cid);
        if (dateFrom != null && dateTo == null) {
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)dateFrom));
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)dateFrom));
        } else if (dateFrom != null && dateTo != null) {
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)dateTo));
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)dateTo));
            ps.setDate(4, TimeUtils.convertCalendarToSqlDate((Calendar)dateFrom));
            ps.setDate(5, TimeUtils.convertCalendarToSqlDate((Calendar)dateFrom));
        }
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            AddressRange range = new AddressRange();
            result.add(range);
            this.loadFromResultSet(rs, range);
        }
        ps.close();
        return result;
    }

    public List<AddressRange> getContractAddressRange(int cid, Calendar date, int objectId) throws SQLException {
        return this.getContractAddressRange(cid, date, objectId, null);
    }

    public List<AddressRange> getContractNets(int cid, Calendar date, int objectId) throws SQLException {
        return this.getContractAddressRange(cid, date, objectId, true);
    }

    public List<AddressRange> getContractRanges(int cid, Calendar date, int objectId) throws SQLException {
        return this.getContractAddressRange(cid, date, objectId, false);
    }

    public StringBuilder getSourceIface(AddressRange arange) {
        if (this.rangeMan == null) {
            this.rangeMan = new RangeIfaceManager(this.con, this.mid);
            this.ifaceMan = new IfaceManager(this.con, this.mid);
            this.sourceMan = new SourceManager(this.con);
        }
        StringBuilder ifaces = new StringBuilder("[");
        Set<RangeIface> ranges = this.rangeMan.getAdressRangeIfaces(arange.getId());
        int id = -1;
        for (RangeIface range : ranges) {
            if (id != range.getSourceId()) {
                Source source;
                if (id != -1) {
                    ifaces.append("; ");
                }
                if ((source = this.sourceMan.getSource(id = range.getSourceId())) != null) {
                    ifaces.append(source.getTitle());
                }
                ifaces.append(": ");
                Iface iface = this.ifaceMan.getIface(id, range.getIfaceId());
                if (iface == null) continue;
                ifaces.append(iface.getTitle());
                continue;
            }
            ifaces.append(", ");
            Iface iface = this.ifaceMan.getIface(range.getSourceId(), range.getIfaceId());
            if (iface != null) {
                ifaces.append(iface.getTitle());
                continue;
            }
            ifaces.append("NOT_EXISTS[");
            ifaces.append(range.getIfaceId());
            ifaces.append("]");
        }
        ifaces.append("]");
        return ifaces;
    }

    public AddressRange getAddressRange(int id) throws BGException {
        AddressRange result = null;
        String query = null;
        PreparedStatement ps = null;
        try {
            query = "SELECT * FROM ipn_user_range_" + this.mid + " WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new AddressRange();
                this.loadFromResultSet(rs, result);
            }
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public void deleteContractAddressRange(int id) throws BGException {
        String query = null;
        PreparedStatement ps = null;
        try {
            query = "DELETE FROM ipn_user_range_" + this.mid + " WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected void loadFromResultSet(ResultSet rs, AddressRange range) throws SQLException {
        range.setId(rs.getInt("id"));
        range.setContractId(rs.getInt("cid"));
        range.setObjectId(rs.getInt("object_id"));
        range.setAddr1(rs.getLong("addr1"));
        range.setAddr2(rs.getLong("addr2"));
        range.setPort1(rs.getInt("port1"));
        range.setPort2(rs.getInt("port2"));
        range.setDate1(TimeUtils.convertDateToCalendar((java.util.Date)rs.getDate("date1")));
        range.setDate2(TimeUtils.convertDateToCalendar((java.util.Date)rs.getDate("date2")));
        range.setComment(rs.getString("comment"));
        range.setPlanId(rs.getInt("plan_id"));
        range.setPersonalPlanId(rs.getInt("pers_plan_id"));
        range.setMask(rs.getInt("mask"));
        range.setResourceId(rs.getInt("resource_id"));
    }

    public String checkAddress(String id, AddressRange address, int zoneId, int sourceId, int iface) throws BGException {
        StringBuffer conflicts = new StringBuffer();
        String query = null;
        PreparedStatement ps = null;
        ContractUtils cu = new ContractUtils(this.con);
        try {
            query = "SELECT user_range.id, user_range.cid as conflict_id, addr1, addr2, port1, port2,  date1, date2  FROM ipn_user_range_" + this.mid + " AS user_range  INNER JOIN ipn_user_source_" + this.mid + " AS user_source ON user_range.id=user_source.aid  INNER JOIN ipn_iface_" + this.mid + " AS iface ON user_source.source_id=iface.source_id AND user_source.iface=iface.number ";
            if (zoneId == -2) {
                query = query + " WHERE iface.source_id=? AND iface.number=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, sourceId);
                ps.setInt(2, iface);
            } else {
                query = query + " WHERE iface.zone_id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, zoneId);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                boolean hasDateConflict;
                if (!id.equals("new") && rs.getString("user_range.id").equals(id) || address.getAddr1() > rs.getLong("addr2") || address.getAddr2() < rs.getLong("addr1") || address.getPort1() > rs.getInt("port2") || address.getPort2() < rs.getInt("port1")) continue;
                Date dbDate1 = rs.getDate("date1");
                Date dbDate2 = rs.getDate("date2");
                java.util.Date date1 = TimeUtils.convertCalendarToDate((Calendar)address.getDate1());
                java.util.Date date2 = TimeUtils.convertCalendarToDate((Calendar)address.getDate2());
                boolean bl = hasDateConflict = !(dbDate1 != null && date2 != null && !dbDate1.before(date2) || dbDate2 != null && date1 != null && !dbDate2.after(date1));
                if (!hasDateConflict) continue;
                int conflictCid = rs.getInt("conflict_id");
                if (conflicts.length() != 0) {
                    conflicts.append("; ");
                }
                conflicts.append(cu.getContractTitle(conflictCid, false));
            }
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return conflicts.toString();
    }

    public void updateAddressRangeInfo(String id, AddressRange ar) throws BGException {
        String query = null;
        PreparedStatement ps = null;
        try {
            if (id.equals("new")) {
                query = "INSERT INTO ipn_user_range_" + this.mid + " ( addr1, addr2, port1, port2, date1, date2, comment, cid, object_id, plan_id, pers_plan_id, resource_id, mask )  VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
                ps = this.con.prepareStatement(query);
            } else {
                query = "UPDATE ipn_user_range_" + this.mid + " SET addr1=?, addr2=?, port1=?, port2=?, date1=?, date2=?, comment=?, cid=?, object_id=?, plan_id=?, pers_plan_id=?,  resource_id=?, mask=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(14, Utils.parseInt((String)id, (int)-1));
            }
            ps.setLong(1, ar.getAddr1());
            ps.setLong(2, ar.getAddr2());
            ps.setInt(3, ar.getPort1());
            ps.setInt(4, ar.getPort2());
            ps.setDate(5, TimeUtils.convertCalendarToSqlDate((Calendar)ar.getDate1()));
            ps.setDate(6, TimeUtils.convertCalendarToSqlDate((Calendar)ar.getDate2()));
            ps.setString(7, ar.getComment());
            ps.setInt(8, ar.getContractId());
            ps.setInt(9, ar.getObjectId());
            ps.setInt(10, ar.getPlanId());
            ps.setInt(11, ar.getPersonalPlanId());
            ps.setInt(12, ar.getResourceId());
            ps.setInt(13, ar.getMask());
            ps.executeUpdate();
            if (id.equals("new")) {
                ar.setId(ServerUtils.lastInsertId((Connection)this.con));
            } else {
                ar.setId(Utils.parseInt((String)id, (int)-1));
            }
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
    }

    public List<AddressRange> getAddressRangeList(Calendar date) throws BGException {
        ArrayList<AddressRange> result = new ArrayList<AddressRange>();
        if (date == null) {
            return result;
        }
        try {
            String query = null;
            PreparedStatement ps = null;
            query = "SELECT * FROM ipn_user_range_" + this.mid + " WHERE ( date1 IS NULL OR date1<=? ) AND ( date2 IS NULL OR date2>=? )  ORDER BY addr1, port1";
            ps = this.con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AddressRange addressRange = new AddressRange();
                this.loadFromResultSet(rs, addressRange);
                result.add(addressRange);
            }
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public Iterable<AddressRange> getAddressRangeIterable() throws BGException {
        try {
            String query = null;
            PreparedStatement ps = null;
            query = "SELECT * FROM ipn_user_range_" + this.mid + " ORDER BY addr1, port1";
            ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            return new Iter.ResultSetIterator(rs, (Iter.LoadFromRS)new Iter.LoadFromRS<AddressRange>(){

                public AddressRange getFromRS(ResultSet rs) throws SQLException {
                    AddressRange addressRange = new AddressRange();
                    AddressRangeManager.this.loadFromResultSet(rs, addressRange);
                    return addressRange;
                }
            }, (Statement)ps);
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
    }

    public List<AddressRange> getAddressRangeListCidSort(Calendar date, String ifaces, Page page) throws BGException {
        ArrayList<AddressRange> result = new ArrayList<AddressRange>();
        if (date == null || Utils.isBlankString((String)ifaces)) {
            return result;
        }
        try {
            PreparedStatement ps = null;
            StringBuilder qb = new StringBuilder(120);
            qb.append("SELECT SQL_CALC_FOUND_ROWS ");
            qb.append("t2.*, source.title as source_name, iface.title as iface_name ");
            qb.append("FROM ipn_user_source_" + this.mid + " AS t1 ");
            qb.append("LEFT JOIN ipn_user_range_" + this.mid + " AS t2 ON t1.aid=t2.id ");
            qb.append("LEFT JOIN source ON t1.source_id=source.id ");
            qb.append("LEFT JOIN ipn_iface_" + this.mid + " AS iface ");
            qb.append("ON t1.iface=iface.number AND t1.source_id=iface.source_id ");
            qb.append("WHERE (1=0 ");
            StringTokenizer st = new StringTokenizer(ifaces, ",");
            while (st.hasMoreTokens()) {
                String pair = st.nextToken();
                String[] source_iface = pair.split("_");
                qb.append("OR (t1.source_id=" + source_iface[0]);
                qb.append(" AND t1.iface=" + source_iface[1]);
                qb.append(") ");
            }
            qb.append(") AND ( t2.date1 IS NULL OR t2.date1<=? ) AND ( t2.date2 IS NULL OR t2.date2>=? ) ");
            qb.append("ORDER BY t2.cid, t2.addr1, t2.port1");
            qb.append(page.sqlLimit());
            ps = this.con.prepareStatement(qb.toString());
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AddressRange addressRange = new AddressRange();
                this.loadFromResultSet(rs, addressRange);
                addressRange.setSources(rs.getString("source_name") + "%" + rs.getString("iface_name"));
                result.add(addressRange);
            }
            page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public List<AddressRange> getAddressRangeList(Calendar date1, Calendar date2) throws BGException {
        ArrayList<AddressRange> result = new ArrayList<AddressRange>();
        if (date1 == null || date2 == null) {
            return result;
        }
        try {
            String query = null;
            PreparedStatement ps = null;
            query = "SELECT * FROM ipn_user_range_" + this.mid + " WHERE ( date2 IS NULL OR ? IS NULL OR ?<=date2 ) AND ( date1 IS NULL OR ? IS NULL OR ?>=date1 ) ";
            ps = this.con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)date1));
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date1));
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)date2));
            ps.setDate(4, TimeUtils.convertCalendarToSqlDate((Calendar)date2));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AddressRange addressRange = new AddressRange();
                this.loadFromResultSet(rs, addressRange);
                result.add(addressRange);
            }
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public List<AddressRange> getAddressRangeList(long addr, int port, int mask, Calendar date1, Calendar date2, String comment, Page page) throws BGException {
        ArrayList<AddressRange> result = new ArrayList<AddressRange>();
        try {
            int i = 1;
            StringBuilder query = new StringBuilder();
            query.append("SELECT SQL_CALC_FOUND_ROWS ");
            query.append("userRange.*, source.title as source_name, iface.title as iface_name ");
            query.append("FROM ipn_user_range_");
            query.append(this.mid);
            query.append(" AS userRange LEFT JOIN ipn_user_source_" + this.mid + " AS t1 ON t1.aid=userRange.id ");
            query.append("LEFT JOIN source ON t1.source_id=source.id ");
            query.append("LEFT JOIN ipn_iface_" + this.mid + " AS iface ");
            query.append("ON t1.iface=iface.number AND t1.source_id=iface.source_id ");
            query.append(" WHERE 1=1 ");
            if (addr > -1L) {
                query.append("AND ?<=addr2 AND ( addr1<=? OR addr1&?=? ) ");
            }
            if (Utils.notBlankString((String)comment)) {
                query.append("AND userRange.comment LIKE ?");
            }
            if (port > -1 && port < 65536) {
                query.append("AND port1<=? AND ?<=port2 ");
            }
            if (date1 != null) {
                query.append("AND ( isNull( userRange.date2 ) OR userRange.date2>=? ) ");
            }
            if (date2 != null) {
                query.append("AND ( isNull( userRange.date1 ) OR userRange.date1<=? ) ");
            }
            query.append(" GROUP BY userRange.id ");
            query.append("ORDER BY addr1");
            query.append(page.sqlLimit());
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            if (addr > -1L) {
                ps.setLong(i++, addr);
                ps.setLong(i++, addr);
                ps.setLong(i++, (long)Math.pow(2.0, mask) - 1L << 32 - mask);
                ps.setLong(i++, addr);
            }
            if (Utils.notBlankString((String)comment)) {
                ps.setString(i++, "%" + comment + "%");
            }
            if (port > -1 && port < 65536) {
                ps.setInt(i++, port);
                ps.setInt(i++, port);
            }
            if (date1 != null) {
                ps.setDate(i++, TimeUtils.convertCalendarToSqlDate((Calendar)date1));
            }
            if (date2 != null) {
                ps.setDate(i++, TimeUtils.convertCalendarToSqlDate((Calendar)date2));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AddressRange addressRange = new AddressRange();
                this.loadFromResultSet(rs, addressRange);
                addressRange.setSources(rs.getString("source_name") + "%" + rs.getString("iface_name"));
                result.add(addressRange);
            }
            rs.close();
            ps.close();
            page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public boolean substituteRange(AddressRange from, AddressRange what) throws BGException {
        boolean result = false;
        Calendar closeDate = what.getDate1();
        if (closeDate != null) {
            RangeIfaceManager sm = new RangeIfaceManager(this.con, this.mid);
            Set<RangeIface> sources = sm.getAdressRangeIfaces(from.getId());
            AddressRange range = null;
            ArrayList<AddressRange> ranges = new ArrayList<AddressRange>();
            if (what.getAddr1() > from.getAddr1()) {
                range = this.clone(from);
                range.setAddr2(what.getAddr1() - 1L);
                ranges.add(range);
            }
            if (what.getAddr2() < from.getAddr2()) {
                range = this.clone(from);
                range.setAddr1(what.getAddr2() + 1L);
                ranges.add(range);
            }
            if (what.getPort1() > from.getPort1()) {
                range = this.clone(what);
                range.setPort1(from.getPort1());
                range.setPort2(what.getPort1() - 1);
                ranges.add(range);
            }
            if (what.getPort2() < from.getPort2()) {
                range = this.clone(what);
                range.setPort1(what.getPort2() + 1);
                range.setPort2(from.getPort2());
                ranges.add(range);
            }
            for (AddressRange ar : ranges) {
                ar.setComment(from.getComment());
                ar.setContractId(from.getContractId());
                ar.setDate1(what.getDate1());
                ar.setDate2(from.getDate2());
                this.updateAddressRangeInfo("new", ar);
                sm.updateAddressRangeIfaces(ar.getId(), sources);
            }
            closeDate = (Calendar)closeDate.clone();
            closeDate.add(6, -1);
            from.setDate2(closeDate);
            if (from.getDate2().before(from.getDate1())) {
                this.deleteContractAddressRange(from.getId());
            } else {
                this.updateAddressRangeInfo(String.valueOf(from.getId()), from);
            }
            result = true;
        }
        return result;
    }

    public List<AddressRange> getRangeListOnPlan(int planId) throws BGException {
        ArrayList<AddressRange> result = new ArrayList<AddressRange>();
        try {
            String query = "SELECT * FROM ipn_user_range_" + this.mid + " WHERE plan_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, planId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AddressRange range = new AddressRange();
                this.loadFromResultSet(rs, range);
                result.add(range);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public AddressRange clone(AddressRange ar) {
        AddressRange result = new AddressRange();
        result.setAddr1(ar.getAddr1());
        result.setAddr2(ar.getAddr2());
        result.setPort1(ar.getPort1());
        result.setPort2(ar.getPort2());
        return result;
    }

    public void freeConnection() {
    }

    public void moveRange(AddressRange range, int cidFrom, int cidTo, int objectTo, int userId) throws SQLException, BGException {
        if (range.getDate1() == null) {
            throw new BGException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d. \u041d\u0435\u0442 \u0434\u0430\u0442\u044b \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f.");
        }
        String tableName = "ipn_user_range_" + this.mid;
        TableCopier tableCopier = new TableCopier(this.con);
        HashMap<String, ColumnValue> valueMap = new HashMap<String, ColumnValue>();
        valueMap.put("cid", new ColumnValue(true, (Object)cidTo));
        valueMap.put("object_id", new ColumnValue(true, (Object)objectTo));
        tableCopier.updateColumns(tableName, valueMap, "id=" + range.getId());
        this.moveRangeAccount(range, cidFrom, cidTo);
        ContractUtils cu = new ContractUtils(this.con);
        ContractMemoManager memoManager = new ContractMemoManager(this.con);
        ContractMemo memo = new ContractMemo();
        StringBuilder memoText = new StringBuilder(300);
        memoText.append("\u0410\u0434\u0440\u0435\u0441\u0430 ");
        memoText.append(range.toShortString());
        memoText.append(" \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d\u044b \u0438\u0437 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 ");
        memoText.append(cu.getContractTitle(cidFrom, true));
        memoText.append(" \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 ");
        memoText.append(cu.getContractTitle(cidTo, true));
        memo.setSubject("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d\u044b \u0430\u0434\u0440\u0435\u0441\u0430");
        memo.setComment(memoText.toString());
        memo.setUserId(userId);
        memo.setContractId(cidFrom);
        memoManager.updateMemo(memo);
        memo.setId(0);
        memo.setContractId(cidTo);
        memoManager.updateMemo(memo);
    }

    private void moveRangeAccount(AddressRange range, int cidFrom, int cidTo) throws SQLException, BGException {
        Calendar date1 = range.getDate1();
        Calendar date2 = range.getDate2();
        if (date2 == null) {
            date2 = new GregorianCalendar();
        }
        TableCopier tableCopier = new TableCopier(this.con);
        Calendar dateMonth = (Calendar)date1.clone();
        while (TimeUtils.monthsDelta((Calendar)dateMonth, (Calendar)date2) >= 0) {
            String ipnContractData = ServerUtils.getModuleMonthTableName((String)"ipn_contract_data", (java.util.Date)dateMonth.getTime(), (int)this.mid);
            if (ServerUtils.tableExists((Connection)this.con, (String)ipnContractData)) {
                HashMap<String, ColumnValue> valueMap = new HashMap<String, ColumnValue>();
                valueMap.put("cid", new ColumnValue(true, (Object)cidTo));
                valueMap.put("aid", new ColumnValue(true, (Object)range.getId()));
                tableCopier.updateColumns(ipnContractData, valueMap, "cid=" + cidFrom + " AND aid=" + range.getId());
            }
            dateMonth.add(2, 1);
        }
    }

    public void wrapRange(AddressRange range, int cidTo, int objectTo, java.util.Date dateClose, java.util.Date dateOpen, int userId) throws SQLException, BGException {
        if (range.getDate2() != null && TimeUtils.dateBeforeOrEq((Calendar)range.getDate2(), (Calendar)TimeUtils.convertDateToCalendar((java.util.Date)dateClose))) {
            return;
        }
        if (TimeUtils.dateBeforeOrEq((java.util.Date)dateOpen, (java.util.Date)TimeUtils.convertCalendarToDate((Calendar)range.getDate1()))) {
            this.moveRange(range, range.getContractId(), cidTo, objectTo, userId);
            return;
        }
        if (range.getDate1() == null) {
            throw new BGException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d. \u041d\u0435\u0442 \u0434\u0430\u0442\u044b \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f.");
        }
        TableCopier tableCopier = new TableCopier(this.con);
        int newIpnServiceLinkPlanId = 0;
        if (range.getPersonalPlanId() > 0) {
            newIpnServiceLinkPlanId = tableCopier.copyRecord("ipn_service_link_plan_" + this.mid, "id=" + range.getPersonalPlanId(), new HashMap());
            HashMap<String, ColumnValue> valuesPairs = new HashMap<String, ColumnValue>();
            valuesPairs.put("plan_id", new ColumnValue(true, (Object)newIpnServiceLinkPlanId));
            valuesPairs.put("date1", new ColumnValue(true, (Object)dateOpen));
            tableCopier.copyRecord("ipn_service_" + this.mid, "plan_id=" + range.getPersonalPlanId(), valuesPairs);
            range.setDate2(TimeUtils.convertDateToCalendar((java.util.Date)dateClose));
            tableCopier.updateColumn("ipn_service_" + this.mid, "date2", TimeUtils.formatSQLDate((java.util.Date)dateClose), "plan_id=" + range.getPersonalPlanId());
        }
        HashMap<String, ColumnValue> valueMap = new HashMap<String, ColumnValue>();
        valueMap.put("cid", new ColumnValue(true, (Object)cidTo));
        valueMap.put("date1", new ColumnValue(true, (Object)dateOpen));
        valueMap.put("object_id", new ColumnValue(true, (Object)objectTo));
        valueMap.put("pers_plan_id", new ColumnValue(true, (Object)newIpnServiceLinkPlanId));
        int newRangeId = tableCopier.copyRecord("ipn_user_range_" + this.mid, "id=" + range.getId(), valueMap);
        tableCopier.updateColumn("ipn_user_range_" + this.mid, "date2", TimeUtils.formatSQLDate((java.util.Date)dateClose), "id=" + range.getId());
        AddressRange rangeTo = this.getAddressRange(newRangeId);
        String aliasTable = "ipn_user_source_" + this.mid;
        valueMap.clear();
        valueMap.put("aid", new ColumnValue(true, (Object)newRangeId));
        tableCopier.copyRecord(aliasTable, "aid=" + range.getId(), valueMap);
        ContractUtils cu = new ContractUtils(this.con);
        ContractMemoManager memoManager = new ContractMemoManager(this.con);
        ContractMemo memo = new ContractMemo();
        StringBuilder memoText = new StringBuilder(300);
        memoText.append("\u0410\u0434\u0440\u0435\u0441\u0430 ");
        memoText.append(range.toShortString());
        memoText.append(" \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d\u044b \u0438\u0437 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 ");
        memoText.append(cu.getContractTitle(range.getContractId(), true));
        memoText.append(" \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 ");
        memoText.append(cu.getContractTitle(cidTo, true));
        memoText.append(" \u0441 \u0434\u0430\u0442\u044b ");
        memoText.append(TimeUtils.formatDate((java.util.Date)dateOpen));
        memo.setSubject("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d\u044b \u0430\u0434\u0440\u0435\u0441\u0430 \u0441 \u0434\u0430\u0442\u044b");
        memo.setComment(memoText.toString());
        memo.setUserId(userId);
        memo.setContractId(range.getContractId());
        memoManager.updateMemo(memo);
        memo.setId(0);
        memo.setContractId(cidTo);
        memoManager.updateMemo(memo);
        this.wrapRangeAccount(range, rangeTo);
    }

    public void recalcAfterMove(MonthForRecalc months, int cidFrom, int cidTo) {
        RunTaskDataManager runManager = new RunTaskDataManager(this.con);
        for (Calendar month : months.getMonths()) {
            runManager.addTask((RunTask)new MaxRecalculator(this.mid, month, null, cidFrom + "," + cidTo));
            runManager.addTask((RunTask)new IPNRecalculator(this.mid, month, null, cidFrom + "," + cidTo, "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u043e\u0432 \u0430\u0434\u0440\u0435\u0441\u043e\u0432"));
        }
    }

    private void wrapRangeAccount(AddressRange rangeFrom, AddressRange rangeTo) throws SQLException {
        Calendar date1 = rangeTo.getDate1();
        Calendar date2 = rangeTo.getDate2();
        if (date2 == null) {
            date2 = new GregorianCalendar();
        }
        TableCopier tableCopier = new TableCopier(this.con);
        Calendar dateMonth = (Calendar)date1.clone();
        while (TimeUtils.monthsDelta((Calendar)dateMonth, (Calendar)date2) >= 0) {
            String ipnContractData = ServerUtils.getModuleMonthTableName((String)"ipn_contract_data", (java.util.Date)dateMonth.getTime(), (int)this.mid);
            if (ServerUtils.tableExists((Connection)this.con, (String)ipnContractData)) {
                HashMap<String, ColumnValue> valueMap = new HashMap<String, ColumnValue>();
                valueMap.put("cid", new ColumnValue(true, (Object)rangeTo.getContractId()));
                valueMap.put("aid", new ColumnValue(true, (Object)rangeTo.getId()));
                tableCopier.updateColumns(ipnContractData, valueMap, "cid=" + rangeFrom.getContractId() + " AND aid=" + rangeFrom.getId() + " AND dt>='" + TimeUtils.formatSQLDate((Calendar)rangeTo.getDate1()) + "'");
            }
            dateMonth.add(2, 1);
        }
    }
}

