/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.directory.api.common.bean;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.model.IdTitle;

class DirectoryView<K extends IdTitle>
implements Directory<K> {
    static final ConcurrentMap<Class<? extends IdTitle>, AtomicLong> versionMap = new ConcurrentHashMap<Class<? extends IdTitle>, AtomicLong>();
    private final Class<? extends IdTitle> clazz;
    private final int moduleId;
    private final Directory<K> support;
    private final PropertyChangeListener listener;

    public DirectoryView(Class<? extends IdTitle> clazz, int moduleId, Directory<K> support, PropertyChangeListener listener) {
        this.clazz = clazz;
        this.moduleId = moduleId;
        this.support = support;
        this.listener = listener;
    }

    protected long modified(Class<? extends IdTitle> clazz) {
        AtomicLong newVersion;
        AtomicLong version = (AtomicLong)versionMap.get(clazz);
        if (version == null && (version = versionMap.putIfAbsent(clazz, newVersion = new AtomicLong())) == null) {
            version = newVersion;
        }
        long result = version.incrementAndGet();
        this.listener.propertyChange(new PropertyChangeEvent(clazz, "directory", this.moduleId, this.moduleId));
        return result;
    }

    @Override
    public int delete(int id) throws BGException {
        this.modified(this.clazz);
        return this.support.delete(id);
    }

    @Override
    public void update(K k) throws BGException {
        this.modified(this.clazz);
        this.support.update(k);
    }

    @Override
    public K get(int id) throws BGException {
        return (K)((IdTitle)this.support.get(id));
    }

    @Override
    public K get(String title) throws BGException {
        return (K)((IdTitle)this.support.get(title));
    }

    @Override
    public List<K> list() throws BGException {
        return this.support.list();
    }
}

