/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.AbstractAccessLogValve;
import org.apache.catalina.valves.AccessLogValve;
import ru.bitel.bgbilling.server.util.Setup;

class MyAccessLogValve
extends AccessLogValve {
    public MyAccessLogValve() {
        this.setDirectory("log");
        this.setPrefix("access_log.");
        this.setRotatable(true);
        this.setFileDateFormat("yyyy-MM-dd");
        this.setPattern(Setup.getSetup().get("access.log.pattern", "%h %S %t %T %s %b \"%r\" "));
        this.setEnabled(true);
    }

    protected AbstractAccessLogValve.AccessLogElement[] createLogElements() {
        AbstractAccessLogValve.AccessLogElement element = new AbstractAccessLogValve.AccessLogElement(){

            public void addElement(CharArrayWriter buf, Date date, Request request, Response response, long time) {
                Integer userId = (Integer)request.getAttribute("user_id");
                if (userId != null) {
                    buf.append("UID=");
                    buf.append(userId.toString());
                    buf.append(" ");
                }
                Map paramMap = request.getParameterMap();
                for (Map.Entry me : paramMap.entrySet()) {
                    String key = (String)me.getKey();
                    String[] values = (String[])me.getValue();
                    buf.append(key);
                    buf.append("=");
                    boolean first = true;
                    for (String value : values) {
                        if (!first) {
                            buf.append(" ");
                        }
                        buf.append(value);
                        first = false;
                    }
                    buf.append("&");
                }
            }
        };
        ArrayList<AbstractAccessLogValve.AccessLogElement> superList = new ArrayList<AbstractAccessLogValve.AccessLogElement>();
        for (AbstractAccessLogValve.AccessLogElement superEl : super.createLogElements()) {
            superList.add(superEl);
        }
        superList.add(element);
        return superList.toArray(new AbstractAccessLogValve.AccessLogElement[0]);
    }

    protected synchronized void open() {
        super.open();
        final File file = this.currentLogFile;
        final PrintWriter writer = this.writer;
        this.writer = new PrintWriter(writer){

            @Override
            public void println(String x) {
                writer.println(x);
            }

            @Override
            public void close() {
                super.close();
                File dir = new File(file.getParentFile(), "access");
                dir.mkdirs();
                file.renameTo(new File(dir, file.getName()));
            }
        };
    }
}

