/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.call.action.base;

import bitel.billing.server.call.bean.Login;
import bitel.billing.server.call.bean.LoginManager;
import bitel.billing.server.call.bean.ReportUtils;
import bitel.billing.server.call.bean.VoiceUtils;
import bitel.billing.server.call.bean.busevent.LoginChangedEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.modules.call.server.event.LoginUpdateEvent;
import ru.bitel.bgbilling.server.util.PswdGen;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public abstract class ActionBase
extends bitel.billing.server.ActionBase {
    protected LoginManager getLoginManager() {
        return LoginManager.getLoginManager(this.module, this.con, this.mid);
    }

    protected ReportUtils getReportUtils() {
        return ReportUtils.getReportUtils(this.module, this.conSlave, this.mid, this.moduleSetup);
    }

    protected VoiceUtils getVoiceUtils() throws BGException {
        return VoiceUtils.getVoiceUtils(this.module, this.con, this.mid, this.moduleSetup);
    }

    protected void addReportParams(Period period, ReportUtils lu, int lid, Element table) throws SQLException {
        table.setAttribute("date1", TimeUtils.formatDate((Date)period.getDateFrom()));
        table.setAttribute("date2", TimeUtils.formatDate((Date)period.getDateTo()));
        LoginManager loginManager = lu.getLoginManager();
        if (lid != 0) {
            table.setAttribute("login", loginManager.getLoginTitle(lid) + loginManager.getLoginAliases(lid));
        }
        try (ContractDao contractDao = new ContractDao(this.con, this.userId);){
            Contract contract = (Contract)contractDao.get(this.cid);
            table.setAttribute("contractTitle", contract.getTitle());
            table.setAttribute("comment", contract.getComment());
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    protected void addReportParams(Period period, ReportUtils lu, List<Integer> lids, Element table) throws SQLException {
        table.setAttribute("date1", TimeUtils.formatDate((Date)period.getDateFrom()));
        table.setAttribute("date2", TimeUtils.formatDate((Date)period.getDateTo()));
        LoginManager loginManager = lu.getLoginManager();
        StringBuilder sb = new StringBuilder(20);
        for (Integer lid : lids) {
            if (lid == 0) continue;
            sb.append(loginManager.getLoginTitle(lid));
            sb.append(loginManager.getLoginAliases(lid));
            sb.append("; ");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 2);
            table.setAttribute("login", sb.toString());
        }
        try (ContractDao contractDao = new ContractDao(this.con, this.userId);){
            Contract contract = (Contract)contractDao.get(this.cid);
            table.setAttribute("contractTitle", contract.getTitle());
            table.setAttribute("comment", contract.getComment());
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    protected Hashtable<String, String> getPools(int mid) throws SQLException {
        Hashtable<String, String> poolsTitles = new Hashtable<String, String>();
        String query = "SELECT id, identifier FROM nas WHERE mid=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, mid);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            poolsTitles.put(rs.getString(1), rs.getString(2));
        }
        rs.close();
        ps.close();
        return poolsTitles;
    }

    protected void addNASList(Element rootNode, int mid) throws SQLException {
        Element nas = this.createElement(rootNode, "nas");
        String query = "SELECT id, concat( identifier, ' [ ',  comment, ' ]' ) FROM nas_" + mid + " WHERE ( isNull(date1) OR date1<=CURDATE() ) AND ( isNull(date2) OR date2>=CURDATE() ) ORDER BY identifier";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            this.addListItem((Node)nas, rs.getString(1), rs.getString(2));
        }
        rs.close();
        ps.close();
    }

    protected void insertLimitCondition(String id, String tc) throws SQLException {
        if (id == null || tc == null || tc.length() == 0) {
            return;
        }
        String query = "INSERT INTO user_login_condition_" + this.mid + " VALUES ( ?, ?, ?, ?, ? )";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setString(1, id);
        Hashtable<String, String> copy = new Hashtable<String, String>();
        StringTokenizer tt = new StringTokenizer(tc, "-");
        while (tt.hasMoreTokens()) {
            String ss = tt.nextToken();
            if (copy.containsKey(ss)) continue;
            StringTokenizer st = new StringTokenizer(ss, "_");
            String hh = st.hasMoreTokens() ? st.nextToken() : null;
            String dw = st.hasMoreTokens() ? st.nextToken() : null;
            String dm = st.hasMoreTokens() ? st.nextToken() : null;
            String mm = st.hasMoreTokens() ? st.nextToken() : null;
            try {
                ps.setInt(2, Integer.parseInt(hh));
                ps.setInt(3, Integer.parseInt(dw));
                ps.setInt(4, Integer.parseInt(dm));
                ps.setInt(5, Integer.parseInt(mm));
                ps.executeUpdate();
                copy.put(ss, "");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ps.close();
    }

    protected String getVoice_VoipFilter() {
        return this.getVoice_VoipFilter(true);
    }

    protected String getVoice_VoipFilter(boolean withNoFree) {
        String mask = this.getParameter("mask", null);
        int type = this.getIntParameter("direct", -1);
        int dest = this.getIntParameter("dest", -1);
        StringBuffer buf = new StringBuffer();
        if (mask != null && mask.length() > 0) {
            if (mask.charAt(0) == '>') {
                buf.append(" AND to_number REGEXP '");
                buf.append(mask.substring(1));
            } else {
                buf.append(" AND from_number REGEXP '");
                buf.append(mask.charAt(0) == '<' ? mask.substring(1) : mask);
            }
            buf.append("' ");
        }
        if (type == 1 || type == 2) {
            buf.append(" AND type=" + type);
        }
        if (dest > 0) {
            buf.append(" AND dest_code=" + dest);
        }
        int nofree = this.getIntParameter("nofree", -1);
        int noZeroTime = this.getIntParameter("noZeroTime", -1);
        if (withNoFree && nofree > 0) {
            buf.append(" AND session_cost!=0 ");
        }
        if (noZeroTime > 0) {
            buf.append(" AND session_time!=0 ");
        }
        return buf.toString();
    }

    protected void updateLogin(Login login, LoginManager loginManager) throws BGException {
        String error;
        String alias = this.getParameter("alias");
        if (login.getId() == 0 && login.getPswd() == null) {
            login.setPswd("");
        }
        TimeUtils.checkPeriod((Date)this.getDateParameter("date1"), (Date)this.getDateParameter("date2"));
        if (login.getId() < 0 || this.mid < 0 || this.cid < 0 || alias == null) {
            throw new BGIllegalArgumentException();
        }
        if (Utils.notBlankString((String)this.getParameter("set_pswd"))) {
            login.setPswd(PswdGen.generatePasswordRTU((ParameterMap)this.moduleSetup));
        } else if (login.getPswd() != null && (error = ContractUtils.checkPassword((ParameterMap)this.moduleSetup, login.getPswd(), login.getPswd())) != null) {
            throw new BGMessageException(error);
        }
        HashSet<String> aliases = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(alias, " ");
        while (st.hasMoreTokens()) {
            aliases.add(st.nextToken().trim());
        }
        String error2 = loginManager.checkAliases(login, aliases);
        if (error2 != null) {
            throw new BGMessageException(error2);
        }
        if (login.getId() <= 0) {
            String checkResult = null;
            checkResult = loginManager.checkLoginAvailable(this.moduleSetup);
            if (checkResult != null) {
                throw new BGMessageException(checkResult);
            }
            login = loginManager.addLogin(login, this.moduleSetup);
        } else {
            error2 = loginManager.checkLogin(login);
            if (error2 != null) {
                throw new BGMessageException(error2);
            }
            loginManager.updateLogin(login);
            if (login.getPswd() != null) {
                loginManager.updatePassword(login.getId(), login.getPswd(), this.userId);
            }
        }
        loginManager.updateAliases(login.getId(), aliases);
        this.context.publishAfterCommit(new LoginUpdateEvent((int)this.userId, this.mid, login));
        this.context.publishAfterCommit(new LoginChangedEvent(this.mid, login.getId(), login.getDate1(), login.getDate2(), login.getStatus()));
    }
}

