/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.contract.bean.ContractNotification;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.server.util.ServerUtils;

@Deprecated
public class ContractNotificationManager {
    protected Logger log = null;
    private Connection con;
    private static final String TABLE_NAME = "contract_notification";

    public ContractNotificationManager(Connection con) {
        this.con = con;
        this.log = LogManager.getLogger();
    }

    public void updateNotification(ContractNotification notice) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (notice.getId() <= 0) {
                query = "INSERT INTO contract_notification SET subject=?, message=?, cid=?, dt=NOW()";
                ps = this.con.prepareStatement(query, 1);
                ps.setInt(3, notice.getContractId());
            } else {
                query = "UPDATE contract_notification SET subject=?, message=?, is_read=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(3, notice.isRead() ? 1 : 0);
                ps.setInt(4, notice.getId());
            }
            ps.setString(1, notice.getSubject());
            ps.setString(2, notice.getMessage());
            ps.executeUpdate();
            if (notice.getId() <= 0) {
                notice.setId(ServerUtils.lastInsertId(ps));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteNotification(int id) {
        try {
            String query = "DELETE FROM contract_notification WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ContractNotification getNotification(int id) {
        ContractNotification result = null;
        try {
            String query = "SELECT * FROM contract_notification WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getNotificationFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ContractNotification> getNotificationList(int cid) {
        ArrayList<ContractNotification> result = new ArrayList<ContractNotification>();
        try {
            String query = "SELECT * FROM contract_notification WHERE cid=? ORDER BY dt DESC";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ContractNotification notice = this.getNotificationFromRs(rs);
                result.add(notice);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int getNewNotificationsCount(int cid) {
        int count = 0;
        try {
            String query = "SELECT COUNT(id) FROM contract_notification WHERE cid=? AND is_read=0";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            ps.close();
        }
        catch (SQLException e) {
            this.log.error("ContractNotificationManager.getNewNotificationsCount( " + cid + " )", (Throwable)e);
        }
        return count;
    }

    private ContractNotification getNotificationFromRs(ResultSet rs) throws SQLException {
        ContractNotification notice = new ContractNotification();
        notice.setId(rs.getInt("id"));
        notice.setContractId(rs.getInt("cid"));
        notice.setDateTime(rs.getTimestamp("dt"));
        notice.setSubject(rs.getString("subject"));
        notice.setMessage(rs.getString("message"));
        notice.setRead(rs.getBoolean("is_read"));
        return notice;
    }
}

