/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff.voice.calc;

import bitel.billing.server.tariff.voice.bean.ZoneMap;
import bitel.billing.server.tariff.voice.bean.ZoneMapItem;
import bitel.billing.server.tariff.voice.bean.ZoneMapItemManager;
import bitel.billing.server.tariff.voice.bean.ZoneMapManager;
import bitel.billing.server.tariff.voice.calc.CodeFinder;
import bitel.billing.server.tariff.voice.calc.ZoneDestFindRequest;
import bitel.billing.server.tariff.voice.calc.ZoneFinder;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ZoneDestFinder {
    private static Map<Integer, ZoneDestFinder> finderMap = Collections.synchronizedMap(new HashMap());
    private Calendar modTime;
    private CodeFinder codeFinder;
    private Map<Integer, ZoneFinder> mapFinders = new HashMap<Integer, ZoneFinder>();

    public static synchronized ZoneDestFinder getZoneFinder(Connection con, int mid) {
        ZoneDestFinder result = finderMap.get(mid);
        Calendar dbModTime = ServerUtils.getLastModificationTime(con, "zone_map_" + mid);
        if (!(dbModTime == null || result != null && result.getModTime().equals(dbModTime))) {
            result = new ZoneDestFinder(con, mid, dbModTime);
            finderMap.put(mid, result);
        }
        return result;
    }

    private ZoneDestFinder(Connection con, int mid, Calendar modTime) {
        this.modTime = modTime;
        this.codeFinder = new CodeFinder(con, mid);
        this.load(con, mid);
    }

    private void load(Connection con, int mid) {
        List<ZoneMap> mapList = new ZoneMapManager(con, mid).getZoneMapList();
        ZoneMapItemManager itemManager = new ZoneMapItemManager(con, mid);
        for (ZoneMap zoneMap : mapList) {
            List<ZoneMapItem> itemList = itemManager.getItemList(zoneMap.getId());
            ZoneFinder finder = new ZoneFinder(itemList);
            this.mapFinders.put(zoneMap.getId(), finder);
        }
    }

    public Calendar getModTime() {
        return this.modTime;
    }

    public void find(ZoneDestFindRequest req) {
        req.numberLength = req.number.length();
        this.codeFinder.find(req);
        ZoneFinder finder = this.mapFinders.get(req.mapId);
        if (finder != null) {
            finder.find(req);
        }
    }
}

