/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.webmenu.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.webmenu.common.bean.WebMenuItem;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class WebMenuDao
extends AbstractIdDao<WebMenuItem> {
    public static final String TABLE_CONTRACT_WEB_MENU = "contract_web_menu";

    public WebMenuDao(Connection con) {
        super(con, 0, "web_menu");
    }

    public int getWebMenuIdForContract(int contractId) throws BGException {
        int id = -1;
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT " + "web_menu_id" + " FROM " + TABLE_CONTRACT_WEB_MENU + " WHERE " + "contract_id=" + contractId);
            while (rs.next()) {
                id = rs.getInt(1);
            }
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return id;
    }

    public void setWebMenuIdForContract(int webMenuItemId, int contractId) throws BGException {
        try {
            Statement st = this.con.createStatement();
            st.executeUpdate("DELETE " + " FROM " + TABLE_CONTRACT_WEB_MENU + " WHERE " + "contract_id=" + contractId);
            st.executeUpdate("INSERT INTO " + TABLE_CONTRACT_WEB_MENU + " SET " + "web_menu_id=" + webMenuItemId + ", contract_id=" + contractId);
            st.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public String getData(int webMenuItemId) throws BGException {
        String data = null;
        String query = "SELECT data FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(query);){
            psSelect.setInt(1, webMenuItemId);
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    data = rs.getString(1);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return data;
    }

    public void deleteData(int webMenuItemId) throws BGException {
        try {
            int count = 0;
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT " + "count(*)" + " FROM " + TABLE_CONTRACT_WEB_MENU + " WHERE " + "web_menu_id=" + webMenuItemId);
            while (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            if (count > 0) {
                throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e. Web-\u043c\u0435\u043d\u044e (id=" + webMenuItemId + ") \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u0445 [" + count + " \u0434\u043e\u0433.]");
            }
            st.executeUpdate("DELETE " + " FROM " + this.tableName + " WHERE " + "id=" + webMenuItemId);
            st.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<WebMenuItem> list() throws BGException {
        ArrayList<WebMenuItem> list = new ArrayList<WebMenuItem>();
        String query = "SELECT * FROM " + this.tableName + " ORDER BY title";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return list;
    }

    public Map<Integer, Integer> getContractCount() throws BGException {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT " + "web_menu_id, count(*)" + " FROM " + TABLE_CONTRACT_WEB_MENU + " GROUP BY " + "web_menu_id");
            while (rs.next()) {
                map.put(rs.getInt(1), rs.getInt(2));
            }
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return map;
    }

    public WebMenuItem updateInfo(WebMenuItem webMenuItem) throws BGException {
        super.update((Object)webMenuItem);
        return webMenuItem;
    }

    public void updateData(int webMenuItemId, String data) throws BGException {
        try {
            PreparedStatement ps = null;
            if (webMenuItemId > 0) {
                ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET " + "data=?" + " WHERE " + "id=" + webMenuItemId);
            }
            ps.setString(1, data);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected WebMenuItem getFromRS(ResultSet rs) throws SQLException, BGException {
        WebMenuItem webMenuItem = new WebMenuItem();
        webMenuItem.setId(rs.getInt("id"));
        webMenuItem.setDefault(rs.getBoolean("default"));
        webMenuItem.setTitle(rs.getString("title"));
        return webMenuItem;
    }

    protected void updateImpl(WebMenuItem webMenuItem) throws BGException, SQLException {
        PreparedStatement ps = null;
        StringBuilder buf = new StringBuilder(" SET ").append("`default`=?, title=?");
        ps = webMenuItem.getId() < 1 ? this.con.prepareStatement("INSERT INTO " + this.tableName + buf) : this.con.prepareStatement("UPDATE " + this.tableName + buf + " WHERE " + "id=" + webMenuItem.getId());
        int index = 1;
        ps.setBoolean(index++, webMenuItem.isDefault());
        ps.setString(index++, webMenuItem.getTitle());
        ps.executeUpdate();
        ps.close();
        if (webMenuItem.getId() < 1) {
            webMenuItem.setId(ServerUtils.lastInsertId(this.con));
        }
        if (webMenuItem.isDefault()) {
            Statement st = this.con.createStatement();
            st.executeUpdate("UPDATE " + this.tableName + " SET " + "`default`=false" + " WHERE " + "id<>" + webMenuItem.getId());
            st.close();
        }
    }
}

