/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractStatus;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractStatusDao
extends AbstractIdDao<ContractStatus> {
    public ContractStatusDao(Connection con) {
        super(con, 0, "contract_status");
    }

    protected ContractStatus getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractStatus result = new ContractStatus();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setDateFrom(rs.getDate("date1"));
        result.setDateTo(rs.getDate("date2"));
        result.setStatus(rs.getInt("status"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    protected void updateImpl(ContractStatus status) throws BGException, SQLException {
        PreparedStatement ps;
        if (status.getId() <= 0) {
            String query = "INSERT INTO contract_status (date1, date2, status, comment, cid) VALUES (?, ?, ?, ?, ?)";
            ps = this.con.prepareStatement(query, 1);
            ps.setInt(5, status.getContractId());
        } else {
            String query = "UPDATE contract_status SET date1=?, date2=?, status=?, comment=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(5, status.getId());
        }
        ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)status.getDateFrom()));
        ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)status.getDateTo()));
        ps.setInt(3, status.getStatus());
        ps.setString(4, status.getComment());
        ps.executeUpdate();
        if (status.getId() <= 0) {
            status.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public List<ContractStatus> list(int contractId, Date date) throws BGException {
        try {
            PreparedStatement ps;
            if (date == null) {
                ps = this.con.prepareStatement("SELECT * FROM contract_status WHERE cid=? ORDER BY date1");
                ps.setInt(1, contractId);
            } else {
                ps = this.con.prepareStatement("SELECT * FROM contract_status WHERE cid=? AND (date2 IS NULL OR ?<=date2) ORDER BY date1");
                ps.setInt(1, contractId);
                ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date));
            }
            ArrayList<ContractStatus> result = new ArrayList<ContractStatus>();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

