/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.directories.address.common.bean.Area;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.Quarter;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.entity.server.bean.AddressStruct;

public class AddressUtils {
    private final Directory<City> cityDirectory;
    private final Directory<Area> areaDirectory;
    private final Directory<Street> streetDirectory;
    private final Directory<Quarter> quarterDirectory;

    public AddressUtils(ServerContext context) throws BGException {
        this.cityDirectory = context.getDirectory(City.class, 0);
        this.areaDirectory = context.getDirectory(Area.class, 0);
        this.streetDirectory = context.getDirectory(Street.class, 0);
        this.quarterDirectory = context.getDirectory(Quarter.class, 0);
    }

    public String getAddress(ParameterMap setup, String formatKey, House house, int pod, int floor, String flat, String room, String comment) throws BGException {
        String addressFormat = setup.get("addrs.format.pattern." + formatKey, setup.get("addrs.format." + formatKey, setup.get("addrs.format", "(${index}, )(${city})(, ${area})(, ${quarter})(, ${street})(, \u0434. ${house})(${frac})(, \u043a\u0432. ${flat})( ${room})(, ${pod} \u043f\u043e\u0434.)(, ${floor} \u044d\u0442.)")));
        return this.getAddress(addressFormat, house, pod, floor, flat, room, comment);
    }

    private <D extends IdTitle> String getDirectoryItem(int id, Directory<D> directory) throws BGException {
        IdTitle d;
        if (id > 0 && (d = (IdTitle)directory.get(id)) != null) {
            return d.getTitle();
        }
        return null;
    }

    private String getAddress(String pattern, House house, int pod, int floor, String flat, String room, String comment) throws BGException {
        String quarter;
        if (house == null) {
            return "";
        }
        String area = this.getDirectoryItem(house.getAreaId(), this.areaDirectory);
        if ("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e".equals(area) || "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d".equals(area)) {
            area = null;
        }
        if ("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e".equals(quarter = this.getDirectoryItem(house.getQuarterId(), this.quarterDirectory)) || "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d".equals(quarter)) {
            quarter = null;
        }
        AddressStruct addressStruct = new AddressStruct();
        addressStruct.setIndex(house.getPostIndex());
        addressStruct.setCity(this.getDirectoryItem(house.getCityId(), this.cityDirectory));
        addressStruct.setArea(area);
        addressStruct.setQuarter(quarter);
        addressStruct.setStreet(this.getDirectoryItem(house.getStreetId(), this.streetDirectory));
        addressStruct.setHouse(house.getHouse() > 0 ? String.valueOf(house.getHouse()) : null);
        addressStruct.setFrac(house.getFrac());
        addressStruct.setPod(pod > 0 ? String.valueOf(pod) : null);
        addressStruct.setFloor(floor > 0 ? String.valueOf(floor) : null);
        addressStruct.setFlat(flat);
        addressStruct.setRoom(room);
        addressStruct.setComment(comment);
        return ru.bitel.oss.kernel.entity.server.utils.AddressUtils.getAddress(pattern, addressStruct);
    }
}

