/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrHouse;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

class EntityAttrHouseDao
extends EntityAttrDefaultDao<EntityAttrHouse> {
    public EntityAttrHouseDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String houseTable) {
        super(con, entityAttrDao, houseTable);
    }

    @Override
    protected void createTable() {
        try (Statement createStatement = this.con.createStatement();){
            createStatement.execute("CREATE TABLE IF NOT EXISTS `" + this.table + "` ( `entityId` int(11) NOT NULL DEFAULT 0, `entitySpecAttrId` int(11) NOT NULL DEFAULT 0, `value` int(11) NOT NULL DEFAULT 0, PRIMARY KEY (`entityId`,`entitySpecAttrId`) )");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected PreparedStatement getSelectPS(int entityId, int entitySpecAttrId) throws SQLException {
        PreparedStatement selectPS = this.con.prepareStatement("SELECT v." + this.valueName() + ", t.title FROM " + this.table + " as v LEFT JOIN address_house as t ON t.id=v." + this.valueName() + " WHERE v." + this.idName() + "=? AND v." + this.typeName() + "=?");
        selectPS.setInt(1, entityId);
        selectPS.setInt(2, entitySpecAttrId);
        return selectPS;
    }

    @Override
    public EntityAttrHouse get(int entityId, int attrSpecId) throws SQLException {
        EntityAttrHouse result = null;
        try (PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                result = new EntityAttrHouse(entityId, attrSpecId, rs.getInt(1), rs.getString(2));
            }
        }
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr a) throws SQLException {
        try (PreparedStatement ps = this.getInsertPS(entityId, a.getEntitySpecAttrId());){
            ps.setInt(3, ((EntityAttrHouse)a).getHouseId());
            ps.executeUpdate();
        }
    }

    @Override
    public boolean updateImpl(int entityId, EntityAttrHouse attr) throws SQLException {
        boolean update = false;
        try (PreparedStatement ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());){
            ps.setInt(1, attr.getHouseId());
            update = ps.executeUpdate() == 0;
        }
        if (update) {
            ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
            try {
                ps.setInt(3, attr.getHouseId());
                ps.executeUpdate();
                boolean bl = true;
                return bl;
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        int oldValue = 0;
        try (PreparedStatement ps = this.entityAttrDao.getSelectOldValuePS();
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                oldValue = rs.getInt(1);
            }
        }
        return attr.getHouseId() != oldValue;
    }
}

