/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin.clusterdb;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;

public class TableEditor
extends BGPanel {
    private JTextField dbtModuleName = new JTextField();
    private BGControlPanelPeriod dbtPeriod = new BGControlPanelPeriod();
    private JComboBox<ComboBoxItem> dbtDatabase = new JComboBox();
    private JPanel infoPanel = new JPanel();
    private boolean buildList = true;
    private JComboBox<ComboBoxItem> dbtTablesPrefix = new JComboBox();
    private String currentModuleId;
    private String currentmoduleName;

    public TableEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        BGButtonPanelRestoreOkCancelHelp okCancelPanel = new BGButtonPanelRestoreOkCancelHelp();
        this.setLayout(new GridBagLayout());
        this.infoPanel.setLayout(new GridBagLayout());
        this.infoPanel.setBorder(new BGTitleBorder(" \u0420\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u0442\u0430\u0431\u043b\u0438\u0446 "));
        this.dbtModuleName.setMinimumSize(new Dimension(330, 24));
        this.dbtModuleName.setPreferredSize(new Dimension(330, 24));
        this.dbtModuleName.setColumns(30);
        okCancelPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableEditor.this.okCancelPerformed(e);
            }
        });
        this.add((Component)this.infoPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.dbtPeriod, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)okCancelPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 13, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.infoPanel.add((Component)new JLabel("\u041c\u043e\u0434\u0443\u043b\u044c:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.dbtModuleName.setEditable(false);
        this.infoPanel.add((Component)this.dbtModuleName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.infoPanel.add((Component)new JLabel("\u0422\u0430\u0431\u043b\u0438\u0446\u044b:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.infoPanel.add(this.dbtTablesPrefix, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.infoPanel.add((Component)new JLabel("\u0411\u0430\u0437\u0430 \u0434\u0430\u043d\u043d\u044b\u0445:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.infoPanel.add(this.dbtDatabase, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private void okCancelPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("reset".equals(actionCommand)) {
            this.setData();
        } else if ("ok".equals(actionCommand)) {
            this.updateData();
        } else if ("cancel".equals(actionCommand)) {
            this.setVisible(false);
        } else if ("help".equals(actionCommand)) {
            this.openHelp(this.getClass().getName());
        }
    }

    @Override
    public void setData() {
        Document doc;
        if (!this.init) {
            this.init = true;
            this.init();
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ClusterTableGet");
        request.setAttribute("id", this.id);
        request.setAttribute("currentModuleId", this.currentModuleId);
        if (this.buildList) {
            request.setAttribute("listdb", "1");
        }
        if (ClientUtils.checkStatus(doc = TransferManager.getDocument(request))) {
            Element list = XMLUtils.selectElement(doc, "//listdb");
            if (list.getChildNodes().getLength() > 0) {
                this.dbtDatabase.setModel(ClientUtils.buildComboBox(list, ""));
                this.buildList = false;
            }
            if ((list = XMLUtils.selectElement(doc, "//listprefix")).getChildNodes().getLength() > 0) {
                this.dbtTablesPrefix.setModel(ClientUtils.buildComboBox(list, ""));
                this.buildList = false;
            } else {
                this.dbtTablesPrefix.removeAllItems();
            }
        }
        if (this.id != null && !this.id.equals("0")) {
            if (ClientUtils.checkStatus(doc)) {
                Element db = XMLUtils.selectElement(doc, "//db");
                this.dbtModuleName.setText(this.currentmoduleName);
                this.dbtPeriod.setDateString1(XMLUtils.getAttribute(db, "date1", ""));
                this.dbtPeriod.setDateString2(XMLUtils.getAttribute(db, "date2", ""));
                ClientUtils.setComboBoxSelection(this.dbtDatabase, XMLUtils.getAttribute(db, "databaseId", ""));
                ClientUtils.setComboBoxSelection(this.dbtTablesPrefix, XMLUtils.getAttribute(db, "prefix", ""));
            }
        } else {
            this.dbtModuleName.setText(this.currentmoduleName);
            this.dbtPeriod.setDateString1("");
            this.dbtPeriod.setDateString2("");
        }
    }

    private void init() {
    }

    private void updateData() {
        if (this.dbtTablesPrefix.getSelectedIndex() < 0) {
            ClientUtils.showErrorMessageDialog("\"\u0422\u0430\u0431\u043b\u0438\u0446\u044b\" \u043d\u0430\u0434\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c");
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ClusterTableUpdate");
        request.setAttribute("id", this.id);
        request.setAttribute("currentModuleId", this.currentModuleId);
        request.setAttribute("date1", this.dbtPeriod.getDateString1());
        request.setAttribute("date2", this.dbtPeriod.getDateString2());
        request.setAttribute("databaseId", (String)((ComboBoxItem)this.dbtDatabase.getSelectedItem()).getObject());
        request.setAttribute("prefix", (String)((ComboBoxItem)this.dbtTablesPrefix.getSelectedItem()).getObject());
        if (ClientUtils.checkStatus(TransferManager.getDocument(request))) {
            this.setVisible(false);
        }
    }

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
    }

    public void setCurrentModuleId(String currentModuleId) {
        this.currentModuleId = currentModuleId;
    }

    @Deprecated
    public void setCurrentModuleID(String currentModuleId) {
        this.currentModuleId = currentModuleId;
    }

    public void setCurrentmoduleName(String currentmoduleName) {
        this.currentmoduleName = currentmoduleName;
    }
}

