/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.BGDialog;
import bitel.billing.module.common.CheckListCellRenderer;
import bitel.billing.module.common.CheckListener;
import bitel.billing.module.common.ListItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.common.client.BGButtonPanel;

public class TabbedClose
extends BGDialog {
    JList<ListItem> tabsList = new JList();

    public TabbedClose() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tabsList.setCellRenderer(new CheckListCellRenderer());
        new CheckListener(this.tabsList);
        WindowAdapter wndCloser = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TabbedClose.this.setListItemSelected(false);
                TabbedClose.this.setVisible(false);
            }
        };
        this.addWindowListener(wndCloser);
        this.pack();
        this.moveWindowToCenterScreen();
    }

    private void jbInit() throws Exception {
        JScrollPane jScrollPane = new JScrollPane(this.tabsList);
        jScrollPane.setPreferredSize(new Dimension(300, 200));
        BGButtonPanel bGControlPanel_06 = new BGButtonPanel(BGButtonPanel.SELECTALL, BGButtonPanel.CLEAR, BGButtonPanel.GLUE, BGButtonPanel.OK, BGButtonPanel.CANCEL);
        bGControlPanel_06.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedClose.this.bGControlPanel_06_actionPerformed(e);
            }
        });
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setTitle("\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u0432\u043a\u043b\u0430\u0434\u043a\u0438");
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)bGControlPanel_06, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
    }

    void setListItemSelected(boolean selected) {
        ListModel<ListItem> object = this.tabsList.getModel();
        if (object instanceof DefaultListModel) {
            DefaultListModel model = (DefaultListModel)object;
            for (int i = 0; i < model.getSize(); ++i) {
                Object item = model.getElementAt(i);
                if (!(item instanceof ListItem)) continue;
                ((ListItem)item).setSelected(selected);
            }
            this.tabsList.repaint();
        }
    }

    void bGControlPanel_06_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (BGButtonPanel.SELECTALL.equals(actionCommand)) {
            this.setListItemSelected(true);
        } else if (BGButtonPanel.CLEAR.equals(actionCommand)) {
            this.setListItemSelected(false);
        } else if (BGButtonPanel.OK.equals(actionCommand)) {
            this.setVisible(false);
        } else if (BGButtonPanel.CANCEL.equals(actionCommand)) {
            this.setListItemSelected(false);
            this.setVisible(false);
        }
    }

    public void setTabsList(Component[] tabs) {
        DefaultListModel<ListItem> model = new DefaultListModel<ListItem>();
        if (tabs == null || tabs.length == 0) {
            return;
        }
        for (int i = 0; i < tabs.length; ++i) {
            ListItem item = null;
            if (tabs[i] instanceof BGTabPanel) {
                item = new ListItem(((BGTabPanel)tabs[i]).getTabTitle());
            } else {
                if (!(tabs[i] instanceof BGUTabPanel)) continue;
                item = new ListItem(((BGUTabPanel)tabs[i]).getTabTitle());
            }
            item.setAttribute("id", tabs[i]);
            model.addElement(item);
        }
        this.tabsList.setModel(model);
    }

    public Vector<Object> getTabsList() {
        Vector<Object> list = new Vector<Object>();
        DefaultListModel model = (DefaultListModel)this.tabsList.getModel();
        for (int i = 0; i < model.size(); ++i) {
            ListItem item = (ListItem)model.getElementAt(i);
            if (!item.isSelected()) continue;
            list.addElement(item.getAttribute("id"));
        }
        return list;
    }
}

