/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGComponentBorder;
import bitel.billing.module.common.BGControlPanelContractSelect;
import bitel.billing.module.common.BGControlPanelDate;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.BGDialog;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.ListItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGUAction;

public class PatternSelectedDialog
extends BGDialog {
    public static final int MODE_NEW = 1;
    public static final int MODE_WRAP = 2;
    private int mode = 1;
    private int cid = -1;
    private int responseCid = 0;
    private JList<ListItem> patternList = new JList();
    private BGControlPanelDate controlPanelDate = new BGControlPanelDate();
    private BGComboBox<ComboBoxItem> subModeCombo = new BGComboBox();
    private BGControlPanelContractSelect superContractSelect = new BGControlPanelContractSelect(false, true);
    private BGControlPanelListSelect paramsList = new BGControlPanelListSelect();
    private BGTextField contractTitle = new BGTextField();
    private JCheckBox manually = new JCheckBox("\u0412\u0440\u0443\u0447\u043d\u0443\u044e");
    private JCheckBox subName;

    public PatternSelectedDialog(int mode, int contractId) {
        this.mode = mode;
        this.cid = contractId;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setData();
        this.pack();
        this.moveWindowToCenterScreen();
    }

    private void jbInit() throws Exception {
        this.controlPanelDate.setButtonNow(true);
        this.controlPanelDate.setButtonMove(true);
        JPanel patternListPanel = new JPanel(new GridBagLayout());
        patternListPanel.setBorder(new BGTitleBorder(" \u0421\u043f\u0438\u0441\u043e\u043a \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432 "));
        patternListPanel.add((Component)new JScrollPane(this.patternList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel datePanel = new JPanel(new GridBagLayout());
        datePanel.add((Component)this.controlPanelDate, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel titlePanel = new JPanel(new GridBagLayout());
        if (this.mode == 1) {
            this.setTitle("\u0412\u044b\u0431\u043e\u0440 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0434\u043b\u044f \u043d\u043e\u0432\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
            this.contractTitle.setEditable(false);
            this.contractTitle.setText("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430");
            this.manually.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PatternSelectedDialog.this.contractTitle.setEditable(PatternSelectedDialog.this.manually.isSelected());
                    PatternSelectedDialog.this.getTitlePattern();
                }
            });
            titlePanel.setBorder(new BGTitleBorder("\u0428\u0430\u0431\u043b\u043e\u043d \u0438\u043c\u0435\u043d\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"));
            titlePanel.add((Component)this.manually, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 3, 2), 0, 0));
            titlePanel.add((Component)this.contractTitle, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        } else if (this.mode == 2) {
            this.setTitle("\u0412\u044b\u0431\u043e\u0440 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0434\u043b\u044f \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u0438\u043c\u0435\u043d\u0438");
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)patternListPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)datePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)titlePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        JPanel panel2 = new JPanel(new GridBagLayout());
        if (this.mode == 1) {
            final JPanel selectSuperPanel = new JPanel(new GridBagLayout());
            final JCheckBox checkBox1 = new JCheckBox("\u0421\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0434\u043b\u044f", true);
            final JCheckBox checkBox2 = new JCheckBox("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u043a\u0430\u043a \u0421\u0423\u0411\u0414\u041e\u0413\u041e\u0412\u041e\u0420 \u0434\u043b\u044f ...", false);
            final JCheckBox copyParamsChB = new JCheckBox("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", false);
            selectSuperPanel.setVisible(false);
            selectSuperPanel.setBorder(new BGComponentBorder(checkBox1, selectSuperPanel, BorderFactory.createEtchedBorder()));
            selectSuperPanel.add(this.subModeCombo, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
            selectSuperPanel.add((Component)this.superContractSelect, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            selectSuperPanel.add((Component)copyParamsChB, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 1, 5, 5), 0, 0));
            this.subModeCombo.addItem(new ComboBoxItem(0, "\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0439 \u0431\u0430\u043b\u0430\u043d\u0441"));
            this.subModeCombo.addItem(new ComboBoxItem(1, "\u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0439 \u0431\u0430\u043b\u0430\u043d\u0441"));
            panel.add((Component)selectSuperPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 7, 6, 6), 0, 0));
            panel.add((Component)checkBox2, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 5, 5), 0, 0));
            final JPanel paramPanel = new JPanel(new GridBagLayout());
            paramPanel.setBorder(new BGTitleBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"));
            paramPanel.add((Component)this.paramsList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            paramPanel.setVisible(false);
            panel2.add((Component)paramPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
            checkBox1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    selectSuperPanel.setVisible(false);
                    checkBox2.setVisible(true);
                    checkBox2.setSelected(false);
                    if (paramPanel.isVisible()) {
                        copyParamsChB.doClick();
                    }
                }
            });
            checkBox2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    selectSuperPanel.setVisible(true);
                    checkBox2.setVisible(false);
                    checkBox1.setSelected(true);
                    PatternSelectedDialog.this.subModeCombo.requestFocus();
                }
            });
            copyParamsChB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (paramPanel.isVisible()) {
                        paramPanel.setVisible(false);
                        PatternSelectedDialog.this.pack();
                        PatternSelectedDialog.this.moveWindowToCenterScreen();
                    } else {
                        String contracId = PatternSelectedDialog.this.superContractSelect.getContracts();
                        if (!Utils.notBlankString(contracId)) {
                            ClientUtils.showErrorMessageDialog("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u043d\u0430\u0447\u0430\u043b\u0435 \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0441\u0443\u043f\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
                            copyParamsChB.setSelected(false);
                            return;
                        }
                        paramPanel.setVisible(true);
                        PatternSelectedDialog.this.pack();
                        PatternSelectedDialog.this.moveWindowToCenterScreen();
                        PatternSelectedDialog.this.setParams(contracId);
                    }
                }
            });
            this.patternList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    PatternSelectedDialog.this.getTitlePattern();
                    if (paramPanel.isVisible()) {
                        PatternSelectedDialog.this.setParams(PatternSelectedDialog.this.superContractSelect.getContracts());
                    }
                }
            });
        } else if (this.mode == 2) {
            this.subName = new JCheckBox("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d \u0434\u043b\u044f \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u0440\u043e\u0432", false);
            panel.add((Component)this.subName, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 7, 6, 6), 0, 0));
        }
        panel2.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 0.255, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.setResizable(false);
        BGEditor editor = new BGEditor("panel");
        panel2.getActionMap().put("ok", new BGUAction("ok", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternSelectedDialog.this.controlPanel_actionPerformed(e);
            }
        });
        panel2.getActionMap().put("close", new BGUAction("cancel", "\u041e\u0442\u043c\u0435\u043d\u0430"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternSelectedDialog.this.controlPanel_actionPerformed(e);
            }
        });
        editor.addForm(panel2, "panel");
        this.add((Component)editor, "Center");
    }

    public int getId() {
        return this.responseCid;
    }

    private void getTitlePattern() {
        ListItem item = this.patternList.getSelectedValue();
        if (item == null) {
            this.contractTitle.setText("");
            return;
        }
        Request request = new Request();
        request.setModule("contract");
        request.setAction("GetPatternInfo");
        request.setAttribute("pid", item.getAttribute("id"));
        request.setAttribute("only_title_pattern", true);
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            Element title = XMLUtils.selectElement(doc, "//pattern");
            this.contractTitle.setText(title.getAttribute("name_pattern"));
        }
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("GetPatternList");
        this.setDocument(TransferManager.getDocument(request));
    }

    public void setDocument(Document doc) {
        String id;
        if (ClientUtils.checkStatus(doc)) {
            ClientUtils.buildList(this.patternList, XMLUtils.selectNode(doc, "//patterns"));
        }
        if ((id = ClientSetup.getInstance().getUserConfig().get(this.getClass().getName() + ".pattern")) != null) {
            ClientUtils.setListSelection(this.patternList, id);
        }
    }

    private void controlPanel_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("ok".equals(actionCommand)) {
            ListItem item = this.patternList.getSelectedValue();
            if (item == null) {
                ClientUtils.showErrorMessageDialog("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d");
                return;
            }
            if (this.controlPanelDate.getDateCalendar() == null) {
                ClientUtils.showErrorMessageDialog("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0434\u0430\u0442\u0443");
                return;
            }
            Request request = new Request();
            request.setModule("contract");
            if (this.mode == 1) {
                request.setAction("NewContract");
                request.setAttribute("super_id", this.superContractSelect.getContracts());
                request.setAttribute("sub_mode", ClientUtils.getIdFromComboBox(this.subModeCombo));
                request.setAttribute("params", this.paramsList.getListValues());
                if (this.manually.isSelected()) {
                    request.setAttribute("custom_title", this.contractTitle.getText().trim());
                }
            } else if (this.mode == 2) {
                request.setAction("WrapContract");
                request.setContractId(this.cid);
                request.setAttribute("sub_name", this.subName.isSelected());
            }
            request.setAttribute("pattern_id", item.getAttribute("id"));
            request.setAttribute("date", this.controlPanelDate.getDateString());
            Document doc = TransferManager.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                Element contract = XMLUtils.selectElement(doc, "//contract");
                String tmp = XMLUtils.getAttribute(contract, "id", "-1");
                this.responseCid = Utils.parseInt(tmp, -1);
                this.dispose();
                ClientSetup.getInstance().getUserConfig().set(this.getClass().getName() + ".pattern", (String)item.getAttribute("id"));
                ClientSetup.getInstance().saveUserConfig();
            } else {
                this.responseCid = 0;
            }
        } else if ("cancel".equals(actionCommand) || "close".equals(actionCommand)) {
            this.dispose();
        } else if ("help".equals(actionCommand)) {
            this.openHelp(PatternSelectedDialog.class.getName());
        }
    }

    private void setParams(String contractId) {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("GetContractParameters");
        request.setAttribute("cid", contractId);
        request.setAttribute("filled", true);
        ListItem item = this.patternList.getSelectedValue();
        request.setAttribute("patternId", item.getAttribute("id"));
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            ClientUtils.buildList(this.paramsList, XMLUtils.selectNode(doc, "//params"));
        }
    }
}

