/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.object;

import bitel.billing.module.common.BGControlPanelListSelect;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.table.BGTableModel;

public class ObjectTypeDirectory
extends BGPanel {
    private ObjectType objectType = null;
    private BGTextField titleField = new BGTextField();
    private BGTextField macrosField = new BGTextField();
    private JTextArea commentTextArea = new JTextArea();
    private JCheckBox hiddenCheckBox = new JCheckBox("\u0421\u043a\u0440\u044b\u0442");
    private JPanel editor = new JPanel(new GridBagLayout());
    private BGControlPanelListSelect modules = new BGControlPanelListSelect();
    private ObjectTypeTableModel objectTypeTableModel = new ObjectTypeTableModel(ObjectTypeTableModel.class.getName());

    public ObjectTypeDirectory() {
        this.jbInit();
        this.editor.setVisible(false);
    }

    private void jbInit() {
        this.macrosField.setMinimumSize(new Dimension(200, 24));
        this.macrosField.setPreferredSize(new Dimension(200, 24));
        this.commentTextArea.setMargin(new Insets(3, 3, 3, 3));
        this.editor.setLayout(new GridBagLayout());
        this.editor.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.editor.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.editor.add((Component)this.titleField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.editor.add((Component)new JLabel("\u041c\u0430\u043a\u0440\u043e\u0441: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.editor.add((Component)this.macrosField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel panelModules = new JPanel(new GridBagLayout());
        panelModules.setBorder(new TitledBorder("\u041c\u043e\u0434\u0443\u043b\u0438"));
        this.modules.setMinimumSize(new Dimension(200, 200));
        this.modules.setPreferredSize(new Dimension(200, 200));
        panelModules.add((Component)this.modules, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.editor.add((Component)panelModules, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        JPanel panelComment = new JPanel(new GridBagLayout());
        panelComment.setBorder(new TitledBorder("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"));
        panelComment.add((Component)new JScrollPane(this.commentTextArea), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.editor.add((Component)panelComment, new GridBagConstraints(2, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        JPanel isUsingPanel = new JPanel(new GridBagLayout());
        isUsingPanel.add((Component)this.hiddenCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        isUsingPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        isUsingPanel.add((Component)okCancel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.editor.add((Component)isUsingPanel, new GridBagConstraints(0, 3, 4, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        BGUTable table = new BGUTable(this.objectTypeTableModel);
        table.setSelectionMode(0);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ObjectTypeDirectory.this.editItem();
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("TypeTable");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            ArrayList data = new ArrayList();
            XMLUtils.selectElements(doc, "//table/data/row").forEach(row -> {
                ObjectType objectType = new ObjectType();
                objectType.setId(Utils.parseInt(row.getAttribute("id")));
                objectType.setHidden(Boolean.valueOf(row.getAttribute("hidden")));
                objectType.setTitle(row.getAttribute("title"));
                objectType.setMacros(row.getAttribute("macros"));
                objectType.setComment(row.getAttribute("comment"));
                data.add(objectType);
            });
            this.objectTypeTableModel.setData(data);
        }
        request = new Request();
        request.setModule("service");
        request.setAction("Modules");
        doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            ClientUtils.buildList(this.modules, (Node)XMLUtils.selectElement(doc, "//modules"));
        }
    }

    @Override
    public void deleteItem() {
        this.objectType = (ObjectType)this.objectTypeTableModel.getSelectedRow();
        if (this.objectType != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0438\u043f?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("TypeDelete");
            request.setAttribute("id", this.objectType.getId());
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.objectType = null;
                this.setData();
            }
        }
    }

    @Override
    public void editItem() {
        this.objectType = (ObjectType)this.objectTypeTableModel.getSelectedRow();
        if (this.objectType != null) {
            this.startEdit();
        }
    }

    @Override
    public void newItem() {
        this.objectType = new ObjectType();
        this.startEdit();
    }

    private void startEdit() {
        if (this.objectType.getId() == 0) {
            this.titleField.setText("");
            this.macrosField.setText("");
            this.modules.setListValues("");
        } else {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("TypeGet");
            request.setAttribute("id", this.objectType.getId());
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                Element type = XMLUtils.selectElement(doc, "//type");
                this.titleField.setText(type.getAttribute("title"));
                this.macrosField.setText(type.getAttribute("macros"));
                this.modules.setListValues(type.getAttribute("mids"));
                this.commentTextArea.setText(type.getAttribute("comment"));
                this.hiddenCheckBox.setSelected("1".equals(type.getAttribute("hidden")));
            }
        }
        this.editor.setVisible(true);
    }

    private void stopEdit(boolean save) {
        if (save) {
            String title = this.titleField.getText();
            if (Utils.isBlankString(title)) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435!");
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("TypeUpdate");
            request.setAttribute("id", this.objectType.getId());
            request.setAttribute("title", title);
            request.setAttribute("macros", this.macrosField.getText());
            request.setAttribute("mids", this.modules.getListValues());
            request.setAttribute("comment", this.commentTextArea.getText());
            request.setAttribute("hidden", this.hiddenCheckBox.isSelected());
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.editor.setVisible(false);
                this.setData();
            }
        } else {
            this.editor.setVisible(false);
        }
    }

    public class ObjectType {
        private int id;
        private boolean hidden;
        private String macros;
        private String title;
        private String comment;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void setHidden(boolean hidden) {
            this.hidden = hidden;
        }

        public String getMacros() {
            return this.macros;
        }

        public void setMacros(String macros) {
            this.macros = macros;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }

    class ObjectTypeTableModel
    extends BGTableModel<ObjectType> {
        public ObjectTypeTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 300, 500, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041c\u0430\u043a\u0440\u043e\u0441", 100, 500, 800, "macros", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u043a\u0440\u044b\u0442\u044b\u0439", 80, 80, 80, "hidden", true);
        }
    }
}

