/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common.table.renderer;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Supplier;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import ru.bitel.common.model.Period;

public class PeriodTableCellRenderer
extends DefaultTableCellRenderer {
    public static final Supplier<TableCellRenderer> DEFAULT = () -> new PeriodTableCellRenderer();
    private SimpleDateFormat dateFormat = null;

    public PeriodTableCellRenderer() {
        this(0);
        this.dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    }

    public PeriodTableCellRenderer(int horizontalAlignment) {
        this.setHorizontalAlignment(horizontalAlignment);
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Period) {
            StringBuilder text = new StringBuilder();
            Period period = (Period)value;
            text.append(this.getDate(period.getDateFrom()));
            text.append(" - ");
            text.append(this.getDate(period.getDateTo()));
            this.setText(text.toString());
        } else {
            super.setValue(value);
        }
    }

    private String getDate(Date date) {
        return date != null ? this.dateFormat.format(date) : "...";
    }
}

