/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.license.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.LicenseData;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.Storage;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;

public class LicenseLocalDao
extends AbstractDao<LicenseData> {
    public LicenseLocalDao(Connection con) {
        super(con, 0, "license");
    }

    public LicenseData getLicenseData(int licenseId) throws BGException {
        LicenseData licenseData = null;
        try {
            licenseData = (LicenseData)this.getById(licenseId);
        }
        catch (Exception e) {
            throw new BGException(e);
        }
        return licenseData;
    }

    public List<LicenseData> getLicenseDataList() throws BGException {
        return this.list("", "dt", new Object[0]);
    }

    public void deleteLicenseData(int licenseId) throws BGException {
        this.delete("id=?", licenseId);
    }

    public void activateLicenseData(int licenseId) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET active=(id=?)");
            ps.setInt(1, licenseId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    @Override
    protected LicenseData getFromRS(ResultSet rs) throws BGException, SQLException {
        LicenseData licenseData = new LicenseData();
        licenseData.setId(rs.getInt("id"));
        licenseData.setActive(rs.getBoolean("active"));
        licenseData.setCreateDate(rs.getTimestamp("dt"));
        licenseData.setCount(rs.getInt("count"));
        licenseData.setStorage(Storage.DATABASE);
        licenseData.setHash(rs.getString("hash"));
        licenseData.setEncryptData(rs.getString("encryptData"));
        licenseData.setPlainData(rs.getString("plainData"));
        return licenseData;
    }

    @Override
    protected void updateImpl(LicenseData licenseLocalData) throws BGException, SQLException {
        if (licenseLocalData != null) {
            String query = new StringBuffer("INSERT INTO ").append(this.tableName).append(" SET id=?, active=?, dt=?, count=?, hash=?, encryptData=?, plainData=?").toString();
            int index = 1;
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(index++, licenseLocalData.getId());
            ps.setBoolean(index++, licenseLocalData.isActive());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp(licenseLocalData.getCreateDate()));
            ps.setInt(index++, licenseLocalData.getCount());
            ps.setString(index++, licenseLocalData.getHash());
            ps.setString(index++, licenseLocalData.getEncryptData());
            ps.setString(index++, licenseLocalData.getPlainData());
            ps.executeUpdate();
            ps.close();
        }
    }
}

