/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.GroupRight;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RightType;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserRightRule;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserRightRuleAction;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserRightRuleService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.table.BGTableModel;

public class RightRulePanel
extends BGUPanel {
    private GroupRight groupRight = null;
    private BGUTable rightTable;
    private UserRightTableModel rightTableModel;
    private UserRightRuleService userRightRuleService;

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.rightTable = new BGUTable(this.getUserRightTableModel());
        int gridy = 0;
        this.add((Component)this.getFilterPanel(), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JScrollPane(this.rightTable), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getFilterPanel() {
        JToggleButton buttonAny = new JToggleButton("\u041b\u044e\u0431\u043e\u0439");
        JToggleButton buttonSystem = new JToggleButton(RightType.SYSTEM.name());
        JToggleButton buttonCustom = new JToggleButton(RightType.CUSTOM.name());
        buttonAny.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(buttonAny);
        buttonGroup.add(buttonSystem);
        buttonGroup.add(buttonCustom);
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0422\u0438\u043f:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)buttonAny, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)buttonSystem, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)buttonCustom, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        return panel;
    }

    private UserRightTableModel getUserRightTableModel() {
        if (this.rightTableModel == null) {
            this.rightTableModel = new UserRightTableModel(UserRightTableModel.class.getName());
        }
        return this.rightTableModel;
    }

    public void setGroupRight(GroupRight groupRight) {
        this.groupRight = groupRight;
        this.performAction("refresh");
    }

    @Override
    protected void initActions() {
        super.initActions();
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                RightRulePanel.this.getUserRightTableModel().setData(RightRulePanel.this.getUserRightRuleService().getUserRightRules(RightRulePanel.this.groupRight.getId()));
            }
        };
        new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u043e\u0435"){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                UserRightRule userRightRule = new UserRightRule();
                userRightRule.setRightGroupId(RightRulePanel.this.groupRight.getId());
                userRightRule.setModuleId(RightRulePanel.this.groupRight.getModuleId());
                userRightRule.setRightType(RightType.CUSTOM);
                RightRulePanel.this.getRightRuleDialog("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u0430", userRightRule).setVisible(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                UserRightRule userRightRule = (UserRightRule)RightRulePanel.this.getUserRightTableModel().getSelectedRow();
                if (userRightRule == null) {
                    ClientUtils.showMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u043e \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                } else if (userRightRule.getRightType().equals((Object)RightType.SYSTEM)) {
                    ClientUtils.showMessageDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u0430\u0432\u0438\u043b \u0441 \u0442\u0438\u043f\u043e\u043c SYSTEM \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e");
                } else {
                    RightRulePanel.this.getRightRuleDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u0430", userRightRule).setVisible(true);
                }
            }
        };
    }

    private UserRightRuleService getUserRightRuleService() {
        if (this.userRightRuleService == null) {
            this.userRightRuleService = ((ClientContext)this.getContext()).getPort(UserRightRuleService.class);
        }
        return this.userRightRuleService;
    }

    private JDialog getRightRuleDialog(String dialogTitle, UserRightRule userRightRule) {
        BGTextField title = new BGTextField(50);
        RuleTypePanel ruleTypePanel = new RuleTypePanel();
        Component[][] components = new Component[][]{{new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), title}, {new JLabel("\u0422\u0438\u043f \u043f\u0440\u0430\u0432\u0438\u043b\u0430:"), ruleTypePanel}, {new JLabel("Mask:"), ruleTypePanel.mask}, {new JLabel("Name:"), ruleTypePanel.name}, {new JLabel("Operation:"), ruleTypePanel.operation}};
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        ClientUtils.addComponentToPanel(panel, gridy, components, true);
        title.setText(userRightRule.getTitle());
        String rule = userRightRule.getRule();
        if (rule == null) {
            ruleTypePanel.setCurrentType(false);
        } else {
            JSONObject ruleJson = new JSONObject(rule);
            String maskValue = ruleJson.optString("mask", null);
            ruleTypePanel.setCurrentType(maskValue != null);
            if (maskValue != null) {
                ruleTypePanel.mask.setText(maskValue);
            } else {
                ruleTypePanel.name.setText(ruleJson.optString("name"));
                ruleTypePanel.operation.setText(ruleJson.optString("operation"));
            }
        }
        BGOptionPane optionPane = new BGOptionPane((Object)panel, dialogTitle);
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).setText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
            boolean error = Utils.isBlankString(title.getText());
            if (ruleTypePanel.typeAction.isSelected()) {
                error = error || Utils.isBlankString(ruleTypePanel.mask.getText());
            } else {
                error = error || Utils.isBlankString(ruleTypePanel.name.getText());
                boolean bl = error = error || Utils.isBlankString(ruleTypePanel.operation.getText());
            }
            if (error) {
                ClientUtils.showErrorMessageDialog("\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u0432\u0441\u0435 \u043f\u043e\u043b\u044f");
                return;
            }
            try {
                userRightRule.setTitle(title.getText());
                ObjectMapper mapper = new ObjectMapper();
                if (ruleTypePanel.typeService.isSelected()) {
                    ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserRightRuleService rightRuleService = new ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserRightRuleService();
                    rightRuleService.setName(ruleTypePanel.name.getText());
                    rightRuleService.setOperation(ruleTypePanel.operation.getText());
                    userRightRule.setRule(mapper.writeValueAsString((Object)rightRuleService));
                } else if (ruleTypePanel.typeAction.isSelected()) {
                    UserRightRuleAction rightRuleAction = new UserRightRuleAction();
                    rightRuleAction.setMask(ruleTypePanel.mask.getText());
                    userRightRule.setRule(mapper.writeValueAsString((Object)rightRuleAction));
                }
                this.getUserRightRuleService().updateUserRightRule(userRightRule);
                this.performAction("refresh");
                dialog.setVisible(false);
                dialog.dispose();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        });
        return dialog;
    }

    class UserRightTableModel
    extends BGTableModel<UserRightRule> {
        public UserRightTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, 400, 600, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0440\u0430\u0432\u0438\u043b\u043e", -1, -1, -1, "rule", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0438\u043f", 60, 60, 60, "rightType", false, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u043d\u043e", Boolean.class, 70, 70, 70, "active", false);
        }

        @Override
        public Object getValueAt(UserRightRule userRightRule, int column) throws BGException {
            return super.getValueAt(userRightRule, column);
        }
    }

    class RuleTypePanel
    extends JPanel {
        JRadioButton typeAction = new JRadioButton("Action");
        JRadioButton typeService = new JRadioButton("Service");
        BGTextField name = new BGTextField(50);
        BGTextField mask = new BGTextField(50);
        BGTextField operation = new BGTextField(50);

        public RuleTypePanel() {
            this.typeAction.addActionListener(e -> this.setCurrentType(true));
            this.typeService.addActionListener(e -> this.setCurrentType(false));
            ButtonGroup typeGroup = new ButtonGroup();
            typeGroup.add(this.typeAction);
            typeGroup.add(this.typeService);
            this.typeService.setSelected(true);
            this.add(this.typeAction);
            this.add(this.typeService);
        }

        public void setCurrentType(boolean fl) {
            this.typeAction.setSelected(fl);
            this.mask.setEditable(fl);
            this.name.setEditable(!fl);
            this.operation.setEditable(!fl);
        }
    }
}

