/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.managed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ContainerContext;
import ru.bitel.bgbilling.kernel.container.resource.ResourceManager;
import ru.bitel.bgbilling.kernel.container.service.server.ServiceFactory;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.Commitable;
import ru.bitel.common.worker.CommitableHandler;
import ru.bitel.common.worker.Recyclable;

public class ServerContext
extends ContainerContext
implements Recyclable,
Commitable,
CommitableHandler {
    private static final Logger logger = LogManager.getLogger();
    private static final Context ENVIRONMENT;
    private List<Event> publishAfterCommitEventList = null;
    private List<Commitable> commitableList = null;
    private Map<Key, Object> serviceMap = null;
    private Map<Key, Object> directoryMap = null;
    private ServiceFactory serviceFactory;

    protected ServerContext(ServerContext parent) {
        this(parent, parent.getModuleId(), parent.getModuleSetup());
    }

    protected ServerContext(ServerContext parent, int moduleId) {
        this(parent, parent.getModuleId(), null);
    }

    private ServerContext(ServerContext parent, int moduleId, ModuleSetup moduleSetup) {
        super(ENVIRONMENT, parent.getNamingContext(), parent.getSetup(), moduleSetup, parent.getConnectionSet(), moduleId, parent.getUserId(), parent.getResourceManager());
        this.publishAfterCommitEventList = parent.publishAfterCommitEventList != null ? parent.publishAfterCommitEventList : (parent.publishAfterCommitEventList = new ArrayList<Event>(4));
        this.commitableList = parent.commitableList != null ? parent.commitableList : (parent.commitableList = new ArrayList<Commitable>(4));
        this.serviceFactory = parent.serviceFactory != null ? parent.serviceFactory : parent.getServiceFactory();
        this.serviceMap = parent.serviceMap != null ? parent.serviceMap : (parent.serviceMap = new HashMap<Key, Object>(8));
        this.directoryMap = parent.directoryMap != null ? parent.directoryMap : (parent.directoryMap = new HashMap<Key, Object>(8));
    }

    private ServerContext(Context context, Setup setup, ModuleSetup moduleSetup, ConnectionSet connectionSet, int moduleId, int userId, ResourceManager resourceManager) {
        super(ENVIRONMENT, context, setup, moduleSetup, connectionSet, moduleId, userId, resourceManager);
    }

    public ServerContext(Setup setup, ConnectionSet connectionSet, int moduleId, int userId) {
        this(null, setup, null, connectionSet, moduleId, userId, null);
    }

    public ServerContext(Setup setup, int moduleId, int userId) {
        this(null, setup, null, ConnectionSet.newInstance((DefaultServerSetup)setup, false), moduleId, userId, null);
    }

    public ServerContext(Setup setup, int moduleId, ConnectionSet connectionSet, int userId) {
        this(null, setup, null, connectionSet, moduleId, userId, null);
    }

    public ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceManager();
        }
        return this.resourceManager;
    }

    private ServiceFactory getServiceFactory() {
        if (this.serviceFactory == null) {
            this.serviceFactory = new ServiceFactory();
        }
        return this.serviceFactory;
    }

    public <T> T getService(Class<T> clazz, int moduleId) throws BGException {
        Key key;
        Object result;
        if (this.serviceMap == null) {
            this.serviceMap = new HashMap<Key, Object>();
        }
        if ((result = this.serviceMap.get(key = new Key(clazz, moduleId))) == null) {
            result = this.getServiceFactory().create(this, clazz, moduleId);
        }
        if (result == null) {
            throw new BGException("Unable to create web-service " + clazz.getCanonicalName() + ". See log files");
        }
        this.serviceMap.put(key, result);
        return (T)result;
    }

    public <T> T newService(Class<T> clazz, int moduleId) throws BGException {
        return this.getServiceFactory().create(this, clazz, moduleId);
    }

    public <K extends Id> Directory<K> getDirectory(Class<K> clazz, int typeOrMid) throws BGException {
        return ServerDirectoryFactory.newDirectory(this, clazz, this.connectionSet.getConnection(), typeOrMid, true);
    }

    public <K extends Id> Directory<K> newDirectory(Class<K> clazz, int typeOrMid) throws BGException {
        return ServerDirectoryFactory.newDirectory(this, clazz, this.connectionSet.getConnection(), typeOrMid, false);
    }

    public void publishAfterCommit(Event e) {
        if (this.publishAfterCommitEventList == null) {
            this.publishAfterCommitEventList = new ArrayList<Event>(4);
        }
        this.publishAfterCommitEventList.add(e);
    }

    @Override
    public void addCommitable(Commitable commitable) {
        if (this.commitableList == null) {
            this.commitableList = new ArrayList<Commitable>(4);
        }
        this.commitableList.add(commitable);
    }

    @Override
    public void commit() throws BGException {
        this.connectionSet.commit();
        if (this.resourceManager != null) {
            this.resourceManager.commit();
        }
        if (this.commitableList != null && this.commitableList.size() > 0) {
            for (Commitable commitable : this.commitableList) {
                try {
                    commitable.commit();
                }
                catch (BGException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BGException(e);
                }
            }
            this.commitableList.clear();
        }
        if (Utils.notEmptyCollection(this.publishAfterCommitEventList)) {
            EventProcessor ep = EventProcessor.getInstance();
            for (Event e : this.publishAfterCommitEventList) {
                ep.publish(e);
            }
            this.publishAfterCommitEventList.clear();
        }
    }

    @Override
    public void recycle() {
        if (this.resourceManager != null) {
            this.resourceManager.recycle();
        }
        if (this.publishAfterCommitEventList != null) {
            this.publishAfterCommitEventList.clear();
        }
        if (this.commitableList != null) {
            this.commitableList.clear();
        }
        if (this.serviceFactory != null) {
            this.serviceFactory.recycle();
        }
        if (this.serviceMap != null) {
            this.serviceMap.clear();
        }
        if (this.directoryMap != null) {
            this.directoryMap.clear();
        }
        this.connectionSet.recycle();
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void destroy() {
        if (this.resourceManager != null) {
            this.resourceManager.recycle();
        }
        if (this.publishAfterCommitEventList != null) {
            this.publishAfterCommitEventList.clear();
        }
        if (this.commitableList != null) {
            this.commitableList.clear();
        }
        super.destroy();
    }

    static {
        Context env = null;
        try {
            env = DefaultServerSetup.getEnvironment();
        }
        catch (NamingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        ENVIRONMENT = env;
    }

    static final class Key {
        final Class<?> clazz;
        final int moduleId;

        public Key(Class<?> clazz, int moduleId) {
            this.clazz = clazz;
            this.moduleId = moduleId;
        }

        public int hashCode() {
            return 31 * (31 + this.clazz.hashCode()) + this.moduleId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            Key other = (Key)obj;
            return this.clazz.equals(other.clazz) && this.moduleId == other.moduleId;
        }
    }
}

