/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.label.server.service;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelItem;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService")
public class ContractLabelServiceImpl
extends AbstractService
implements ContractLabelService {
    ContractLabelManager contractLabelManager;

    @PostConstruct
    public void init() {
        this.contractLabelManager = new ContractLabelManager(this.getConnection());
    }

    @Override
    public List<ContractLabelItem> getContractLabelTreeItemList(int contractId, boolean calcCount) throws BGException {
        List<ContractLabelItem> contractLabelItems = this.contractLabelManager.getContractLabelItemList(calcCount);
        if (contractId > 0) {
            List<Integer> contractLabelSet = this.contractLabelManager.getContractLabelIds(contractId);
            for (ContractLabelItem contractLabelItem : contractLabelItems) {
                contractLabelItem.setSelected(contractLabelSet.contains(contractLabelItem.getId()));
            }
        }
        Collections.sort(contractLabelItems);
        return contractLabelItems;
    }

    @Override
    public List<Integer> getContractLabelIds(int contractId) throws BGException {
        return this.contractLabelManager.getContractLabelIds(contractId);
    }

    @Override
    public void setContractLabelIds(int contractId, List<Integer> contractLabelsIds) throws BGException {
        this.contractLabelManager.setContractLabelIds(contractId, contractLabelsIds);
        EventProcessor.getInstance().publish(new ContractModifiedEvent(this.userId, contractId));
    }

    @Override
    public void setContractLabelTreeItemList(int contractId, List<ContractLabelItem> items) throws BGException {
        if (items != null) {
            this.contractLabelManager.setContractLabelIds(contractId, items.stream().mapToInt(Id::getId).boxed().collect(Collectors.toList()));
            EventProcessor.getInstance().publish(new ContractModifiedEvent(this.userId, contractId));
        }
    }

    @Override
    public int updateContractLabelTreeItem(ContractLabelItem contractLabelItem) throws BGException {
        Objects.requireNonNull(contractLabelItem);
        this.contractLabelManager.updateContractLabelTreeItem(contractLabelItem);
        return contractLabelItem.getId();
    }

    @Override
    public void updateContractLabelTreeItems(List<ContractLabelItem> items) throws BGException {
        if (Utils.notEmptyCollection(items)) {
            for (ContractLabelItem item : items) {
                this.contractLabelManager.updateContractLabelTreeItem(item);
            }
        }
    }

    @Override
    public void removeContractLabelTreeItem(int contractLabelItemId) throws BGException {
        this.contractLabelManager.removeContractLabelItem(contractLabelItemId);
    }

    @Override
    public ContractLabelItem getContractLabelTree() throws BGException {
        return this.contractLabelManager.getTree();
    }

    @Override
    public void syncLabelAndGroupDirectory() throws BGException {
        this.contractLabelManager.syncLabelAndGroupDirectory();
    }

    @Override
    public void syncLabelAndGroupContract(int contractId) throws BGException {
        this.contractLabelManager.syncLabelAndGroupContract(contractId);
    }

    @Override
    public int getContractCountByLabel(int labelId) throws BGException {
        return this.contractLabelManager.getContractCountByLabel(labelId);
    }
}

