/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.server.utils;

import bitel.billing.server.admin.bean.AddressManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.internet.InternetAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.parameter.ContractParameterGroupAttrDao;
import ru.bitel.bgbilling.kernel.contract.loader.server.bean.LoaderUtil;
import ru.bitel.bgbilling.kernel.contract.loader.server.utils.LoaderBase;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttrType;

public class LoaderParameterConvertUtil
extends LoaderBase
implements LoaderUtil {
    private Logger log = LogManager.getLogger();

    @Override
    public String execute(String data, String config) throws BGException {
        JSONObject configJsonObject = new JSONObject(config);
        int sourceParameterId = configJsonObject.optInt("sourceParameterId", 0);
        int targetParameterId = configJsonObject.optInt("targetParameterId", 0);
        try {
            String mode = configJsonObject.optString("mode", "append");
            if ("replace".equals(mode)) {
                this.deleteParameter(targetParameterId);
            }
            try (ContractDao contractDao = new ContractDao(this.con, 0);
                 ContractParameterGroupAttrDao contractParameterGroupAttrDao = new ContractParameterGroupAttrDao(this.con);){
                AddressManager addressManager = new AddressManager(this.con, (DefaultServerSetup)this.setup);
                ContractParameterGroupAttr contractParameterGroupAttr = (ContractParameterGroupAttr)((Object)contractParameterGroupAttrDao.get(targetParameterId));
                PreparedStatement psSelect = this.con.prepareStatement("SELECT id FROM contract");
                ResultSet resultSet = psSelect.executeQuery();
                block22: while (resultSet.next()) {
                    String val;
                    int contractId = resultSet.getInt(1);
                    EntityAttr entityAttr = contractDao.getContractParameter(contractId, sourceParameterId);
                    if (entityAttr == null || !Utils.notBlankString(val = entityAttr.toString())) continue;
                    switch (EntitySpecAttrType.getEntitySpecAttrType((int)contractParameterGroupAttr.getType())) {
                        case DATE: {
                            Date date = TimeUtils.parseDate(val, "dd.MM.yyyy");
                            if (date == null) break;
                            contractDao.updateContractParameter(contractId, (EntityAttr)new EntityAttrDate(contractId, targetParameterId, date));
                            break;
                        }
                        case EMAIL: {
                            List<String> emails = Utils.toList(val, "\n ;,");
                            if (emails.isEmpty()) break;
                            ArrayList<EntityAttrEmail.EmailContact> contacts = new ArrayList<EntityAttrEmail.EmailContact>();
                            for (String email : emails) {
                                InternetAddress[] addresses = InternetAddress.parse((String)email);
                                if (addresses == null) continue;
                                int size = addresses.length;
                                for (int index = 0; index < size; ++index) {
                                    contacts.add(new EntityAttrEmail.EmailContact(addresses[index].getPersonal(), addresses[index].getAddress()));
                                }
                            }
                            if (contacts.isEmpty()) continue block22;
                            EntityAttrEmail entityAttrEmail = (EntityAttrEmail)contractDao.getContractParameter(contractId, targetParameterId);
                            if (entityAttrEmail == null) {
                                entityAttrEmail = new EntityAttrEmail(contractId, targetParameterId);
                            }
                            entityAttrEmail.getContactList().addAll(contacts);
                            contractDao.updateContractParameter(contractId, (EntityAttr)entityAttrEmail);
                            break;
                        }
                        case PHONE: {
                            if (!val.matches("^\\+\\d{11}$")) break;
                            EntityAttrPhone entityAttrPhone = (EntityAttrPhone)contractDao.getContractParameter(contractId, targetParameterId);
                            if (entityAttrPhone == null) {
                                entityAttrPhone = new EntityAttrPhone(contractId, targetParameterId);
                            }
                            entityAttrPhone.addContact(val, "");
                            contractDao.updateContractParameter(contractId, (EntityAttr)entityAttrPhone);
                            break;
                        }
                        case ADDRESS: {
                            try {
                                JSONObject jsonObject = new JSONObject(val);
                                String country = jsonObject.optString("country", "\u0420\u043e\u0441\u0441\u0438\u044f");
                                String city = jsonObject.optString("city");
                                String street = jsonObject.optString("street");
                                String houseFrac = jsonObject.optString("house");
                                String flat = jsonObject.optString("flat");
                                String postIndex = jsonObject.optString("postIndex");
                                int houseId = addressManager.getHouseId(country, city, street, houseFrac, postIndex, true);
                                if (houseId <= 0) continue block22;
                                EntityAttrAddress entityAttrAddress = new EntityAttrAddress(contractId, targetParameterId, houseId, 0, 0, flat, "", "", null, val);
                                contractDao.updateContractParameter(contractId, (EntityAttr)entityAttrAddress);
                            }
                            catch (Exception e) {
                                this.log.error((Object)e);
                            }
                            break;
                        }
                    }
                }
                resultSet.close();
                psSelect.close();
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new BGException(e);
        }
        return null;
    }
}

