/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.kernel.event.common.Event;

public abstract class AsyncEventWorker<E extends Event>
extends EventWorker {
    private static final Logger logger = LogManager.getLogger();
    private final LinkedBlockingDeque<Object> internalDeque = new LinkedBlockingDeque(1000000);
    protected long waitNextTask = 5000L;
    protected int batchSize = 20;
    protected long batchPause = 0L;
    protected final boolean needAcknowledge;
    private int count;
    private List<FutureTaskEntry> taskEntryList;
    protected long errorCount = 0L;
    private String lastProcessedMessageID;

    public AsyncEventWorker(EventProcessor ep, Class<? extends Event> clazz, int moduleId, int pluginId, String query) throws BGException {
        super(ep, clazz, moduleId, pluginId, query);
        this.needAcknowledge = true;
    }

    public AsyncEventWorker(EventProcessor ep, String destination, int moduleId, int pluginId, String query, boolean autoAcknowledge, Class<?> ... clazz) throws BGException {
        super(ep, destination, moduleId, pluginId, query, autoAcknowledge, clazz);
        this.needAcknowledge = !autoAcknowledge;
    }

    @Override
    protected Object poll(long timeout) throws BGException {
        Object result = this.pollFirstTask();
        if (result != null) {
            return result;
        }
        result = this.internalDeque.poll();
        if (result != null) {
            return result;
        }
        try {
            Message o = this.consumer.mc.receive(timeout);
            return o;
        }
        catch (JMSException ex) {
            throw new BGException(ex);
        }
    }

    protected void putFirst(Object task) throws InterruptedException {
        this.internalDeque.putFirst(task);
    }

    protected void putLast(Object task) throws InterruptedException {
        this.internalDeque.putLast(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doTasks() throws BGException {
        try {
            this.taskEntryList = new ArrayList<FutureTaskEntry>();
            this.count = 0;
            long halfWaitNextTask = this.waitNextTask / 2L;
            long waitNextTask = this.waitNextTask;
            Object task = this.poll(waitNextTask);
            while (task != null) {
                ++this.errorCount;
                if (!this.internalDoTask(task)) {
                    boolean bl = false;
                    return bl;
                }
                if (this.waitNextTask > 400L) {
                    long nanos = this.awaitResult(this.taskEntryList, halfWaitNextTask, TimeUnit.MILLISECONDS, false);
                    waitNextTask = nanos > 0L ? TimeUnit.NANOSECONDS.toMillis(nanos) + halfWaitNextTask : halfWaitNextTask;
                }
                this.errorCount = 0L;
                task = this.poll(waitNextTask);
            }
            while ((task = this.poll(waitNextTask)) != null) {
                ++this.errorCount;
                if (!this.internalDoTask(task)) {
                    boolean bl = false;
                    return bl;
                }
                this.errorCount = 0L;
            }
            if (this.taskEntryList.size() > 0) {
                long nanos;
                if (logger.isDebugEnabled()) {
                    logger.debug("Waiting " + this.batchWait + " millis for last future results will done...");
                }
                if ((nanos = this.awaitResult(this.taskEntryList, this.batchWait, TimeUnit.MILLISECONDS, true)) < 0L) {
                    throw new BGException(new TimeoutException("Timeout waiting for future results will done. Possible answer not recieved."));
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.taskEntryList = null;
            this.count = 0;
        }
        return false;
    }

    @Override
    protected boolean internalDoTask(Object task) throws JMSException, JAXBException, BGException {
        if (task instanceof Message) {
            Message message = (Message)task;
            if (this.lastProcessedMessageID != null && this.lastProcessedMessageID.equals(message.getJMSMessageID())) {
                logger.info("Skip message as already processed");
                if (this.needAcknowledge) {
                    message.acknowledge();
                }
                this.lastProcessedMessageID = null;
                return true;
            }
            if (!this.consumer.onMessage0((Message)task, (EventListenerContext)this.context, this)) {
                return false;
            }
        } else {
            this.internalDoTaskImpl(task);
            if (task instanceof Event) {
                Event e = (Event)task;
                this.lastProcessedMessageID = e.getMessageID();
            }
            ((EventListenerContext)this.context).commit();
        }
        return true;
    }

    @Override
    public void notify(Event task, EventListenerContext ctx) throws BGException {
        this.internalDoTaskImpl(task);
    }

    private void internalDoTaskImpl(Object task) throws BGException {
        boolean inDoTask = true;
        try {
            Object result = this.doTask(task);
            inDoTask = false;
            ++this.count;
            if (result instanceof Object[]) {
                Object[] array = (Object[])result;
                result = array[0];
                array[0] = task;
                if (result instanceof Future) {
                    this.taskEntryList.add(new FutureTaskEntry(array, (Future)result));
                } else {
                    this.taskDone(array, result);
                }
            } else if (result instanceof Future) {
                this.taskEntryList.add(new FutureTaskEntry(task, (Future)result));
            } else {
                this.taskDone(task, result);
            }
            if (this.batchSize <= 0) {
                if (this.taskEntryList.size() > 20) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Waiting " + this.batchWait + " millis for future results will done...");
                    }
                    if (this.awaitResult(this.taskEntryList, this.batchWait, TimeUnit.MILLISECONDS, true) < 0L) {
                        this.printTimeoutError(this.taskEntryList);
                        throw new BGException(new TimeoutException("Timeout waiting task done (or answer)"));
                    }
                } else {
                    this.processDoneResult(this.taskEntryList);
                }
            } else if ((this.count + 1) % this.batchSize == 0) {
                if (this.taskEntryList.size() > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Waiting " + this.batchWait + " millis for future results will done...");
                    }
                    if (this.awaitResult(this.taskEntryList, this.batchWait, TimeUnit.MILLISECONDS, true) < 0L) {
                        this.printTimeoutError(this.taskEntryList);
                        throw new BGException(new TimeoutException("Timeout waiting task done (or answer)"));
                    }
                }
                if (this.batchPause > 0L) {
                    Thread.sleep(this.batchPause);
                }
            } else {
                this.processDoneResult(this.taskEntryList);
            }
        }
        catch (BGException ex) {
            this.processDoTaskException(task, inDoTask, true, ex, true);
        }
        catch (InterruptedException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            Thread.interrupted();
        }
    }

    protected void processDoTaskException(Object task, boolean inDoTask, boolean putFirstIfInDoTask, BGException ex, boolean throwException) throws BGException {
        try {
            boolean inTaskEntryList = false;
            for (FutureTaskEntry entry : this.taskEntryList) {
                if (entry.task == task) {
                    inTaskEntryList = true;
                }
                this.putFirst(entry.task);
            }
            if (!(!putFirstIfInDoTask && inDoTask || inTaskEntryList)) {
                this.putFirst(task);
            }
        }
        catch (InterruptedException iex) {
            logger.error(iex.getMessage(), (Throwable)iex);
            Thread.interrupted();
        }
        if (throwException) {
            throw ex;
        }
    }

    private void printTimeoutError(List<FutureTaskEntry> taskEntryList) {
        for (FutureTaskEntry entry : taskEntryList) {
            Future<?> f = entry.result;
            if (f.isDone()) continue;
            if (entry.task instanceof Object[]) {
                logger.error("Timeout waiting task done (or answer): " + ((Object[])entry.task)[0]);
                continue;
            }
            logger.error("Timeout waiting task done (or answer): " + entry.task);
        }
    }

    protected abstract void taskDone(Object var1, Object var2) throws BGException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long awaitResult(List<FutureTaskEntry> taskEntryList, long timeout, TimeUnit unit, boolean checkDone) throws InterruptedException, BGException {
        if (taskEntryList.size() == 0) {
            return 0L;
        }
        nanos = unit.toNanos(timeout);
        done = false;
        try {
            lastTime = System.nanoTime();
            iter = taskEntryList.iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                f = entry.result;
                result /* !! */  = Boolean.FALSE;
                if (f.isDone()) ** GOTO lbl41
                if (nanos > 0L) break block28;
                var15_13 = -1L;
                if (!checkDone || done) ** GOTO lbl74
            }
            ** GOTO lbl51
        }
        catch (Throwable var23_33) {
            block32: {
                block33: {
                    if (!checkDone || done) break block32;
                    AsyncEventWorker.logger.info("Timeout waiting futures");
                    iter = taskEntryList.iterator();
                    break block33;
lbl101:
                    // 3 sources

                    while (iter.hasNext()) {
                        entry = iter.next();
                        f = entry.result;
                        if (f.isDone()) {
                            result /* !! */  = Boolean.FALSE;
                            try {
                                result /* !! */  = f.get();
                            }
                            catch (ExecutionException ex) {
                                AsyncEventWorker.logger.error(ex.getMessage(), (Throwable)ex);
                            }
                            iter.remove();
                            this.taskDone(entry.task, result /* !! */ );
                            continue;
                        }
                        f.cancel(true);
                        this.taskTimeout(entry.task);
                    }
lbl118:
                    // 2 sources

                    return var11_9;
                }
                while (iter.hasNext()) {
                    entry = iter.next();
                    f = entry.result;
                    if (f.isDone()) {
                        result /* !! */  = Boolean.FALSE;
                        try {
                            result /* !! */  = f.get();
                        }
                        catch (ExecutionException ex) {
                            AsyncEventWorker.logger.error(ex.getMessage(), (Throwable)ex);
                        }
                        iter.remove();
                        this.taskDone(entry.task, result /* !! */ );
                        continue;
                    }
                    f.cancel(true);
                    this.taskTimeout(entry.task);
                }
            }
            throw var23_33;
        }
        {
            block28: {
                AsyncEventWorker.logger.info("Timeout waiting futures");
                iter = taskEntryList.iterator();
                ** GOTO lbl57
            }
            try {
                result /* !! */  = f.get(nanos, TimeUnit.NANOSECONDS);
                ** GOTO lbl37
            }
            catch (CancellationException var15_14) {
                ** GOTO lbl37
            }
            catch (ExecutionException ex) {
                AsyncEventWorker.logger.error(ex.getMessage(), (Throwable)ex);
                ** GOTO lbl37
            }
            catch (TimeoutException toe) {
                block29: {
                    block30: {
                        block31: {
                            var16_30 = -1L;
                            if (!checkDone || done) break block29;
                            AsyncEventWorker.logger.info("Timeout waiting futures");
                            iter = taskEntryList.iterator();
                            break block30;
lbl37:
                            // 4 sources

                            now = System.nanoTime();
                            nanos -= now - lastTime;
                            lastTime = now;
                            break block31;
lbl41:
                            // 1 sources

                            try {
                                result /* !! */  = f.get();
                            }
                            catch (ExecutionException ex) {
                                AsyncEventWorker.logger.error(ex.getMessage(), (Throwable)ex);
                            }
                        }
                        AsyncEventWorker.logger.info("Future is done");
                        iter.remove();
                        this.taskDone(entry.task, result /* !! */ );
                        continue;
lbl51:
                        // 1 sources

                        done = true;
                        var11_9 = Math.max(nanos, 0L);
                        if (!checkDone || done) ** GOTO lbl118
                        AsyncEventWorker.logger.info("Timeout waiting futures");
                        iter = taskEntryList.iterator();
                        ** GOTO lbl101
lbl57:
                        // 3 sources

                        while (iter.hasNext()) {
                            entry = iter.next();
                            f = entry.result;
                            if (f.isDone()) {
                                result /* !! */  = Boolean.FALSE;
                                try {
                                    result /* !! */  = f.get();
                                }
                                catch (ExecutionException ex) {
                                    AsyncEventWorker.logger.error(ex.getMessage(), (Throwable)ex);
                                }
                                iter.remove();
                                this.taskDone(entry.task, result /* !! */ );
                                continue;
                            }
                            f.cancel(true);
                            this.taskTimeout(entry.task);
                        }
lbl74:
                        // 2 sources

                        return var15_13;
                    }
                    while (iter.hasNext()) {
                        entry = iter.next();
                        f = entry.result;
                        if (f.isDone()) {
                            result /* !! */  = Boolean.FALSE;
                            try {
                                result /* !! */  = f.get();
                            }
                            catch (ExecutionException ex) {
                                AsyncEventWorker.logger.error(ex.getMessage(), (Throwable)ex);
                            }
                            iter.remove();
                            this.taskDone(entry.task, result /* !! */ );
                            continue;
                        }
                        f.cancel(true);
                        this.taskTimeout(entry.task);
                    }
                }
                return var16_30;
                break;
            }
        }
    }

    protected void taskTimeout(Object task) {
    }

    private void processDoneResult(List<FutureTaskEntry> taskEntryList) throws InterruptedException, BGException {
        if (taskEntryList.size() == 0) {
            return;
        }
        Iterator<FutureTaskEntry> iter = taskEntryList.iterator();
        while (iter.hasNext()) {
            FutureTaskEntry entry = iter.next();
            Future<?> f = entry.result;
            if (!f.isDone()) continue;
            Boolean result = Boolean.FALSE;
            try {
                result = f.get();
            }
            catch (ExecutionException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            logger.info("Future is done");
            iter.remove();
            this.taskDone(entry.task, result);
        }
    }

    class FutureTaskEntry {
        final Object task;
        final Future<?> result;

        public FutureTaskEntry(Object task, Future<?> result) {
            this.task = task;
            this.result = result;
        }
    }
}

