/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.eap;

import bitel.billing.server.radius.auth.eap.tls.TLSTunnel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JComboBox;
import javax.swing.plaf.ComboBoxUI;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusSession;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPAuthenticator;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPMessage;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPSession;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.common.Preferences;
import ru.bitel.common.sql.ConnectionSet;

public class EAPTLSAuthenticator<N extends Nas<?, ?, ?>, P>
implements EAPAuthenticator<N, P> {
    protected static final byte TLS_START = 32;
    protected static final byte TLS_MORE_FRAGMENTS = 64;
    protected static final byte TLS_HAS_LENGTH = -128;
    public static final byte[] TLS_START_A = new byte[]{32};
    protected static TLSTunnel.Context tlsContext = null;
    protected final EAPSession<N, P> session;
    protected final TLSTunnel tunnel;
    private byte[] eapFragmentedReply = null;
    private int eapFragmentedOffset = 0;
    private ByteArrayOutputStream input = new ByteArrayOutputStream(512);

    public static void init(Preferences setup) {
        TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        tlsContext = new TLSTunnel.Context(setup, trustManagers, false);
    }

    @Override
    public byte getAuthentificatorType() {
        return 13;
    }

    protected EAPTLSAuthenticator(EAPSession<N, P> session) {
        this.session = session;
        this.tunnel = tlsContext.createTunnel();
    }

    @Override
    public EAPMessage start() {
        this.session.identifier = (byte)(this.session.identifier + 1);
        return new EAPMessage(1, this.session.identifier, 13, ByteBuffer.wrap(TLS_START_A));
    }

    @Override
    public EAPMessage authenticate(EAPMessage eap, RadiusSession<N, P> radiusSession, RadiusProcessor<?, N, P> processor, RadiusListenerWorker<N> req, N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int logRecordId) throws SSLException {
        EAPMessage result = this.session.checkPacket(eap, response);
        if (result != null) {
            return result;
        }
        ByteBuffer bb = eap.getData();
        byte dflags = eap.type == 2 ? (byte)0 : bb.get();
        byte flags = 0;
        try {
            byte[] data;
            if (eap.getData().limit() == 1 && this.session.action == EAPSession.Action.handshaking_waitnext) {
                return this.session.reject();
            }
            if ((dflags & 0xFFFFFF80) != 0) {
                bb.getInt();
            }
            if (bb.hasRemaining()) {
                byte[] b = new byte[bb.remaining()];
                bb.get(b, 0, b.length);
                this.input.write(b, 0, b.length);
                this.tunnel.updatePacketBuffer(b);
            } else if (this.eapFragmentedReply != null) {
                return this.nextFragment();
            }
            if ((dflags & 0x40) != 0) {
                this.session.action = EAPSession.Action.handshaking_waitnext;
                return this.putToResponse((byte)1, this.session.identifier, flags, null, 0, false);
            }
            if (this.session.action == EAPSession.Action.handshaking_waitnext) {
                this.session.action = EAPSession.Action.handshaking;
            }
            this.tunnel.putInputPacket(this.input.toByteArray());
            this.input = new ByteArrayOutputStream();
            try {
                block4 : switch (this.tunnel.handshake()) {
                    case none: 
                    case handshaking: {
                        data = this.tunnel.getPacketInputBuffer();
                        if (data != null && data.length > 0) {
                            try {
                                this.tunnel.putPacketBuffer(data);
                            }
                            catch (SSLException e) {
                                e.printStackTrace();
                                return this.session.reject();
                            }
                        }
                        break;
                    }
                    case established: {
                        switch (this.session.action) {
                            case handshaking: {
                                this.session.action = EAPSession.Action.messaging;
                            }
                            case messaging: {
                                data = this.tunnel.getPacketInputBuffer();
                                if (data != null && data.length > 0) {
                                    try {
                                        this.tunnel.putPacketBuffer(data);
                                    }
                                    catch (SSLException e) {
                                        if (e.getMessage().endsWith("access_denied")) {
                                            return this.session.rejectWithNotify(response, "\u041a\u043b\u0438\u0435\u043d\u0442 \u043e\u0442\u043a\u043b\u043e\u043d\u0438\u043b \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430!");
                                        }
                                        e.printStackTrace();
                                        return this.session.reject();
                                    }
                                }
                                switch (this.tunneledAuthentificating(eap, radiusSession, processor, req, nas, request, response, connectionSet, logRecordId)) {
                                    case 3: {
                                        return this.session.reject();
                                    }
                                    case 2: {
                                        return this.session.accept();
                                    }
                                    case -1: {
                                        return this.session.rejectWithNotify(response, "\u0414\u0430\u043d\u043d\u044b\u0439 \u043c\u0435\u0442\u043e\u0434 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043e\u0434\u043b\u0438\u043d\u043d\u043e\u0441\u0442\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c!");
                                    }
                                }
                                break block4;
                            }
                        }
                        return this.session.reject();
                    }
                    default: {
                        return this.session.reject();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return this.session.reject();
            }
            data = this.tunnel.getPacketOutputBuffer();
            if (data != null && data.length > 1024) {
                this.eapFragmentedReply = data;
                return this.nextFragment();
            }
            return this.putToResponse((byte)1, this.session.identifier, flags, data, data.length, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.session.reject();
        }
    }

    private EAPMessage nextFragment() {
        int left = this.eapFragmentedReply.length - this.eapFragmentedOffset;
        byte flags = 0;
        if (left > 1024) {
            left = 1024;
            flags = (byte)(flags | 0x40);
        }
        byte[] data = new byte[left];
        System.arraycopy(this.eapFragmentedReply, this.eapFragmentedOffset, data, 0, data.length);
        EAPMessage result = this.putToResponse((byte)1, this.session.identifier, flags, data, this.eapFragmentedReply.length, this.eapFragmentedOffset == 0);
        this.eapFragmentedOffset += data.length;
        if (this.eapFragmentedReply.length == this.eapFragmentedOffset) {
            this.eapFragmentedReply = null;
            this.eapFragmentedOffset = 0;
        }
        return result;
    }

    protected void putToResponse(RadiusPacket response, byte code, byte id, byte flags, byte[] data, int len, boolean lengthIncluded) {
        int length = 1;
        if (lengthIncluded) {
            if (data != null && data.length > 0) {
                length += data.length + 4;
                flags = (byte)(flags | 0xFFFFFF80);
            }
            byte[] result = new byte[length];
            result[0] = flags;
            if (data != null && data.length > 0) {
                result[1] = (byte)(len >> 24 & 0xFF);
                result[2] = (byte)(len >> 16 & 0xFF);
                result[3] = (byte)(len >> 8 & 0xFF);
                result[4] = (byte)(len & 0xFF);
                System.arraycopy(data, 0, result, 5, data.length);
            }
            response.setAttributes(-1, 79, new EAPMessage(code, id, this.getAuthentificatorType(), ByteBuffer.wrap(data)).toRadiusAttributes());
        } else {
            if (data != null && data.length > 0) {
                length += data.length;
            }
            byte[] result = new byte[length];
            result[0] = flags;
            if (data != null && data.length > 0) {
                System.arraycopy(data, 0, result, 1, data.length);
            }
            response.setAttributes(-1, 79, new EAPMessage(code, id, this.getAuthentificatorType(), ByteBuffer.wrap(data)).toRadiusAttributes());
        }
    }

    protected EAPMessage putToResponse(byte code, byte identifier, byte flags, byte[] data, int len, boolean lengthIncluded) {
        int length = 1;
        if (lengthIncluded) {
            if (data != null && data.length > 0) {
                length += data.length + 4;
                flags = (byte)(flags | 0xFFFFFF80);
            }
            byte[] result = new byte[length];
            result[0] = flags;
            if (data != null && data.length > 0) {
                result[1] = (byte)(len >> 24 & 0xFF);
                result[2] = (byte)(len >> 16 & 0xFF);
                result[3] = (byte)(len >> 8 & 0xFF);
                result[4] = (byte)(len & 0xFF);
                System.arraycopy(data, 0, result, 5, data.length);
            }
            return new EAPMessage(code, identifier, this.getAuthentificatorType(), ByteBuffer.wrap(result));
        }
        if (data != null && data.length > 0) {
            length += data.length;
        }
        byte[] result = new byte[length];
        result[0] = flags;
        if (data != null && data.length > 0) {
            System.arraycopy(data, 0, result, 1, data.length);
        }
        return new EAPMessage(code, identifier, this.getAuthentificatorType(), ByteBuffer.wrap(result));
    }

    protected byte tunneledAuthentificating(EAPMessage eap, RadiusSession<N, P> radiusSession, RadiusProcessor<?, N, P> processor, RadiusListenerWorker<N> req, N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int logRecordId) throws Exception {
        if (eap.getData().limit() == 1) {
            return 2;
        }
        return 3;
    }

    @Override
    public byte[][] getMppeKeys() {
        byte[] key = this.tunnel.getKeyMaterial();
        byte[] recv = new byte[32];
        byte[] send = new byte[32];
        System.arraycopy(key, 0, recv, 0, 32);
        System.arraycopy(key, 32, send, 0, 32);
        return new byte[][]{recv, send};
    }

    @Override
    public boolean checkPassword(RadiusAttributeSet request, RadiusAttributeSet response, String openPassw, byte[] secret, byte[] authenticator) {
        throw new UnsupportedOperationException();
    }

    class A
    extends ComboBoxUI {
        A() {
        }

        public void setPopupVisible(JComboBox c, boolean v) {
        }

        public boolean isPopupVisible(JComboBox c) {
            return false;
        }

        public boolean isFocusTraversable(JComboBox c) {
            return false;
        }
    }
}

