/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.service;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffLabelItem;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffLabelService;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffLabelManager;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.tariff.common.service.TariffLabelService")
public class TariffLabelServiceImpl
extends AbstractService
implements TariffLabelService {
    @Override
    public List<TariffLabelItem> getTariffLabelTreeItemList(int tariffPlanId) throws BGException {
        TariffLabelManager tariffLabelManager = new TariffLabelManager(this.getConnection());
        List<TariffLabelItem> tariffLabelItems = tariffLabelManager.getTariffLabelItemList();
        if (tariffPlanId > 0) {
            Set<Integer> tariffLabelSet = tariffLabelManager.getTariffLabelIds(tariffPlanId);
            for (TariffLabelItem tariffLabelItem : tariffLabelItems) {
                tariffLabelItem.setSelected(tariffLabelSet.contains(tariffLabelItem.getId()));
            }
        }
        return tariffLabelItems;
    }

    @Override
    public void setTariffLabelTreeItemList(int tariffPlanId, List<TariffLabelItem> items) throws BGException {
        HashSet<Integer> labelIds = new HashSet<Integer>();
        if (items != null) {
            for (TariffLabelItem tariffLabelItem : items) {
                labelIds.add(tariffLabelItem.getId());
            }
        }
        new TariffLabelManager(this.getConnection()).setTariffLabelIds(tariffPlanId, labelIds);
    }

    @Override
    public Set<Integer> getTariffLabelIds(int tariffPlanId) throws BGException {
        return new TariffLabelManager(this.getConnection()).getTariffLabelIds(tariffPlanId);
    }

    @Override
    public int updateTariffLabelTreeItem(TariffLabelItem tariffLabelItem) throws BGException {
        new TariffLabelManager(this.getConnection()).updateTariffLabelTreeItem(tariffLabelItem);
        return tariffLabelItem != null ? tariffLabelItem.getId() : -1;
    }

    @Override
    public void removeTariffLabelTreeItem(int tariffLabelItemId) throws BGException {
        new TariffLabelManager(this.getConnection()).removeTariffLabelItem(tariffLabelItemId);
    }
}

