/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.task.common.bean.LightweightTaskData;
import ru.bitel.bgbilling.kernel.task.common.bean.PeriodicTask;
import ru.bitel.bgbilling.kernel.task.common.bean.RunningTask;
import ru.bitel.bgbilling.kernel.task.common.bean.SchedulerTaskLog;
import ru.bitel.bgbilling.kernel.task.common.bean.TaskStatus;
import ru.bitel.bgbilling.kernel.task.server.SchedulerUtils;
import ru.bitel.bgbilling.kernel.task.server.TaskCache;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class SchedulerManager {
    private static final String TASK_TABLE_NAME = "scheduled_tasks";
    private static final String QUEUE_TABLE = "scheduled_task_run";
    private static final String PERIODIC_TASK_TABLE = "scheduled_periodic_run";
    private static final String TASK_LOG_TABLE = "scheduled_task_log";
    private Connection con;

    public SchedulerManager(Connection con) {
        this.con = con;
    }

    public List<LightweightTaskData> getTaskList(String moduleId) throws BGException {
        ArrayList<LightweightTaskData> result = new ArrayList<LightweightTaskData>();
        Object query = "SELECT st.*, sc.class, sc.title FROM scheduled_tasks AS st LEFT JOIN scheduled_class AS sc ON st.class_id=sc.id";
        if (Utils.notBlankString(moduleId) && !moduleId.equals("-2")) {
            query = (String)query + " WHERE st.module_id=?";
        }
        try (PreparedStatement ps = this.con.prepareStatement((String)query);){
            if (Utils.notBlankString(moduleId) && !moduleId.equals("-2")) {
                ps.setString(1, moduleId);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int id;
                int taskId = rs.getInt("st.id");
                String className = Utils.notBlankString(rs.getString("st.class")) ? rs.getString("st.class") : rs.getString("sc.class");
                String mid = rs.getString("st.module_id");
                int status = rs.getInt("st.status");
                String taskParams = rs.getString("st.params");
                boolean isPlugin = mid.startsWith("p");
                if (!SchedulerUtils.checkExistModule(isPlugin, id = Utils.parseInt(isPlugin ? mid.substring(1) : mid, -1), className, taskParams)) continue;
                LightweightTaskData td = new LightweightTaskData(rs.getInt("st.mm"), rs.getInt("st.dm"), rs.getInt("st.hh"), rs.getInt("st.dw"), rs.getLong("st.min"));
                td.setClassName(className);
                td.setTitle(TaskCache.getInstance().getTaskDescription(className));
                td.setPlugin(isPlugin);
                td.setModuleId(id);
                td.setPriority(rs.getInt("st.prior"));
                td.setTaskStatus(TaskStatus.getTaskStatus(status));
                td.setComment(rs.getString("st.comment"));
                td.setId(taskId);
                td.setParams(taskParams);
                td.setPeriod(new Period(TimeUtils.convertTimestampToDate(rs.getTimestamp("st.date1")), TimeUtils.convertTimestampToDate(rs.getTimestamp("st.date2"))));
                result.add(td);
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public void addTask(LightweightTaskData task) throws BGException {
        String query = "INSERT INTO scheduled_tasks (mm, dm, dw, hh, min, prior, date1, date2, status, class_id, class, module_id, comment, params) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try {
            int index = 1;
            PreparedStatement ps = this.con.prepareStatement(query, 1);
            ps.setLong(index++, task.getMonth());
            ps.setLong(index++, task.getDay());
            ps.setLong(index++, task.getDayOfWeek());
            ps.setLong(index++, task.getHour());
            ps.setLong(index++, task.getMin());
            ps.setInt(index++, task.getPriority());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(task.getPeriod().getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(task.getPeriod().getDateTo()));
            ps.setInt(index++, task.getTaskStatus().getStatus());
            ps.setInt(index++, -1);
            ps.setString(index++, task.getClassName());
            ps.setString(index++, (task.isPlugin() ? "p" : "") + String.valueOf(task.getModuleId()));
            ps.setString(index++, task.getComment());
            ps.setString(index++, task.getParams());
            ps.executeUpdate();
            task.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public void updateTask(LightweightTaskData task) throws BGException {
        String query = "UPDATE scheduled_tasks SET mm=?, dm=?, dw=?, hh=?, min=?, prior=?, date1=?, date2=?, status=?, class_id=?, class=?, module_id=?, comment=?, params=? WHERE id=?";
        try {
            int index = 1;
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setLong(index++, task.getMonth());
            ps.setLong(index++, task.getDay());
            ps.setLong(index++, task.getDayOfWeek());
            ps.setLong(index++, task.getHour());
            ps.setLong(index++, task.getMin());
            ps.setInt(index++, task.getPriority());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(task.getPeriod().getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(task.getPeriod().getDateTo()));
            ps.setInt(index++, task.getTaskStatus().getStatus());
            ps.setInt(index++, -1);
            ps.setString(index++, task.getClassName());
            ps.setString(index++, (task.isPlugin() ? "p" : "") + String.valueOf(task.getModuleId()));
            ps.setString(index++, task.getComment());
            ps.setString(index++, task.getParams());
            ps.setInt(index++, task.getId());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public void deleteTask(int taskId) throws BGException {
        String query = "DELETE FROM scheduled_tasks WHERE id=?";
        try {
            int index = 1;
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(index++, taskId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public List<RunningTask> getRunningTaskList() throws BGException {
        ArrayList<RunningTask> result = new ArrayList<RunningTask>();
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT id, description, executed, start_time FROM scheduled_task_run ORDER BY executed, id");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                RunningTask task = new RunningTask();
                task.setId(rs.getInt("id"));
                task.setDescription(rs.getString("description"));
                task.setExecuted(rs.getInt("executed") == 1);
                task.setStartTime(TimeUtils.convertTimestampToDate(rs.getTimestamp("start_time")));
                result.add(task);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public List<PeriodicTask> getPeriodicTaskLIst() throws BGException {
        ArrayList<PeriodicTask> result = new ArrayList<PeriodicTask>();
        try {
            String query = "SELECT * FROM scheduled_periodic_run WHERE amount>0";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PeriodicTask task = new PeriodicTask();
                task.setId(rs.getInt("id"));
                task.setDescription(rs.getString("description"));
                task.setAmount(rs.getInt("amount"));
                result.add(task);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public void deleteCurrentRunTask(int taskId) throws BGException {
        String query = "DELETE FROM scheduled_task_run WHERE id=?";
        try {
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, taskId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public void getTaskLog(int taskId, SearchResult<SchedulerTaskLog> searchResult) throws BGException {
        List<SchedulerTaskLog> result = searchResult.getList();
        Period period = searchResult.getPeriod();
        Page page = searchResult.getPage();
        Object query = "SELECT SQL_CALC_FOUND_ROWS tl.*,t.class FROM scheduled_task_log tl LEFT JOIN scheduled_tasks t on t.id=tl.task_id";
        Object whereClause = " WHERE TRUE";
        if (period != null && period.getDateFrom() != null) {
            whereClause = (String)whereClause + " AND start>=?";
        }
        if (period != null && period.getDateTo() != null) {
            whereClause = (String)whereClause + " AND finish<?";
        }
        if (taskId > 0) {
            whereClause = (String)whereClause + " AND task_id=" + taskId;
        }
        query = (String)query + (String)whereClause + (page != null ? page.sqlLimit() : "");
        try (PreparedStatement ps = this.con.prepareStatement((String)query, 1);){
            int index = 1;
            if (period != null && period.getDateFrom() != null) {
                ps.setLong(index++, period.getDateFrom().getTime());
            }
            if (period != null && period.getDateTo() != null) {
                ps.setLong(index++, TimeUtils.getNextDay(period.getDateTo()).getTime());
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    SchedulerTaskLog taskLogItem = new SchedulerTaskLog();
                    taskLogItem.setId(rs.getInt("tl.id"));
                    taskLogItem.setStartTime(rs.getLong("tl.start"));
                    taskLogItem.setFinishTime(rs.getLong("tl.finish"));
                    int id = rs.getInt("tl.task_id");
                    taskLogItem.setTaskId(id);
                    taskLogItem.setTaskTitle(id > 0 ? TaskCache.getInstance().getTaskDescription(rs.getString("t.class")) : rs.getString("task_title"));
                    result.add(taskLogItem);
                }
            }
            page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
        }
        catch (SQLException e) {
            throw new BGException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u0430", e);
        }
    }

    public void updateTaskLog(SchedulerTaskLog taskLog) throws BGException {
        String query = "INSERT INTO scheduled_task_log SET task_id=?, start=?, finish=?, task_title=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, taskLog.getTaskId());
            ps.setLong(index++, taskLog.getStartTime());
            ps.setLong(index++, taskLog.getFinishTime());
            ps.setString(index++, taskLog.getTaskTitle());
            ps.executeUpdate();
            taskLog.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        catch (SQLException e) {
            throw new BGException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0441\u0442\u0430\u0432\u043a\u0435 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u0440\u0430\u0431\u043e\u0442\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", e);
        }
    }

    public void deleteTaskLog() throws BGException {
        try (Statement statement = this.con.createStatement();){
            ArrayList<Integer> ids = new ArrayList<Integer>();
            ResultSet rs = statement.executeQuery("SELECT l.id FROM scheduled_task_log AS l LEFT JOIN scheduled_tasks AS t ON l.task_id=t.id WHERE l.task_id<>0 AND t.id IS NULL");
            while (rs.next()) {
                ids.add(rs.getInt(1));
            }
            rs.close();
            if (!ids.isEmpty()) {
                statement.execute("DELETE FROM scheduled_task_log WHERE id IN ( " + Utils.toString(ids) + " )");
            }
        }
        catch (SQLException e) {
            throw new BGException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0447\u0438\u0441\u0442\u043a\u0435 \u043b\u043e\u0433\u0430 \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u0437\u0430\u0434\u0430\u0447 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u0430", e);
        }
    }
}

