/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client.tree;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import ru.bitel.common.client.tree.BGTreeModel;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.TreeNode;

public class BGCheckTreeModel<N extends Id>
extends BGTreeModel<N> {
    private boolean dependChildren = false;
    private Set<Integer> checked = new HashSet<Integer>();

    public BGCheckTreeModel(String name) {
        super(name);
    }

    public BGCheckTreeModel(String name, Class<N> clazz) {
        super(name, clazz);
    }

    public BGCheckTreeModel(String name, Class<N> clazz, boolean dependChildren) {
        super(name, clazz);
        this.dependChildren = dependChildren;
    }

    public boolean isChecked(N n) {
        List children;
        if (this.checked.contains(((Id)n).getId())) {
            return true;
        }
        if (this.dependChildren && (children = this.getChildren(n)) != null) {
            for (Id child : this.getChildren(n)) {
                if (this.isChecked(child)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List<N> getSelectedItems() {
        ArrayList<Id> result = new ArrayList<Id>();
        for (TreePath treePath : this.tree.getSelectionPaths()) {
            result.add((Id)treePath.getLastPathComponent());
        }
        return result;
    }

    private boolean setChecked0(int id, boolean checked) {
        if (checked) {
            return this.checked.add(id);
        }
        return this.checked.remove(id);
    }

    private boolean setChecked0(List<N> list, boolean checked) {
        boolean changed = false;
        for (Id n : list) {
            if (this.setChecked0(n.getId(), checked)) {
                changed = true;
            }
            if (this.isLeaf(n)) continue;
            changed |= this.setChecked0(((TreeNode)((Object)n)).getChildren(), checked);
        }
        return changed;
    }

    public void setChecked(N n, boolean checked) {
        Object[] path;
        boolean changed = false;
        changed = this.dependChildren && !this.isLeaf(n) ? (changed |= this.setChecked0(((TreeNode)n).getChildren(), checked)) : this.setChecked0(((Id)n).getId(), checked);
        if (changed && (path = this.findPath((TreeNode)n, (TreeNode)((Object)((Id)this.root)))).length > 0) {
            this.fireTreeNodesChanged(this, path, null, null);
        }
    }

    public void setChecked(int id, boolean checked) {
        Object[] path = (Id[])this.findPath(id, (TreeNode)((Object)((Id)this.root)));
        if (path.length > 0) {
            boolean changed = this.setChecked0(id, checked);
            if (this.dependChildren && !this.isLeaf(path[path.length - 1])) {
                changed |= this.setChecked0(((TreeNode)path[path.length - 1]).getChildren(), checked);
            }
            if (changed) {
                this.fireTreeNodesChanged(this, path, null, null);
            }
        }
    }

    public void setChecked(Set<Integer> set) {
        this.checked.clear();
        this.checked.addAll(set);
        if (this.root != null) {
            this.fireTreeStructureChanged(this, new Object[]{this.root}, null, null);
        }
    }

    public void clearChecked() {
        if (this.checked != null && this.checked.size() > 0) {
            this.checked.clear();
            this.tree.repaint();
            this.tree.invalidate();
        }
    }

    public void setData(N root, Set<Integer> checked) {
        this.root = root;
        this.checked.clear();
        this.checked.addAll(checked);
        this.fireTreeStructureChanged(this, new Object[]{root}, null, null);
        this.tree.repaint();
        this.tree.invalidate();
    }

    public Set<Integer> getChecked() {
        return this.checked;
    }

    @Override
    public Icon getIcon(N value) {
        return super.getIcon(value);
    }
}

