/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.client.editor;

import bitel.billing.module.common.BGComboBoxWithSearch;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;
import ru.bitel.common.model.KeyValue;
import ru.bitel.common.model.Page;
import ru.bitel.oss.kernel.directories.address.common.bean.Area;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.Quarter;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;
import ru.bitel.oss.kernel.entity.client.editor.AttributeEditor;
import ru.bitel.oss.kernel.entity.client.table.EntityAttrEntry;
import ru.bitel.oss.kernel.entity.common.bean.AbstractEntity;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttrType;

public class AddressEditor
extends AttributeEditor<EntityAttrAddress> {
    AddressService addressService = ((ClientContext)this.getContext()).getPort(AddressService.class, 0);
    HouseAddForm houseAddForm;
    HouseForm houseForm;
    AddressForm addressForm;
    CustomForm customForm;
    DocumentListener documentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateTable(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateTable(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateTable(e);
        }

        private void updateTable(DocumentEvent e) {
            if (!AddressEditor.this.addressForm.isShowing()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        AddressEditor.this.addressForm.updateFormat(null);
                    }
                    catch (BGException e) {
                        ((ClientContext)AddressEditor.this.addressForm.getContext()).processException(e);
                    }
                }
            });
        }
    };

    public AddressEditor(AtomicReference<? extends AbstractEntity> currentRef, BGTableModel<EntityAttrEntry> model, ClientContext context) {
        super(EntitySpecAttrType.ADDRESS.getCode(), currentRef, model, new CardLayout(), context);
    }

    @Override
    protected void jbInit() throws Exception {
        BGEditor editor = new BGEditor("address");
        this.houseAddForm = new HouseAddForm();
        this.houseForm = new HouseForm();
        this.addressForm = new AddressForm();
        this.customForm = new CustomForm();
        editor.addForm(this.addressForm, "address");
        editor.addForm(this.houseForm, "house");
        editor.addForm(this.houseAddForm, "houseAdd");
        editor.addForm(this.customForm, "custom");
        this.add((Component)editor, "main");
        this.setBorder(new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
    }

    @Override
    protected void edit() throws BGException {
        if (this.attr != null && ((EntityAttrAddress)this.attr).getHouseId() <= 0) {
            this.customForm.address.setText(((EntityAttrAddress)this.attr).getTitle());
            this.customForm.comment.setText(((EntityAttrAddress)this.attr).getComment());
            this.customForm.performActionOpen();
            return;
        }
        this.addressForm.edit();
    }

    @Override
    protected boolean ok() {
        if (this.houseAddForm.isShowing()) {
            this.houseAddForm.houseSave.perform();
            return false;
        }
        if (this.customForm.isShowing()) {
            this.attr = new EntityAttrAddress(-1, this.specAttr.getId(), 0, 0, 0, "", "", this.customForm.comment.getText(), null, this.customForm.address.getText());
            return true;
        }
        if (this.addressForm.house == null) {
            this.attr = null;
            return true;
        }
        KeyValue<String, String> format = this.addressForm.formatModel.getSelectedRow();
        this.attr = new EntityAttrAddress(-1, this.specAttr.getId(), this.addressForm.house.getId(), (int)this.addressForm.podField.getValue(), (int)this.addressForm.floorField.getValue(), this.addressForm.flatField.getText(), this.addressForm.roomField.getText(), this.addressForm.commentField.getText(), (String)format.getKey(), format.getValue());
        return true;
    }

    class HouseAddForm
    extends BGUPanel {
        private BGUComboBox<City> cityCombo;
        private BGUComboBox<Area> areaCombo;
        private BGUComboBox<Street> streetCombo;
        private BGUComboBox<Quarter> quarterCombo;
        private BGTextField houseAndFracField;
        private IntTextField amountField;
        private BGTextField postIndexField;
        private JTextArea commentField;
        AbstractBGUPanel.DefaultAction houseAdd;
        AbstractBGUPanel.DefaultAction houseSave;
        AbstractBGUPanel.DefaultAction houseBack;

        public HouseAddForm() {
            super(new BorderLayout());
            this.houseAdd = new AbstractBGUPanel.DefaultAction("ok.house.add", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u0434\u043e\u043c..."){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    HouseAddForm.this.cityCombo.setData(AddressEditor.this.addressService.cityList(0, null));
                    HouseAddForm.this.performActionOpen();
                }
            };
            this.houseSave = new AbstractBGUPanel.DefaultAction("ok.house.save", "\u041e\u043a"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    House house = new House();
                    house.setCityId(((City)HouseAddForm.this.cityCombo.getSelectedItem()).getId());
                    house.setAreaId(((Area)HouseAddForm.this.areaCombo.getSelectedItem()).getId());
                    house.setStreetId(((Street)HouseAddForm.this.streetCombo.getSelectedItem()).getId());
                    house.setQuarterId(((Quarter)HouseAddForm.this.quarterCombo.getSelectedItem()).getId());
                    house.setHouseAndFrac(HouseAddForm.this.houseAndFracField.getText());
                    house.setAmount((int)HouseAddForm.this.amountField.getValue());
                    house.setPostIndex(HouseAddForm.this.postIndexField.getText());
                    house.setComment(HouseAddForm.this.commentField.getText());
                    AddressEditor.this.addressService.houseUpdate(house);
                    AddressEditor.this.addressForm.setHouse(house);
                    try {
                        AddressEditor.this.addressForm.updateFormat(null);
                    }
                    catch (BGException ex) {
                        ((ClientContext)HouseAddForm.this.getContext()).processException(ex);
                    }
                    AddressEditor.this.addressForm.performActionOpen();
                }
            };
            this.houseBack = new AbstractBGUPanel.DefaultAction("ok.house.back", "\u0412\u0435\u0440\u043d\u0443\u0442\u044c\u0441\u044f \u0434\u043b\u044f \u0432\u044b\u0431\u043e\u0440\u0430 \u0434\u043e\u043c\u0430"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    AddressEditor.this.houseForm.performActionOpen();
                }
            };
            this.setName("houseAdd");
        }

        @Override
        protected void jbInit() throws Exception {
            this.cityCombo = new BGUComboBox();
            this.areaCombo = new BGUComboBox();
            this.streetCombo = new BGUComboBox();
            this.quarterCombo = new BGUComboBox();
            this.houseAndFracField = new BGTextField(16);
            this.amountField = new IntTextField(16);
            this.postIndexField = new BGTextField(16);
            this.commentField = new JTextArea();
            JTabbedPane tabbedPane = new JTabbedPane();
            JPanel mainPanel = new JPanel(new GridBagLayout());
            mainPanel.add((Component)BGSwingUtilites.wrapBorder(this.cityCombo, "\u0413\u043e\u0440\u043e\u0434"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            mainPanel.add((Component)BGSwingUtilites.wrapBorder(this.areaCombo, "\u0420\u0430\u0439\u043e\u043d"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            mainPanel.add((Component)BGSwingUtilites.wrapBorder(this.streetCombo, "\u0423\u043b\u0438\u0446\u0430"), new GridBagConstraints(2, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            mainPanel.add((Component)BGSwingUtilites.wrapBorder(this.quarterCombo, "\u041a\u0432\u0430\u0440\u0442\u0430\u043b"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            mainPanel.add((Component)BGSwingUtilites.wrapBorder(this.houseAndFracField, "\u0414\u043e\u043c/\u0414\u0440\u043e\u0431\u044c"), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            mainPanel.add((Component)BGSwingUtilites.wrapBorder(this.amountField, "\u041a\u0432\u0430\u0440\u0442\u0438\u0440"), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            mainPanel.add((Component)BGSwingUtilites.wrapBorder(this.postIndexField, "\u0418\u043d\u0434\u0435\u043a\u0441"), new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            tabbedPane.addTab("\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435", mainPanel);
            tabbedPane.addTab("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", BGSwingUtilites.wrapEmptyBorder(new JScrollPane(this.commentField)));
            this.add((Component)BGSwingUtilites.wrapEmptyBorder(new BGButton(this.houseBack)), "North");
            this.add((Component)tabbedPane, "Center");
            this.cityCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        City selected = (City)HouseAddForm.this.cityCombo.getSelectedItem();
                        int cityId = selected.getId();
                        List areaData = AddressEditor.this.addressService.areaList(cityId, null);
                        areaData.add(0, new Area(cityId, -1, "---"));
                        HouseAddForm.this.areaCombo.setData(areaData);
                        List streetData = AddressEditor.this.addressService.streetList(cityId, null);
                        streetData.add(0, new Street(cityId, -1, "---"));
                        HouseAddForm.this.streetCombo.setData(streetData);
                        List quarterData = AddressEditor.this.addressService.quarterList(cityId, null);
                        quarterData.add(0, new Quarter(cityId, -1, "---"));
                        HouseAddForm.this.quarterCombo.setData(quarterData);
                    }
                    catch (BGException ex) {
                        ((ClientContext)HouseAddForm.this.getContext()).processException(ex);
                    }
                }
            });
        }
    }

    class HouseForm
    extends BGUPanel {
        private BGComboBoxWithSearch streetCombo;
        private BGTextField houseAndFracField;
        private BGTableModel<House> houseModel;
        AbstractBGUPanel.DefaultAction ok;
        AbstractBGUPanel.DefaultAction houseSelect;
        AbstractBGUPanel.AsyncAction<List<House>> houseFind;
        AbstractBGUPanel.DefaultAction houseBack;
        AbstractBGUPanel.DefaultAction houseCustom;

        public HouseForm() {
            super(new BorderLayout());
            this.houseModel = new BGTableModel<House>("houseModel"){

                @Override
                protected void initColumns() {
                    this.addColumnId();
                    this.addColumn("\u0414\u043e\u043c", -1, -1, -1, null, true);
                }

                @Override
                public Object getValue(House val, int column) throws BGException {
                    switch (column) {
                        case 1: {
                            return val.getStreetTitle() + ", " + val.getHouseFrac();
                        }
                    }
                    return super.getValue(val, column);
                }
            };
            this.ok = new AbstractBGUPanel.DefaultAction("edit", ""){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    House house = HouseForm.this.houseModel.getSelectedRow();
                    AddressEditor.this.addressForm.setHouse(house);
                    try {
                        AddressEditor.this.addressForm.updateFormat(null);
                    }
                    catch (BGException ex) {
                        ((ClientContext)HouseForm.this.getContext()).processException(ex);
                    }
                    AddressEditor.this.addressForm.performActionOpen();
                }
            };
            this.houseSelect = new AbstractBGUPanel.DefaultAction("house.select", ""){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    HouseForm.this.performActionOpen();
                }
            };
            this.houseFind = new AbstractBGUPanel.AsyncAction<List<House>>("ok.house.find", "\u041d\u0430\u0439\u0442\u0438"){

                @Override
                protected List<House> doInBackground() throws Exception {
                    int streetId = Utils.parseInt(HouseForm.this.streetCombo.getSelectedId());
                    Object[] houseAndFrac = House.getHouseAndFrac((String)HouseForm.this.houseAndFracField.getText());
                    return AddressEditor.this.addressService.houseList(0, 0, streetId, 0, ((Integer)houseAndFrac[0]).intValue(), (String)houseAndFrac[1], null);
                }

                @Override
                protected void done(List<House> result) throws Exception {
                    HouseForm.this.houseModel.setData(result);
                }
            };
            this.houseBack = new AbstractBGUPanel.DefaultAction("close.house.find", "\u0412\u0435\u0440\u043d\u0443\u0442\u044c\u0441\u044f \u043a \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c \u0430\u0434\u0440\u0435\u0441\u0430"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    AddressEditor.this.addressForm.performActionOpen();
                }
            };
            this.houseCustom = new AbstractBGUPanel.DefaultAction("ok.house.custom", "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0430\u0434\u0440\u0435\u0441\u0430"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    AddressEditor.this.customForm.performActionOpen();
                }
            };
            this.setName("house");
        }

        @Override
        protected void jbInit() throws Exception {
            this.streetCombo = new BGComboBoxWithSearch(2);
            this.streetCombo.setEditable(true);
            this.houseAndFracField = new BGTextField();
            JPanel leftPanel = new JPanel(new GridBagLayout());
            leftPanel.add((Component)new JLabel("\u0423\u043b\u0438\u0446\u0430:"), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 0, 3), 0, 0));
            leftPanel.add((Component)this.streetCombo, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 5, 3), 0, 0));
            leftPanel.add((Component)new JLabel("\u0414\u043e\u043c [\u0434\u0440\u043e\u0431\u044c]:"), new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 0, 3), 0, 0));
            leftPanel.add((Component)this.houseAndFracField, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 5, 3), 0, 0));
            leftPanel.add((Component)new BGButton(this.houseFind), new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 5, 3), 0, 0));
            leftPanel.add((Component)new BGButton(this.houseBack), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 5, 3), 0, 0));
            leftPanel.add((Component)new BGButton(AddressEditor.this.houseAddForm.houseAdd), new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 5, 3), 0, 0));
            leftPanel.add((Component)new BGButton(this.houseCustom), new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 5, 3), 0, 0));
            leftPanel.setBorder(new BGTitleBorder("\u0424\u0438\u043b\u044c\u0442\u0440"));
            this.add((Component)leftPanel, "West");
            JPanel rightPanel = new JPanel(new GridBagLayout());
            BGUTable houseTable = new BGUTable(this.houseModel);
            rightPanel.add((Component)new JLabel("\u041d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438:"), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 0, 3), 0, 0));
            rightPanel.add((Component)new JScrollPane(houseTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 3, 3, 3), 0, 0));
            this.add((Component)rightPanel, "Center");
            BGSwingUtilites.handleEdit(houseTable, this);
            this.streetCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object selected;
                    if (((long)e.getModifiers() & 0x10L) > 0L) {
                        HouseForm.this.streetEntered();
                    }
                    if ((selected = HouseForm.this.streetCombo.getSelectedItem()) != null && selected instanceof ComboBoxItem && Utils.parseInt(HouseForm.this.streetCombo.getSelectedId()) > 0) {
                        HouseForm.this.houseFind.perform();
                    }
                }
            });
            this.streetCombo.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("fillText")) {
                        HouseForm.this.fillStreetList(String.valueOf(evt.getNewValue()));
                    } else if (evt.getPropertyName().equals("textEntered")) {
                        HouseForm.this.streetEntered();
                    }
                }
            });
            this.houseAndFracField.addActionListener(this.houseFind);
        }

        private void fillStreetList(String streetTitle) {
            try {
                String searchStreet;
                String searchCity;
                int idx = streetTitle.indexOf(40);
                if (idx >= 0) {
                    searchCity = streetTitle.substring(idx + 1);
                    searchStreet = streetTitle.substring(0, idx);
                } else {
                    searchStreet = streetTitle;
                    searchCity = null;
                }
                List streetList = AddressEditor.this.addressService.streetSearch(0, searchStreet.replaceAll("\\(", " "), searchCity, new Page(1, 20));
                this.streetCombo.initPopup(streetTitle);
                for (Street street : streetList) {
                    this.streetCombo.addItem(new ComboBoxItem(street.getId(), street.getTitle() + " (" + street.getCityTitle() + ")"));
                }
            }
            catch (BGException ex) {
                ((ClientContext)this.getContext()).processException(ex);
            }
        }

        private void streetEntered() {
        }
    }

    class AddressForm
    extends BGUPanel {
        private House house;
        private BGButton houseButton;
        private BGTextField flatField;
        private BGTextField roomField;
        private IntTextField podField;
        private IntTextField floorField;
        private JTextArea commentField;
        private BGTableModel<KeyValue<String, String>> formatModel;
        private BGUTable formatTable;
        AbstractBGUPanel.DefaultAction addressClear;

        public AddressForm() {
            super(new BorderLayout());
            this.formatModel = new BGTableModel<KeyValue<String, String>>("formatModel"){

                @Override
                protected void initColumns() {
                    this.addColumn("", Column.Radio.class, -1, 25, 50, null, true);
                    this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, 150, -1, "title", true);
                    this.addColumn("\u0410\u0434\u0440\u0435\u0441", -1, 300, -1, "address", false);
                }

                @Override
                public Object getValue(KeyValue<String, String> val, int column) throws BGException {
                    switch (column) {
                        case 0: {
                            return this.getSelectedRow() == val;
                        }
                        case 1: {
                            return val.getKey();
                        }
                        case 2: {
                            return val.getValue();
                        }
                    }
                    return super.getValue(val, column);
                }
            };
            this.addressClear = new AbstractBGUPanel.DefaultAction("ok.address.clear", "X"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    AddressForm.this.setHouse(null);
                    AddressForm.this.flatField.setText("");
                    AddressForm.this.roomField.setText("");
                    AddressForm.this.podField.setText("");
                    AddressForm.this.floorField.setText("");
                    AddressForm.this.commentField.setText("");
                    AddressForm.this.updateFormat(null);
                }
            };
            this.setName("address");
        }

        public void edit() throws BGException {
            if (AddressEditor.this.attr != null) {
                int houseId = ((EntityAttrAddress)AddressEditor.this.attr).getHouseId();
                this.setHouse(AddressEditor.this.addressService.houseGet(houseId));
                this.flatField.setText(((EntityAttrAddress)AddressEditor.this.attr).getFlat());
                this.roomField.setText(((EntityAttrAddress)AddressEditor.this.attr).getRoom());
                if (((EntityAttrAddress)AddressEditor.this.attr).getPod() != 0) {
                    this.podField.setValue(((EntityAttrAddress)AddressEditor.this.attr).getPod());
                } else {
                    this.podField.setText("");
                }
                if (((EntityAttrAddress)AddressEditor.this.attr).getFloor() != 0) {
                    this.floorField.setValue(((EntityAttrAddress)AddressEditor.this.attr).getFloor());
                } else {
                    this.floorField.setText("");
                }
                this.commentField.setText(((EntityAttrAddress)AddressEditor.this.attr).getComment());
                this.updateFormat(((EntityAttrAddress)AddressEditor.this.attr).getFormatKey());
                this.performActionOpen();
            } else {
                this.setHouse(null);
                this.flatField.setText("");
                this.roomField.setText("");
                this.podField.setText("");
                this.floorField.setText("");
                this.commentField.setText("");
                this.updateFormat(null);
                AddressEditor.this.houseForm.performActionOpen();
            }
        }

        @Override
        protected void jbInit() throws Exception {
            this.formatTable = new BGUTable(this.formatModel);
            this.flatField = new BGTextField(10);
            this.flatField.setHorizontalAlignment(0);
            this.flatField.getDocument().addDocumentListener(AddressEditor.this.documentListener);
            this.roomField = new BGTextField(10);
            this.roomField.setHorizontalAlignment(0);
            this.roomField.getDocument().addDocumentListener(AddressEditor.this.documentListener);
            this.podField = new IntTextField(10);
            this.podField.getDocument().addDocumentListener(AddressEditor.this.documentListener);
            this.floorField = new IntTextField(10);
            this.floorField.getDocument().addDocumentListener(AddressEditor.this.documentListener);
            this.houseButton = new BGButton(AddressEditor.this.houseForm.houseSelect);
            this.commentField = new JTextArea();
            JPanel topPanel = new JPanel(new GridBagLayout());
            topPanel.add((Component)new JLabel("\u0414\u043e\u043c:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 5, 3), 0, 0));
            topPanel.add((Component)this.houseButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            topPanel.add((Component)new BGButton(this.addressClear), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 3), 0, 0));
            this.add((Component)topPanel, "North");
            JPanel leftPanel = new JPanel(new GridBagLayout());
            leftPanel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 5, 3), 0, 0));
            leftPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043d\u0430\u0442\u0430:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 5, 3), 0, 0));
            leftPanel.add((Component)new JLabel("\u041f\u043e\u0434\u044a\u0435\u0437\u0434:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 5, 3), 0, 0));
            leftPanel.add((Component)new JLabel("\u042d\u0442\u0430\u0436:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
            leftPanel.add((Component)this.flatField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 3), 0, 0));
            leftPanel.add((Component)this.roomField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 3), 0, 0));
            leftPanel.add((Component)this.podField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 3), 0, 0));
            leftPanel.add((Component)this.floorField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
            leftPanel.setBorder(new BGTitleBorder("\u041a\u0432\u0430\u0440\u0442\u0438\u0440\u0430"));
            this.add((Component)leftPanel, "West");
            JTabbedPane rightPanel = new JTabbedPane();
            rightPanel.addTab("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", BGSwingUtilites.wrapEmptyBorder(new JScrollPane(this.commentField)));
            rightPanel.addTab("\u0424\u043e\u0440\u043c\u0430\u0442", BGSwingUtilites.wrapEmptyBorder(new JScrollPane(this.formatTable)));
            this.add((Component)BGSwingUtilites.wrapEmptyBorder(rightPanel), "Center");
        }

        void updateFormat(String formatKey) throws BGException {
            KeyValue<String, String> format;
            if (Utils.isBlankString(formatKey) && (format = this.formatModel.getSelectedRow()) != null) {
                formatKey = (String)format.getKey();
            }
            if (this.house != null) {
                this.formatModel.setData(AddressEditor.this.addressService.addressFormat(this.house.getId(), (int)this.podField.getValue(), (int)this.floorField.getValue(), this.flatField.getText(), this.roomField.getText(), this.commentField.getText()));
            } else {
                this.formatModel.setData(AddressEditor.this.addressService.addressFormat(0, (int)this.podField.getValue(), (int)this.floorField.getValue(), this.flatField.getText(), this.roomField.getText(), this.commentField.getText()));
            }
            if (Utils.notBlankString(formatKey)) {
                this.formatModel.setSelectedRow(new KeyValue<String, String>(formatKey, ""));
            }
            if (this.formatModel.getSelectedRow() == null) {
                this.formatTable.getSelectionModel().setSelectionInterval(0, 0);
            }
        }

        public void setHouse(House house) {
            this.house = house;
            if (house != null) {
                this.houseButton.setText(house.getCityTitle() + ", " + house.getStreetTitle() + ", " + house.getHouseFrac());
            } else {
                this.houseButton.setText("");
            }
        }
    }

    class CustomForm
    extends BGUPanel {
        private BGTextField address;
        private JTextArea comment;
        AbstractBGUPanel.DefaultAction directoryAddress;

        public CustomForm() {
            super(new GridBagLayout());
            this.directoryAddress = new AbstractBGUPanel.DefaultAction("ok.directoryAddress", "\u0410\u0434\u0440\u0435\u0441 \u0438\u0437 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    AddressEditor.this.addressForm.performActionOpen();
                }
            };
            this.setName("custom");
        }

        @Override
        protected void jbInit() throws Exception {
            this.address = new BGTextField();
            this.comment = new JTextArea(5, 0);
            this.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 0, 0), 0, 0));
            this.add((Component)this.address, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 5, 5), 0, 0));
            this.add((Component)new BGButton(this.directoryAddress), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 3), 0, 0));
            this.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 0, 3), 0, 0));
            this.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        }
    }
}

