package ru.bitel.bgbilling.kernel.dyn.web;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebContractSearchModuleBase;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebContractSearchResult;
import ru.bitel.common.Utils;

public class WebSearchContractByContractParameter
    extends WebContractSearchModuleBase
{
    public WebSearchContractByContractParameter()
    {
        contractSearchParams = Arrays.asList( title, useForAccessRestore, useForPayment, searchTextPlaceHolder, searchTextComment, searchByContractParamId,
                                              verifyByCustomerEmail, verifyByContractParameterEmailId, verifyByCustomerPhone, verifyByContractParameterPhoneId );
    }

    @Override
    public List<WebContractSearchResult> doSearch( String searchText )
        throws BGException
    {
        List<WebContractSearchResult> list = super.doSearch( searchText );

        if ( !searchText.matches( "^\\d{3,}$" ) )
        {
            return list;
        }
        
        // параметр с ЛС
        int paramId = Utils.parseInt( searchByContractParamId.getValue(), 0 ); 
        if ( paramId > 0 )
        {
            String query =  "SELECT c.id, title FROM `contract` AS c " +
                            "INNER JOIN `contract_parameter_type_1` AS cp ON cp.cid=c.id AND pid=? AND val=?";
            try ( PreparedStatement psSelect = connection.prepareStatement( query ) )
            {
                psSelect.setInt( 1, paramId );
                psSelect.setString( 2, searchText );
                try ( ResultSet resultSet = psSelect.executeQuery() )
                {
                    while ( resultSet.next() )
                    {
                        WebContractSearchResult result = new WebContractSearchResult();
                        result.setContractId( resultSet.getInt( "id" ) );
                        result.setContractTitle( resultSet.getString( "title" ) );
                        list.add( result );
                    }
                }
            }
            catch( Exception ex )
            {
                throw new BGException( ex );
            }
        }
        
        // подстановка проверочных параметров
        if ( !list.isEmpty() )
        {
            if ( "true".equals( verifyByCustomerPhone.getValue() ) )
            {
                verifyByCustomerPhone( list );
            }
            int paramPhoneId = Utils.parseInt( verifyByContractParameterPhoneId.getValue(), 0 );
            if ( paramPhoneId > 0 )
            {
                verifyByContractParameterPhone( list, paramPhoneId );
            }
        }
        
        return list;
    }
    
    @Override
    public String getTitleText()
    {
        return "по номеру лицевого счета";
    }
    
    @Override
    protected String getSearchTextPlaceHolderText()
    {
        return "XXXXXXXXXX";
    }

    @Override
    protected String getSearchTextCommentText()
    {
        return "Введите номер лицевого счета указанного при регистрации договора, в формате XXXXXXXXXX";
    }    
}
