/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.servlet;

import java.io.File;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.wrapper.MultipartWrapper;

@WebFilter(filterName="mobileSetCharacterEncoding", urlPatterns={"/mobapi/*"}, initParams={@WebInitParam(name="encoding", value="UTF-8")})
public class SetCharacterEncodingFilter
extends ru.bitel.bgbilling.kernel.base.server.filters.SetCharacterEncodingFilter {
    private ServletContext servletContext = null;
    protected static final Logger logger = LogManager.getLogger();

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.servletContext = filterConfig.getServletContext();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String encoding = this.selectEncoding(servletRequest);
        servletRequest.setCharacterEncoding(encoding != null ? encoding : "UTF-8");
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String type = request.getHeader("Content-Type");
        if (type != null && type.startsWith("multipart/form-data")) {
            File tempdir = (File)this.servletContext.getAttribute("javax.servlet.context.tempdir");
            servletRequest = new MultipartWrapper(request, tempdir.getAbsolutePath());
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
        this.servletContext = null;
    }
}

