/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.GenericOSMPTransactionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class SBTransactionManager
extends GenericOSMPTransactionManager {
    private static final BigDecimal divisor = new BigDecimal(100);

    public SBTransactionManager() {
        super(null, null, null, null, null, null);
    }

    @Override
    protected Pattern getFilePattern() {
        return Pattern.compile("^(\\d+);(.+);(\\d+);([\\d+:;]+);(\\d+);(\\d+);(\\d+)$", 8);
    }

    @Override
    protected String getFileTimePattern() {
        return "ddMMyyyy';'HH:mm:ss";
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        Matcher match = this.getFilePattern().matcher(file);
        while (match.find()) {
            char type;
            Transaction transaction = new Transaction();
            transaction.setTransId(Utils.parseLong((String)match.group(3), (long)0L));
            transaction.setTime(TimeUtils.parseDate((String)match.group(4), (String)this.getFileTimePattern()));
            String number = match.group(2);
            if (system.osmpPrefix && number != null && number.length() > 1 && number.charAt(1) == '_' && Character.isDigit((int)(type = number.charAt(0)))) {
                transaction.setType(Character.getNumericValue((int)type));
                transaction.setNumber(number.substring(2));
            } else {
                transaction.setNumber(number);
            }
            transaction.setRawNumber(number);
            transaction.setSum(Utils.parseBigDecimal((String)match.group(5), (BigDecimal)BigDecimal.ZERO).divide(divisor, RoundingMode.HALF_EVEN));
            transaction.setStatus(TransactionStatus.PAYMENT_PAYED.getCode());
            result.add(transaction);
        }
        return result;
    }
}

