/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.payonline.server.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.modules.payonline.common.bean.Rebill;
import ru.bitel.bgbilling.modules.payonline.common.bean.Transaction;
import ru.bitel.bgbilling.modules.payonline.server.PayOnlineUtils;
import ru.bitel.bgbilling.modules.payonline.server.bean.RebillManager;
import ru.bitel.bgbilling.modules.payonline.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

@WebServlet(name="PayOnlineExecutor", urlPatterns={"/payonline/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final Pattern slashPattern = Pattern.compile("/");
    private static final char POST_DELIM = '&';
    private Preferences moduleSetup;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block32: {
            PayOnlineUtils payOnlineUtils;
            StringBuilder html;
            PrintWriter out;
            Connection con;
            block31: {
                int mid = 0;
                boolean errors = false;
                this.setup = Setup.getSetup();
                con = Setup.getSetup().getDBConnectionFromPool();
                String redirectUrl = null;
                out = null;
                html = new StringBuilder(100);
                payOnlineUtils = null;
                html.append("<html>");
                try {
                    con.setAutoCommit(false);
                    String pathInfo = request.getPathInfo();
                    if (pathInfo != null) {
                        String[] params = slashPattern.split(pathInfo);
                        switch (params.length) {
                            default: {
                                mid = Utils.parseInt((String)params[1], (int)0);
                                break;
                            }
                            case 0: 
                            case 1: {
                                mid = 0;
                            }
                        }
                    }
                    if (mid <= 0) {
                        throw new BGMessageException("Invalid URL: mid missing!");
                    }
                    payOnlineUtils = new PayOnlineUtils(con, mid);
                    this.moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(mid));
                    logger.info("\u0420\u0430\u0437\u0431\u043e\u0440 \u043e\u0442\u0432\u0435\u0442\u0430 \u043e\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 PayOnline");
                    Date dateTime = null;
                    BigDecimal summa = BigDecimal.ZERO;
                    int contractId = -1;
                    String rebillAnchor = null;
                    String cardNumber = null;
                    Boolean isStoreData = false;
                    int orderType = -1;
                    response.setContentType("text/html");
                    response.setCharacterEncoding("Cp1251");
                    response.setStatus(200);
                    out = response.getWriter();
                    redirectUrl = this.moduleSetup.get("redirect.url", null);
                    String dateTimeParam = request.getParameter("DateTime");
                    String transactionId = request.getParameter("TransactionID");
                    String orderIdParam = request.getParameter("OrderId");
                    String summaParam = request.getParameter("Amount");
                    String currencyParam = request.getParameter("Currency");
                    String hash = request.getParameter("SecurityKey");
                    rebillAnchor = request.getParameter("RebillAnchor");
                    cardNumber = Utils.notBlankString((String)request.getParameter("CardNumber")) ? request.getParameter("CardNumber").substring(12) : "";
                    isStoreData = Utils.parseBoolean((String)request.getParameter("store_data"), (boolean)true);
                    logger.info("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b Request -  " + request.getQueryString());
                    String privateKey = this.moduleSetup.get("private.security.key", "");
                    StringBuilder sb = new StringBuilder(150);
                    sb.append("DateTime=");
                    sb.append(dateTimeParam);
                    sb.append('&');
                    sb.append("TransactionID=");
                    sb.append(transactionId);
                    sb.append('&');
                    sb.append("OrderId=");
                    sb.append(orderIdParam);
                    sb.append('&');
                    sb.append("Amount=");
                    sb.append(summaParam);
                    sb.append('&');
                    sb.append("Currency=");
                    sb.append(currencyParam);
                    sb.append('&');
                    sb.append("PrivateSecurityKey=");
                    sb.append(privateKey);
                    MessageDigest md = MessageDigest.getInstance("md5");
                    byte[] digest = md.digest(sb.toString().getBytes());
                    if (hash == null || !hash.equals(Utils.bytesToHexString((byte[])digest).toLowerCase())) {
                        throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0435 \u043d\u0435 \u0432\u0435\u0440\u043d\u044b! \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0445\u044d\u0448\u0430!");
                    }
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    format.setTimeZone(TimeZone.getTimeZone("UTC"));
                    dateTime = format.parse(dateTimeParam);
                    summa = Utils.parseBigDecimal((String)summaParam, (BigDecimal)BigDecimal.ZERO);
                    String[] orderparamsMas = orderIdParam.split("_");
                    contractId = Utils.parseInt((String)orderparamsMas[0], (int)-1);
                    orderType = Utils.parseInt((String)orderparamsMas[orderparamsMas.length - 1], (int)-1);
                    if (dateTime == null || transactionId == null || summa.compareTo(BigDecimal.ZERO) <= 0 || contractId <= 0) {
                        throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0435 \u043d\u0435 \u0432\u0435\u0440\u043d\u044b!");
                    }
                    if (!errors) {
                        logger.info("\u0420\u0430\u0437\u0431\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043f\u0440\u043e\u0448\u0435\u043b \u0443\u0441\u043f\u0435\u0448\u043d\u043e. \u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c \u043f\u043b\u0430\u0442\u0435\u0436 \u0432 \u0411\u0414.");
                        Transaction pot = new Transaction();
                        pot.setTransactionId(transactionId);
                        pot.setTransactionDate(dateTime);
                        pot.setSum(summa);
                        pot.setContractId(contractId);
                        try (TransactionManager transactionManager = new TransactionManager(con, mid);){
                            transactionManager.update(pot);
                            if (isStoreData.booleanValue() && this.moduleSetup.getBoolean("payonline.store.data", false) && Utils.notBlankString((String)cardNumber)) {
                                transactionManager.addUserData(contractId, cardNumber, rebillAnchor);
                            }
                        }
                        if (this.moduleSetup.getBoolean("rebill", false) && Utils.notBlankString((String)rebillAnchor)) {
                            RebillManager rebillManager = new RebillManager(con, mid);
                            Rebill payOnlineRebill = rebillManager.getTransactionByCid(contractId);
                            if (payOnlineRebill != null && payOnlineRebill.getRebillAnchor() != null) {
                                logger.info("\u042d\u0442\u043e \u0431\u044b\u043b\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0430. \u0417\u0430\u043d\u043e\u0441\u0438\u043c \u0432 \u0411\u0414 RebillAnchor");
                                payOnlineRebill.setRebillAnchor(rebillAnchor);
                                rebillManager.update(payOnlineRebill);
                            }
                            rebillManager.close();
                        }
                        payOnlineUtils.pay(pot, orderType);
                    }
                    html.append("<h2>\u041f\u043b\u0430\u0442\u0435\u0436 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d!</h2>");
                    if (redirectUrl == null) break block31;
                    html.append("<br/><br/><a href='");
                }
                catch (BGException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    try {
                        con.rollback();
                    }
                    catch (SQLException e1) {
                        logger.error(e1.getMessage(), (Throwable)e1);
                    }
                    errors = true;
                    html.append("<h2>");
                    html.append(e.getMessage());
                    html.append("</h2>");
                    response.setStatus(404);
                    break block32;
                }
                catch (Exception e2) {
                    logger.error(e2.getMessage(), (Throwable)e2);
                    try {
                        con.rollback();
                    }
                    catch (SQLException e1) {
                        logger.error(e1.getMessage(), (Throwable)e1);
                    }
                    errors = true;
                    response.setStatus(404);
                    break block32;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (redirectUrl != null) {
                        html.append("<br/><br/><a href='");
                        html.append(redirectUrl);
                        html.append("'>\u0412\u0435\u0440\u043d\u0443\u0442\u044c\u0441\u044f \u043a \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0435</a>");
                    }
                    html.append("</html>");
                    if (out != null) {
                        out.write(html.toString());
                        out.flush();
                        out.close();
                    }
                    payOnlineUtils.close();
                    ServerUtils.closeConnection((Connection)con);
                }
                html.append(redirectUrl);
                html.append("'>\u0412\u0435\u0440\u043d\u0443\u0442\u044c\u0441\u044f \u043a \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0435</a>");
            }
            html.append("</html>");
            if (out != null) {
                out.write(html.toString());
                out.flush();
                out.close();
            }
            payOnlineUtils.close();
            ServerUtils.closeConnection((Connection)con);
        }
    }
}

