/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.payture.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import ru.bitel.bgbilling.client.common.AbstractTransactionPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.modules.payture.client.TransactionTableModel;
import ru.bitel.bgbilling.modules.payture.common.bean.Transaction;
import ru.bitel.bgbilling.modules.payture.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.payture.common.service.PaytureService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.SearchResult;

public class TransactionPanel
extends AbstractTransactionPanel {
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            String contractTitle = TransactionPanel.this.contractTitleField.getText();
            AbstractTransactionStatus status = (AbstractTransactionStatus)TransactionPanel.this.statusComboBox.getSelectedItem();
            SearchResult searchResult = ((PaytureService)((ClientContext)TransactionPanel.this.getContext()).getPort(PaytureService.class)).searchTransactionList(TransactionPanel.this.getContractId(), contractTitle, status.getCode(), TransactionPanel.this.periodPanel.getPeriod(), TransactionPanel.this.pagePanel.getPage());
            ((TransactionTableModel)TransactionPanel.this.transactionModel).setData(searchResult.getList());
            TransactionPanel.this.pagePanel.setPage(searchResult.getPage());
            TransactionPanel.this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
            TransactionPanel.this.summaField.setText(new DecimalFormat("###,###,##0.00").format(searchResult.getSum()));
        }
    };

    public TransactionPanel() {
        this.statusComboBox.setModel(new DefaultComboBoxModel<TransactionStatus>(TransactionStatus.values()));
    }

    protected void initListeners() {
        super.initPopupListener();
        super.initListeners();
    }

    protected JMenuItem getPaymentRefundMenuItem() {
        return new JMenuItem("\u0412\u0435\u0440\u043d\u0443\u0442\u044c \u043f\u043b\u0430\u0442\u0435\u0436"){
            {
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        Transaction selectedPayment = (Transaction)((TransactionTableModel)TransactionPanel.this.transactionModel).getSelectedRow();
                        if (selectedPayment != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0432\u0435\u0440\u043d\u0443\u0442\u044c \u043f\u043b\u0430\u0442\u0435\u0436?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430", 0) == 0) {
                            try {
                                ((PaytureService)((ClientContext)TransactionPanel.this.getContext()).getPort(PaytureService.class)).refund(selectedPayment.getId());
                            }
                            catch (BGException e) {
                                e.printStackTrace();
                            }
                            TransactionPanel.this.performAction("refresh");
                        }
                    }
                });
            }
        };
    }
}

