/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server;

import bitel.billing.common.TimestampPrintStream;
import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.load.BaseLoader;
import bitel.billing.server.load.DBLoadOut;
import bitel.billing.server.load.DBProcessIn;
import bitel.billing.server.load.DefaultDataProcess;
import bitel.billing.server.load.FTPLoader;
import bitel.billing.server.load.FileInfo;
import bitel.billing.server.load.FileLoader;
import bitel.billing.server.load.LoadIn;
import bitel.billing.server.load.LoadOut;
import bitel.billing.server.load.Loader;
import bitel.billing.server.load.ProcessIn;
import bitel.billing.server.load.ZipLoadIn;
import bitel.billing.server.load.bean.Source;
import bitel.billing.server.load.bean.SourceManager;
import bitel.billing.server.tariff.TariffTreesCache;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.server.errorlog.AlarmTask;
import ru.bitel.bgbilling.kernel.admin.server.errorlog.DatabaseCheckTask;
import ru.bitel.bgbilling.kernel.application.server.Application;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.task.server.task.TaskGenerator;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class DataLoader
extends Thread {
    private boolean stop = false;
    private boolean load = true;
    private boolean process = true;
    private String tempDirPath;
    private Setup setup;
    private Vector<Loader> loadTasks = new Vector();
    private Logger logger;
    private Date startTime = new Date();
    private int loadCount = 0;
    private int processCount = 0;
    private boolean addProcess = true;

    public DataLoader() {
        this.setup = Setup.getSetup();
        Application.getInstance().getCommandPortListener().setApplicationBean((Object)this);
        this.tempDirPath = this.setup.getTempDirPath();
        TimestampPrintStream.setTimestampStreams();
        this.logger = LogManager.getLogger((String)"dataloader");
        System.setProperty("java.protocol.handler.pkgs", "bitel.billing.common.protocol");
        AlarmSender.initSender((DefaultServerSetup)this.setup);
        AlarmSender.registerAlarmTask((AlarmTask)new DatabaseCheckTask());
        this.addProcess = this.setup.getBoolean("loader.add.process", true);
        this.start();
    }

    protected void init() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.info("DataLoader => start()");
        while (true) {
            Connection con = this.setup.getDBConnectionFromPool();
            try {
                if (con == null) {
                    throw new BGException("Database connection is null, check your database connection!");
                }
                String query = "SELECT task_load.id, dt, param FROM task_load INNER JOIN source ON task_load.param=source.id AND source.source_type IN (1, 2) WHERE le < date_sub( now(), interval ? hour ) AND count>0";
                PreparedStatement psSelectTaskLoad = con.prepareStatement(query);
                psSelectTaskLoad.setInt(1, this.setup.getInt("load.interval", 8));
                query = "UPDATE task_load SET count=count-1, le=now() WHERE id=?";
                PreparedStatement psUpdateTaskLoad = con.prepareStatement(query);
                query = "SELECT task_proccess.mid, dt, param, task_proccess.id FROM task_proccess INNER JOIN source ON task_proccess.param=source.id AND source.source_type IN (1, 2) WHERE isNull( start_process_time ) ORDER BY param, dt LIMIT 1";
                PreparedStatement psSelectTaskProcess = con.prepareStatement(query);
                query = "UPDATE task_proccess SET start_process_time=NOW() WHERE id=? AND isNull( start_process_time )";
                PreparedStatement psUpdateStartProcessTime = con.prepareStatement(query);
                query = "DELETE FROM task_proccess where id=?";
                PreparedStatement psDeleteTaskProcess = con.prepareStatement(query);
                if (this.stop) {
                    this.logger.info("DataLoader => finish()");
                    System.exit(0);
                }
                this.init();
                boolean b = true;
                ResultSet rs = null;
                if (this.load) {
                    this.logger.debug("Looking tasks for load...");
                    rs = psSelectTaskLoad.executeQuery();
                    while (rs.next() && this.loadTasks.size() < 15) {
                        this.logger.debug("\tloading - taskId: " + rs.getInt("id") + " source: " + rs.getInt("param"));
                        this.loadFile(rs.getInt("id"), rs.getTimestamp("dt"), rs.getInt("param"));
                        psUpdateTaskLoad.setInt(1, rs.getInt("id"));
                        psUpdateTaskLoad.executeUpdate();
                        b = false;
                    }
                    rs.close();
                }
                this.logger.debug("\nLooking active loaders [" + this.loadTasks.size() + "]...");
                int i = 0;
                while (i < this.loadTasks.size()) {
                    Loader loader = this.loadTasks.elementAt(i);
                    if (!loader.isAlive()) {
                        this.logger.debug(loader.getTaskId() + " isLoad => " + loader.isLoad());
                        int loadedCount = 0;
                        long insertStart = System.currentTimeMillis();
                        if (loader.isLoad()) {
                            loadedCount = this.loadData(loader);
                        } else {
                            this.deleteTask(loader);
                        }
                        long now = System.currentTimeMillis();
                        this.logger.info(loader.getTaskId() + " End task => " + (now - loader.getTaskStartTime()) / 1000L + "/" + (now - insertStart) / 1000L + " sec. [" + loadedCount + "]");
                        this.loadTasks.removeElementAt(i);
                        loader = null;
                        continue;
                    }
                    if (System.currentTimeMillis() - loader.getTaskStartTime() > 300000L) {
                        this.logger.info(loader.getTaskId() + " Delete task ( > 5 min )");
                        this.loadTasks.removeElementAt(i);
                        loader.interrupt();
                        loader = null;
                        continue;
                    }
                    ++i;
                }
                boolean needSleep = true;
                if (b && (!this.load || this.loadTasks.size() == 0) && this.process) {
                    this.logger.debug("\nlooking tasks for process...");
                    rs = psSelectTaskProcess.executeQuery();
                    if (rs.next()) {
                        this.logger.debug("processing mid:" + rs.getInt(1) + " source:" + rs.getInt(3) + " date: " + rs.getString(2));
                        int task_id = rs.getInt(4);
                        psUpdateStartProcessTime.setInt(1, task_id);
                        if (psUpdateStartProcessTime.executeUpdate() > 0) {
                            this.processData(rs.getInt(1), rs.getTimestamp(2), rs.getInt(3));
                            psDeleteTaskProcess.setInt(1, task_id);
                            psDeleteTaskProcess.executeUpdate();
                            ++this.processCount;
                        }
                        needSleep = false;
                    }
                    rs.close();
                }
                if (needSleep) {
                    DataLoader.sleep(4000L);
                } else {
                    DataLoader.sleep(200L);
                }
                psUpdateTaskLoad.close();
                psDeleteTaskProcess.close();
                psSelectTaskLoad.close();
                psUpdateStartProcessTime.close();
                psSelectTaskProcess.close();
                continue;
            }
            catch (Exception ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
                long secsToSleep = 30L;
                this.logger.error("Sleeping " + secsToSleep + " secs");
                try {
                    DataLoader.sleep(secsToSleep * 1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                    throw new RuntimeException("Thread was interrupted!");
                }
            }
            finally {
                ServerUtils.closeConnection((Connection)con);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(int taskId, Timestamp dt, int sourceId) {
        long time = System.currentTimeMillis();
        GregorianCalendar date = new GregorianCalendar();
        date.setTime(new Date(dt.getTime()));
        date.clear(13);
        date.clear(12);
        date.clear(14);
        this.logger.debug(taskId + " Start task");
        FileInfo fileInfo = new FileInfo((Calendar)date);
        Connection con = null;
        try {
            String type;
            con = this.setup.getDBConnectionFromPool();
            String query = null;
            ResultSet rs = null;
            Source source = new SourceManager(con).getSource(sourceId);
            String tableName = "source_data_" + fileInfo.getYYYYMM();
            if (ServerUtils.tableExists((Connection)con, (String)tableName)) {
                query = "SELECT size, modtime FROM " + tableName + " WHERE dt=? AND source_id=?";
                PreparedStatement psSelectSourceData = con.prepareStatement(query);
                long t = date.getTime().getTime();
                psSelectSourceData.setTimestamp(1, new Timestamp(t));
                psSelectSourceData.setInt(2, sourceId);
                rs = psSelectSourceData.executeQuery();
                while (rs.next()) {
                    fileInfo.setDbSize(rs.getLong("size"));
                    fileInfo.setDbTime(rs.getLong("modtime"));
                }
                rs.close();
                psSelectSourceData.close();
            }
            if ((type = String.valueOf(source.getType())) == null) {
                type = "";
            }
            FTPLoader loader = null;
            if ("1".equals(type)) {
                loader = new FTPLoader(taskId, source, fileInfo, this.tempDirPath);
            } else if ("2".equals(type)) {
                loader = new FileLoader(taskId, source, fileInfo, this.tempDirPath);
            }
            if (loader != null) {
                loader.setTaskStartTime(time);
                this.loadTasks.addElement((Loader)loader);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTask(Loader loader) {
        Connection con;
        block4: {
            con = null;
            try {
                if (loader.needLoadFile()) break block4;
                con = this.setup.getDBConnectionFromPool();
                String query = "DELETE FROM task_load WHERE id=? OR count<=0";
                PreparedStatement psDeleteTaskLoad = con.prepareStatement(query);
                psDeleteTaskLoad.setInt(1, loader.getTaskId());
                psDeleteTaskLoad.executeUpdate();
                psDeleteTaskLoad.close();
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    ServerUtils.closeConnection(con);
                    throw throwable;
                }
                ServerUtils.closeConnection((Connection)con);
            }
        }
        ServerUtils.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadData(Loader loader) {
        int result;
        block9: {
            result = 0;
            if (loader != null) {
                Connection con = this.setup.getDBConnectionFromPool();
                try {
                    String serverPack;
                    BGModule module = ModuleCache.getInstance().getModule(loader.getSource().getMid());
                    String string = serverPack = module != null ? module.getInstalledModule().getPackageServer() : null;
                    if (serverPack == null) break block9;
                    try {
                        String name = serverPack + ".BaseLoader";
                        File file = loader.getFileInfo().getFile();
                        if (file != null && file.exists() && file.canRead()) {
                            BaseLoader baseLoader = (BaseLoader)Class.forName(name).getConstructor(new Class[0]).newInstance(new Object[0]);
                            ZipLoadIn loadIn = baseLoader.getZipLoadIn(file);
                            loadIn.setSourceSize(loader.getFileInfo().getSourceSize());
                            loadIn.setSourceTime(loader.getFileInfo().getSourceTime());
                            baseLoader.init((DefaultServerSetup)this.setup, loader.getSource(), loader.getFileInfo().getCalendar(), loader.getTaskId());
                            DBLoadOut loadOut = baseLoader.getDBLoadOut();
                            baseLoader.setLoadOut((LoadOut)loadOut);
                            baseLoader.doLoad(con, (LoadIn)loadIn);
                            long time = loadIn.getSourceTime();
                            long size = loadIn.getSourceSize();
                            baseLoader.finishLoad(con, true, this.addProcess, time, size);
                            loadIn.finishLoad();
                            ++this.loadCount;
                            result = baseLoader.getRecordCount();
                            break block9;
                        }
                        this.logger.info("File not found, i'll try later..");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    ServerUtils.closeConnection((Connection)con);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processData(int mid, Timestamp time, int sourceId) {
        block9: {
            if (mid > 0 && time != null && sourceId > -1) {
                Connection con = this.setup.getDBConnectionFromPool();
                try {
                    String server_pack;
                    BGModule module = ModuleCache.getInstance().getModule(mid);
                    String string = server_pack = module != null ? module.getInstalledModule().getPackageServer() : null;
                    if (server_pack == null) break block9;
                    try {
                        String name = server_pack + ".DataProcess";
                        DefaultDataProcess proccess = (DefaultDataProcess)Class.forName(name).getConstructor(new Class[0]).newInstance(new Object[0]);
                        Source source = new SourceManager(con).getSource(sourceId);
                        if (source != null) {
                            DBProcessIn processIn = proccess.getDBProcessIn(this.setup, source, TimeUtils.convertTimestampToCalendar((Timestamp)time), con);
                            proccess.proccess((ProcessIn)processIn, con);
                            processIn.finishProcess();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    ServerUtils.closeConnection((Connection)con);
                }
            }
        }
    }

    public void stopLoader() {
        this.stop = true;
    }

    public String getStatus() {
        StringBuffer result = new StringBuffer(100);
        result.append("DataLoader working");
        result.append("\n");
        result.append(ServerUtils.uptimeStatus((Date)this.startTime));
        result.append("\n");
        result.append(Utils.memoryStatus());
        result.append("\n");
        result.append("Trees in cache: " + TariffTreesCache.getCache().getCacheStatus());
        result.append("\n");
        result.append("Hour logs loaded : " + this.loadCount + "; ");
        result.append("processed: " + this.processCount);
        result.append("\n");
        result.append(this.setup.getPoolStatus());
        result.append("\n");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addLoad(String param) {
        String result = null;
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            int pos = param.indexOf(61);
            param = param.substring(pos + 1);
            pos = param.lastIndexOf(45);
            Calendar date = TimeUtils.parseCalendar((String)param.substring(0, pos), (String)"yyyy-MM-dd-HH");
            int sourceId = Utils.parseInt((String)param.substring(pos + 1));
            if (date != null && sourceId >= 0) {
                Vector<String> hour = new Vector<String>();
                hour.add(String.valueOf(date.get(11)));
                new TaskGenerator(con).loadTask(0, TimeUtils.convertCalendarToDate((Calendar)date), sourceId, hour);
                result = "Task added";
            } else {
                result = "Params error!";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
        return result;
    }

    public String executeCommand(String command, String param) {
        Object result = "";
        if (command.equals("stop")) {
            this.stopLoader();
            result = "ok";
        } else {
            result = command.equals("status") ? this.getStatus() : (command.startsWith("load") ? this.addLoad(command) : (command.equals("sysvar") ? Utils.getSystemVariables() : (command.equals("javavar") ? Utils.getJavaProperties() : "DLProcessManager => Unknown command : " + command)));
        }
        return result;
    }
}

