/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server;

import bitel.billing.server.util.MailMsg;
import java.util.Calendar;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskRecalculator;
import ru.bitel.bgbilling.modules.phone.server.task.BalanceSetter;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public class PhoneBalanceSetter
extends RunTaskRecalculator<BalanceSetter> {
    public PhoneBalanceSetter(int mid, Calendar dt, String email) {
        super(mid, dt, email);
    }

    public void executeTask() {
        try {
            long start = System.currentTimeMillis();
            BalanceSetter calculator = this.createTask();
            calculator.startTask();
            long end = System.currentTimeMillis();
            if (this.email != null) {
                StringBuffer report = new StringBuffer("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430\n");
                report.append("\u0412\u0440\u0435\u043c\u044f: ");
                report.append(TimeUtils.formatDeltaTime((long)((end - start) / 1000L)));
                MailMsg msg = new MailMsg((Preferences)this.setup);
                msg.sendMessage(this.email, "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430", report.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected BalanceSetter createTask() {
        BalanceSetter calculator = new BalanceSetter();
        calculator.setExecutingTime(this.dt);
        calculator.initTask(Setup.getSetup(), 0, "mid=" + this.mid);
        return calculator;
    }
}

