/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server;

import java.sql.Connection;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ServiceCost;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTree;
import ru.bitel.bgbilling.modules.phone.server.DataProcess;
import ru.bitel.bgbilling.modules.phone.server.FindItemConveyorContext;
import ru.bitel.bgbilling.modules.phone.server.LogRecord;
import ru.bitel.bgbilling.modules.phone.server.TariffConveyorEntry;
import ru.bitel.bgbilling.modules.phone.server.bean.CalculateClientItem;
import ru.bitel.bgbilling.modules.phone.server.tariff.PhoneServiceCost;
import ru.bitel.bgbilling.modules.phone.server.tariff.PhoneTariffContext;
import ru.bitel.bgbilling.modules.phone.server.tariff.PhoneTariffRequest;
import ru.bitel.bgbilling.modules.phone.server.tariff.PhoneTariffThreadContext;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.Conveyor;
import ru.bitel.common.worker.ThreadContextFactory;

class TariffConveyor
extends Conveyor<TariffConveyorEntry, FindItemConveyorContext, PhoneTariffThreadContext> {
    private static final Logger logger = LogManager.getLogger();
    private final DefaultServerSetup setup;
    private final DataProcess dataProcess;
    private final PhoneTariffContext tariffContext;

    public TariffConveyor(DefaultServerSetup setup, final DataProcess dataProcess, Connection con) throws BGException {
        super(2, 10, 100, (ThreadContextFactory)new ThreadContextFactory<PhoneTariffThreadContext>(){

            public PhoneTariffThreadContext newThreadContext() {
                return dataProcess.newTariffThreadContext();
            }
        });
        this.setup = setup;
        this.dataProcess = dataProcess;
        this.tariffContext = new PhoneTariffContext(con, dataProcess.mid, dataProcess.hour, dataProcess.itemZoneTrafficCache);
    }

    public FindItemConveyorContext newThreadContext() {
        return new FindItemConveyorContext(this.setup, this);
    }

    protected void process(List<TariffConveyorEntry> task, PhoneTariffThreadContext context) throws BGException {
        int size = task.size();
        for (int i = 0; i < size; ++i) {
            try {
                task.get(i).processEntry(context, context.getConnectionSet());
                continue;
            }
            catch (Exception ex) {
                Object message = "error while tarification ";
                CalculateClientItem item = null;
                LogRecord record = null;
                if (task.get(i) != null && task.get(i) instanceof FindItemConveyorContext.PointEntry) {
                    item = ((FindItemConveyorContext.PointEntry)task.get((int)i)).item;
                    record = ((FindItemConveyorContext.PointEntry)task.get((int)i)).record;
                    message = (String)message + "point;";
                } else if (task.get(i) != null && task.get(i) instanceof FindItemConveyorContext.RuleEntry) {
                    item = ((FindItemConveyorContext.RuleEntry)task.get((int)i)).item;
                    record = ((FindItemConveyorContext.RuleEntry)task.get((int)i)).record;
                    message = (String)message + "record;";
                }
                if (item != null && record != null) {
                    message = (String)message + "itemId=" + item.itemId + ";recordId + " + record.id + ";fromNumber=" + record.fromNumber + ";toNumber = " + record.toNumber;
                }
                logger.error((String)message, (Throwable)ex);
            }
        }
    }

    final void processPointRecordImpl(PhoneTariffThreadContext threadCtx, ConnectionSet connectionSet, CalculateClientItem pointItem, LogRecord record) throws BGException {
        if (pointItem != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Found point " + pointItem.itemId);
            }
            this.checkAndInitTariff(pointItem, connectionSet, this.dataProcess.mid);
            if (pointItem.tariffTreeListNew == null && pointItem.subContractTariffTreeMapNew == null) {
                this.dataProcess.addError("\u041d\u0435\u0442 \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0445 \u043f\u043b\u0430\u043d\u043e\u0432!", pointItem, record, null);
            } else {
                boolean accepted = pointItem.tariffTreeListNew == null ? false : this.tryTariff(threadCtx, connectionSet, record, pointItem, pointItem.contract, pointItem.tariffTreeListNew);
                if (!accepted && pointItem.subContractTariffTreeMapNew != null) {
                    for (CalculateClientItem.ContractInfo subContract : pointItem.subContracts) {
                        List<TariffModuleTree> treeList = pointItem.subContractTariffTreeMapNew.get(subContract.id);
                        if (treeList != null) {
                            accepted = this.tryTariff(threadCtx, connectionSet, record, pointItem, subContract, treeList);
                        }
                        if (!accepted) continue;
                        break;
                    }
                }
                if (!accepted && record.sessionTime > 0) {
                    this.dataProcess.addError("\u0417\u0432\u043e\u043d\u043e\u043a \u043f\u043e\u0438\u043d\u0442\u0430 \u043d\u0435 \u0442\u0430\u0440\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d!", pointItem, record, null);
                }
            }
        } else if (this.dataProcess.cids == null && this.dataProcess.auditor.containsNumber(record.fromNumber164)) {
            this.dataProcess.addError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440!", null, record, null);
        }
    }

    final void processRuleRecordImpl(PhoneTariffThreadContext threadCtx, ConnectionSet connectionSet, CalculateClientItem operItem, LogRecord record) throws BGException {
        if (logger.isDebugEnabled()) {
            logger.debug("Found operRule " + operItem.itemId);
        }
        this.checkAndInitTariff(operItem, connectionSet, this.dataProcess.mid);
        if (operItem.tariffTreeListNew == null) {
            this.dataProcess.addError("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u043f\u043b\u0430\u043d!", operItem, record, null);
            return;
        }
        boolean tariff = false;
        for (TariffModuleTree tree : operItem.tariffTreeListNew) {
            PhoneTariffRequest req = new PhoneTariffRequest(this.dataProcess.mid, operItem.contract.id, record.id);
            req.setConnectionSet(connectionSet);
            req.setItemId(operItem.itemId);
            req.setCallType(0);
            req.setTime(record.sessionStart);
            req.setPhoneFrom(record.fromNumber164);
            req.setPhoneTo(record.toNumber164);
            req.setPhoneOriginalTo(record.toNumber);
            req.setPortFrom(record.fromPort);
            req.setPortTo(record.toPort);
            req.setAccountingMonthDays(this.dataProcess.hour.getActualMaximum(5));
            req.setClientCdrCost(record.callClientCost);
            Calendar date1 = operItem.date1;
            Calendar date2 = operItem.date2;
            if (date1 == null || TimeUtils.dateBefore((Calendar)date1, (Calendar)threadCtx.startMonth)) {
                date1 = threadCtx.startMonth;
            }
            if (date2 == null || TimeUtils.dateBefore((Calendar)threadCtx.endMonth, (Calendar)date2)) {
                date2 = threadCtx.endMonth;
            }
            req.serviceCost = new PhoneServiceCost(operItem.serviceId, operItem.date1, operItem.date2, date1, date2, record.sessionTime);
            req.operServiceCost = new PhoneServiceCost(operItem.serviceId, operItem.date1, operItem.date2, date1, date2, record.sessionTime);
            req.addServiceCost((ServiceCost)((PhoneServiceCost)req.serviceCost));
            tree.execute((AbstractTariffRequest)req, (TariffContext)this.tariffContext);
            PhoneServiceCost data = (PhoneServiceCost)req.serviceCost;
            if (!req.isAccepted() || data.cost == null) continue;
            int dest = req.getDest();
            this.dataProcess.operSession.incrementAndGet();
            this.dataProcess.insertSession(threadCtx, record, operItem.itemId, operItem.contract.id, operItem.serviceId, record.connectTime, data, null, dest, req.getZone(), this.tariffContext);
            tariff = true;
            break;
        }
        if (!tariff) {
            this.dataProcess.addError("\u0417\u0432\u043e\u043d\u043e\u043a \u043f\u0440\u0430\u0432\u0438\u043b\u0430 \u043d\u0435 \u0442\u0430\u0440\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d!", operItem, record, null);
        }
    }

    public void checkAndInitTariff(CalculateClientItem item, ConnectionSet connectionSet, int mid) throws BGException {
        if (!item.tariffInit) {
            Connection con = connectionSet.getConnection();
            List treeList = this.tariffContext.getTariffList(con, item.contract.id, item.itemId);
            if (item.subContracts != null) {
                item.subContractTariffTreeMapNew = new HashMap<Integer, List<TariffModuleTree>>();
                for (CalculateClientItem.ContractInfo subContract : item.subContracts) {
                    List subTreeList = this.tariffContext.getTariffList(con, subContract.id, item.itemId);
                    if (subTreeList.size() <= 0) continue;
                    item.subContractTariffTreeMapNew.put(subContract.id, subTreeList);
                }
                if (item.subContractTariffTreeMapNew.size() == 0) {
                    item.subContractTariffTreeMapNew = null;
                }
            }
            if (treeList.size() == 0) {
                treeList = null;
            }
            item.tariffInit = true;
            item.tariffTreeListNew = treeList;
        }
    }

    private boolean tryTariff(PhoneTariffThreadContext threadCtx, ConnectionSet connectionSet, LogRecord record, CalculateClientItem item, CalculateClientItem.ContractInfo contractInfo, List<TariffModuleTree> treeList) {
        boolean result = false;
        if (treeList != null) {
            for (TariffModuleTree tree : treeList) {
                PhoneServiceCost operCost;
                PhoneTariffRequest req = new PhoneTariffRequest(this.dataProcess.mid, item.contract.id, record.id);
                req.setConnectionSet(connectionSet);
                req.setItemId(item.itemId);
                req.setCallType(0);
                req.setTime(record.sessionStart);
                req.setPhoneFrom(record.fromNumber164);
                req.setPhoneTo(record.toNumber164);
                req.setPhoneOriginalTo(record.toNumber);
                req.setPortFrom(record.fromPort);
                req.setPortTo(record.toPort);
                req.setAccountingMonthDays(this.dataProcess.hour.getActualMaximum(5));
                req.setClientCdrCost(record.callClientCost);
                Calendar date1 = item.date1;
                Calendar date2 = item.date2;
                if (date1 == null || TimeUtils.dateBefore((Calendar)date1, (Calendar)threadCtx.startMonth)) {
                    date1 = threadCtx.startMonth;
                }
                if (date2 == null || TimeUtils.dateBefore((Calendar)threadCtx.endMonth, (Calendar)date2)) {
                    date2 = threadCtx.endMonth;
                }
                req.serviceCost = new PhoneServiceCost(0, item.date1, item.date2, date1, date2, record.sessionTime);
                req.operServiceCost = new PhoneServiceCost(0, item.date1, item.date2, date1, date2, record.sessionTime);
                req.addServiceCost((ServiceCost)((PhoneServiceCost)req.serviceCost));
                tree.execute((AbstractTariffRequest)req, (TariffContext)this.tariffContext);
                int dest = req.getDest();
                int sid = ((PhoneServiceCost)req.serviceCost).serviceId;
                int zone = req.getZone();
                PhoneServiceCost clientCost = ((PhoneServiceCost)req.serviceCost).cost != null ? (PhoneServiceCost)req.serviceCost : null;
                PhoneServiceCost phoneServiceCost = operCost = ((PhoneServiceCost)req.operServiceCost).cost != null ? (PhoneServiceCost)req.operServiceCost : null;
                if (logger.isDebugEnabled()) {
                    logger.debug("Tree => " + tree.getTreeId());
                    logger.debug(req.toString());
                }
                if (!req.isAccepted() || clientCost == null || dest <= 0 || sid <= 0) continue;
                this.dataProcess.clientSession.incrementAndGet();
                result = true;
                this.dataProcess.insertSession(threadCtx, record, item.itemId, contractInfo.id, sid, record.sessionTime, clientCost, operCost, dest, zone, this.tariffContext);
                break;
            }
        }
        return result;
    }
}

