/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelMonth;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.JRViewer;
import bitel.billing.module.common.TransferData;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.common.table.Button;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.JRLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ServiceConfigOperator
extends ServiceConfigTabbedPanel {
    private CardLayout cardLayout = new CardLayout();
    private JRViewer jasperViewer;
    private BGComboBox<ComboBoxItem> operCb = new BGComboBox();
    private BGControlPanelMonth month = new BGControlPanelMonth();
    private JLabel snapshoStatusLabel = new JLabel();
    private JLabel prevSnapshotLabel = new JLabel();
    private JButton doSnapshot = new JButton("\u041f\u0440\u043e\u0438\u0437\u0432\u0435\u0441\u0442\u0438 \u0441\u0440\u0435\u0437");
    private BGTable reportTable = new BGTable();

    public ServiceConfigOperator() {
        this.jbInit();
        this.reportTable.setHeader(this.rb_name, this.moduleDoc, "oper_report");
    }

    private void jbInit() {
        JPanel jasperViewPanel = new JPanel(new GridBagLayout());
        try {
            this.jasperViewer = new JRViewer(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JButton closeButton = new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        jasperViewPanel.add((Component)this.jasperViewer, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jasperViewPanel.add((Component)closeButton, new GridBagConstraints(0, 1, 1, 1, 11.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel reportTablePanel = new JPanel(new GridBagLayout());
        JPanel topFilter = new JPanel(new GridBagLayout());
        topFilter.setBorder((Border)new BGTitleBorder(" \u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440 \u0438 \u043c\u0435\u0441\u044f\u0446 "));
        topFilter.add((Component)this.operCb, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        topFilter.add((Component)this.month, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel snapshotInfo = new JPanel(new GridBagLayout());
        snapshotInfo.setBorder((Border)new BGTitleBorder(" \u0421\u0440\u0435\u0437\u044b \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 "));
        snapshotInfo.add((Component)new JLabel("\u0421\u0440\u0435\u0437 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        snapshotInfo.add((Component)this.snapshoStatusLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        snapshotInfo.add((Component)this.doSnapshot, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        snapshotInfo.add((Component)new JLabel("\u041f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439 \u0441\u0440\u0435\u0437:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        snapshotInfo.add((Component)this.prevSnapshotLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        JPanel reportPanel = new JPanel(new GridBagLayout());
        reportPanel.setBorder((Border)new BGTitleBorder(" \u041e\u0442\u0447\u0435\u0442\u044b "));
        reportPanel.add((Component)new JScrollPane((Component)this.reportTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        reportTablePanel.add((Component)topFilter, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        reportTablePanel.add((Component)snapshotInfo, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        reportTablePanel.add((Component)reportPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(this.cardLayout);
        this.add(reportTablePanel, "table");
        this.add(jasperViewPanel, "view");
        closeButton.addActionListener(e -> this.cardLayout.show((Container)((Object)this), "table"));
        this.operCb.addActionListener(e -> this.showData());
        this.month.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("date")) {
                this.showData();
            }
        });
        this.doSnapshot.addActionListener(e -> this.doSnapshot());
    }

    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setAction("OperatorList");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildComboBox(this.operCb, (Node)XMLUtils.selectElement((Node)doc, (String)"//list"), (String)"");
        }
        this.showData();
    }

    private void doSnapshot() {
        String operId = ClientUtils.getIdFromComboBox(this.operCb);
        if (Utils.isBlankString((String)operId)) {
            return;
        }
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0441\u0440\u0435\u0437 \u0437\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043c\u0435\u0441\u044f\u0446?", "\u0421\u0440\u0435\u0437", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("CreateSnapshot");
            request.setAttribute("oper_id", operId);
            request.setAttribute("month", this.month.getDateString());
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.showData();
            }
        }
    }

    private void showData() {
        Element snapshot;
        String operId = ClientUtils.getIdFromComboBox(this.operCb);
        if (Utils.isBlankString((String)operId)) {
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setAction("SnapshotInfo");
        request.setAttribute("oper_id", operId);
        request.setAttribute("month", this.month.getDateString());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc) && (snapshot = XMLUtils.selectElement((Node)doc, (String)"//snapshot")) != null) {
            boolean need = Utils.parseBoolean((String)snapshot.getAttribute("need"));
            if (need) {
                if (Utils.parseBoolean((String)snapshot.getAttribute("has"))) {
                    this.snapshoStatusLabel.setText("\u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d");
                } else {
                    this.snapshoStatusLabel.setText("\u043d\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d");
                }
                this.prevSnapshotLabel.setText(snapshot.getAttribute("last_month"));
            } else {
                this.snapshoStatusLabel.setText("\u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f");
                this.prevSnapshotLabel.setText("\u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f");
            }
            this.doSnapshot.setEnabled(need);
        }
        request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setAction("ReportTable");
        request.setAttribute("oper_id", operId);
        request.setAttribute("month", this.month.getDateString());
        doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.reportTable.updateData(doc);
        }
        int rowCount = this.reportTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            final String id = (String)this.reportTable.getColumnValue(i, "id");
            final String type = (String)this.reportTable.getColumnValue(i, "type_id");
            final String fileName = (String)this.reportTable.getColumnValue(i, "file_name");
            Button button = (Button)this.reportTable.getColumnValue(i, "action");
            button.setActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServiceConfigOperator.this.getReport(type, id, fileName);
                }
            });
        }
    }

    private void getReport(String type, String id, String fileName) {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GetReport");
        request.setModuleId(this.getModuleId());
        request.setAttribute("oper_id", ClientUtils.getIdFromComboBox(this.operCb));
        request.setAttribute("month", this.month.getDateString());
        request.setAttribute("id", id);
        request.setAttribute("contentType", "binary");
        boolean view = type.equals(String.valueOf(1));
        if (view) {
            TransferData.HTTPDataSource data = this.getDataSource(request);
            if (data != null && !data.isError()) {
                try {
                    this.jasperViewer.setReport((JasperPrint)JRLoader.loadObject((InputStream)data.getInputStream()));
                    this.cardLayout.show((Container)((Object)this), "view");
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((String)("\u041e\u0448\u0438\u0431\u043a\u0430 " + ex.getMessage()));
                    ex.printStackTrace();
                }
            }
        } else {
            BGFileChooser fileChooser = new BGFileChooser((Component)((Object)this));
            fileChooser.setFileSelectionMode(1);
            if (fileChooser.showSaveDialog((Component)JOptionPane.getRootFrame()) == 0) {
                String fullFilePath = fileChooser.getSelectedFile().getAbsolutePath() + File.separator + fileName;
                try {
                    FileOutputStream fos = new FileOutputStream(fullFilePath);
                    fos.write(this.getBytes(request));
                    fos.flush();
                    fos.close();
                }
                catch (Exception e) {
                    ClientUtils.showErrorMessageDialog((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u0444\u0430\u0439\u043b\u0430: " + fullFilePath));
                    return;
                }
            }
        }
    }
}

