/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.client.tariff;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.common.Utils;

public class PortFilterTariffTreeNode
extends DefaultTariffTreeNode {
    private static final Icon icon = ClientUtils.getIcon((String)"filter");
    private JLabel view = new JLabel(icon, 2);
    private String portsTo;
    private String portsFrom;
    private String comment;
    private JPanel editor;
    private BGTextField portToTf;
    private BGTextField portFromTf;
    private BGTextField commentTf;

    protected JPanel getEditorPanel() {
        if (this.editor == null) {
            this.portToTf = new BGTextField();
            this.portToTf.setMinimumSize(new Dimension(250, 24));
            this.portToTf.setPreferredSize(new Dimension(250, 24));
            this.portFromTf = new BGTextField();
            this.portFromTf.setMinimumSize(new Dimension(250, 24));
            this.portFromTf.setPreferredSize(new Dimension(250, 24));
            this.commentTf = new BGTextField();
            this.commentTf.setMinimumSize(new Dimension(250, 24));
            this.commentTf.setPreferredSize(new Dimension(250, 24));
            this.editor = new JPanel(new GridBagLayout());
            this.editor.add((Component)new JLabel("\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0435 \u043f\u043e\u0440\u0442\u044b: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.editor.add((Component)this.portToTf, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.add((Component)new JLabel("\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0435 \u043f\u043e\u0440\u0442\u044b: "), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.editor.add((Component)this.portFromTf, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439: "), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.editor.add((Component)this.commentTf, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        }
        return this.editor;
    }

    public Component getView() {
        this.extractData();
        StringBuilder title = new StringBuilder(20).append("<html>");
        if (Utils.notBlankString((String)this.portsTo)) {
            title.append("\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0435 \u043f\u043e\u0440\u0442\u044b: ");
            title.append(this.portsTo);
        }
        if (Utils.notBlankString((String)this.portsTo) && Utils.notBlankString((String)this.portsFrom)) {
            title.append("<br>");
        }
        if (Utils.notBlankString((String)this.portsFrom)) {
            title.append("\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0435 \u043f\u043e\u0440\u0442\u044b: ");
            title.append(this.portsFrom);
        }
        if (Utils.notBlankString((String)this.portsTo) && Utils.notBlankString((String)this.comment)) {
            title.append("<br>");
        }
        if (Utils.notBlankString((String)this.comment)) {
            title.append(this.comment);
        }
        title.append("</html>");
        this.view.setText(title.toString());
        return this.view;
    }

    protected void loadData() {
        this.extractData();
        this.portToTf.setText(this.portsTo);
        this.portFromTf.setText(this.portsFrom);
        this.commentTf.setText(this.comment);
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("port_to", this.portToTf.getText());
        data.put("port_from", this.portFromTf.getText());
        data.put("comment", this.commentTf.getText());
        this.setDataInHash(data);
    }

    private void extractData() {
        Map data = this.getDataInHash();
        this.portsTo = Utils.maskNull((String)((String)data.get("port_to")));
        this.portsFrom = Utils.maskNull((String)((String)data.get("port_from")));
        this.comment = Utils.maskNull((String)((String)data.get("comment")));
    }

    public void serializeToXML(Element el) {
        this.serializeHashToXML(el);
        this.serializeChildsToXML(el);
    }

    public void loadFromXML(Element el) {
        this.loadHashFromXML(el);
        this.loadChildsFromXML(el);
    }
}

