<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="layout.xsl"/>

<xsl:template name="title">
<xsl:choose>
	<xsl:when test="data/@action = 'ReportSession'">Просмотр сессий</xsl:when>
	<xsl:when test="data/@action = 'ReportAmount'">Наработка по Телефонии</xsl:when>
	<xsl:when test="data/@action = 'ReportDirect'">Наработка по направлениям</xsl:when>
	<xsl:when test="data/@action = 'ReportService'">Наработка по услугам</xsl:when>
	<xsl:when test="data/@action = 'ReportServiceSession'">Детализация по телефонии</xsl:when>	
	<xsl:when test="data/@action = 'DispatchSession'">Рассылка сессий</xsl:when>
	<xsl:when test="data/@action = 'DispatchDirect'">Рассылка сессий</xsl:when>
	<xsl:when test="data/@action = 'DispatchAmount'">Рассылка сессий</xsl:when>
	<xsl:when test="data/@action = 'ReportIncommingCall'">Просмотр входящих звонков</xsl:when>
	<xsl:when test="data/@action = 'PhoneLists'">Управление черными\белыми списками</xsl:when>
	<xsl:when test="data/@action = 'ChangeTariff'">Управление тарифными планами телефонии </xsl:when>
</xsl:choose>
</xsl:template>


<xsl:template match="/data">

<xsl:choose>
	<xsl:when test="@action = 'ReportAmount'">
		<xsl:call-template name="ReportAmount"/>
	</xsl:when>
	<xsl:when test="@action = 'ReportSession'">
	 	<xsl:call-template name="ReportSession"/>
	</xsl:when>
	<xsl:when test="@action = 'ReportDirect'">
	 	<xsl:call-template name="ReportDirect"/>
	</xsl:when>
	<xsl:when test="@action = 'ReportService'">
	 	<xsl:call-template name="ReportService"/>
	</xsl:when>
	<xsl:when test="@action = 'ReportServiceSession'">
	 	<xsl:call-template name="ReportServiceSession"/>
	</xsl:when>
	<xsl:when test="@action = 'DispatchSession'">
	 	<xsl:call-template name="Dispatch"/>
	</xsl:when>
	<xsl:when test="@action = 'DispatchDirect'">
	 	<xsl:call-template name="Dispatch"/>
	</xsl:when>
	<xsl:when test="@action = 'DispatchAmount'">
	 	<xsl:call-template name="Dispatch"/>
	</xsl:when>
	<xsl:when test="@action = 'ReportIncommingCall'">
	 	<xsl:call-template name="ReportIncommingCall"/>
	</xsl:when>
	<xsl:when test="@action = 'PhoneLists'">
	 	<xsl:call-template name="PhoneLists"/>
	</xsl:when>
	<xsl:when test="@action = 'ChangeTariff'">		
	 	<xsl:call-template name="ChangeTariff"/>
	</xsl:when>
</xsl:choose>
</xsl:template>

<xsl:template name="PhoneLists">
   	<script type="text/javascript"><![CDATA[
		function removeNumber( rowId )
		{
	        var numTable = document.getElementById('itemListNumbersTable');
	        for ( index = 0; index < numTable.rows.length; index++ )
	        {
                if ( numTable.rows[index] == rowId )
                {
               		numTable.deleteRow(index);
                    break;
                }
	        }
		}
		
		function addNumberRow()
		{
	        var numTable = document.getElementById('itemListNumbersTable');
	        var numRow = numTable.insertRow( numTable.rows.length );
	        var cell = numRow.insertCell(0);
	        cell.innerHTML = "<input type='text' size='15'/>";
	        cell = numRow.insertCell(1);
	        cell.innerHTML = "<button class='gradbtn blue' onclick='removeNumber(this.parentNode.parentNode)'>Удалить</button>";
		}
		
		function setNumData()
		{
	        var value = "";
	        var numTable = document.getElementById('itemListNumbersTable');
	        for ( index = 0; index < numTable.rows.length; index++ )
	        {
                var cells = numTable.rows[index].cells;
                var number = cells[0].childNodes[0].value;
                value=value + number;
                value=value + ",";
	        }
	        document.getElementById('hiddenNumbersInput').value = value;
		}   	
      ]]> 
    </script>

	<form name="chooseItem" action="{$WEBEXECUTER}" method="post">
		<xsl:call-template name="action"/>
		<p>Выберите номер телефона:</p>
		<select class="multiselect" multiple="0" size="10" name="selectedItem">
			<xsl:for-each select="/data/phone_items/data/item">
				<option>
					<xsl:attribute name="value"><xsl:value-of select="id/text()"/></xsl:attribute>
					<xsl:if test="/data/selectedItem/text() = id/text()">
						<xsl:attribute name="selected">1</xsl:attribute>
					</xsl:if>
					<xsl:value-of select="clientNumbers/text()"/>
				</option>
			</xsl:for-each>
		</select><br/>
		<xsl:call-template name="submit">
			<xsl:with-param name="title" select="'Редактировать'"/>
		</xsl:call-template>
	</form>	
	
	<xsl:if test="/data/selectedItem/text() != ''">
		<xsl:call-template name="ListsEdit">
			<xsl:with-param name="selectedItem"><xsl:value-of select="selectedItem/text()"/></xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<xsl:template name="ListsEdit">
	<xsl:param name="selectedItem"/>
	<p>Режим списков:</p>
		<form name="listType" action="{$WEBEXECUTER}" method="post">
		<xsl:call-template name="action"/>
		<input type="hidden" name="selectedItem" value="{$selectedItem}"/>
		<input type="hidden" name="operation" value="updateMode" />
		<select class="multiselect gridbtn " name="mode">
			<xsl:for-each select="modes/data/item">
				<option>
					<xsl:attribute name="value"><xsl:value-of select="@ordinal"/></xsl:attribute>
					<xsl:if test="@ordinal = /data/currentMode/@ordinal">
						<xsl:attribute name="selected">1</xsl:attribute>
					</xsl:if>
					<xsl:value-of select="@title"/>
				</option>
			</xsl:for-each>
		</select>
		<xsl:call-template name="submit">
			<xsl:with-param name="title" select="'Применить'"/>
		</xsl:call-template>
	</form>
	
	<xsl:if test="/data/currentMode/@ordinal != 0">
	<p>Номера:</p>
	<form name="numbers" action="{$WEBEXECUTER}" method="post">
		<xsl:call-template name="action"/>
		<input type="hidden" name="selectedItem" value="{$selectedItem}"/>
		<input type="hidden" name="operation" value="updateNumbers" />
		<input type="hidden" name="numbers" value="" id="hiddenNumbersInput"/>
       	<xsl:call-template name="button">
			<xsl:with-param name="title" select="'Добавить номер'"/>
			<xsl:with-param name="onclick">addNumberRow();</xsl:with-param>
		</xsl:call-template>
        <table id="itemListNumbersTable">
	        <xsl:for-each select="numbers/data/item">
		        <tr>
		        	<td>
		        		<input type="text" size="15" id="houseValue">
				        	<xsl:attribute name="value">
				        		<xsl:value-of select="number"/>
				        	</xsl:attribute>
				        </input>
				    </td>
		        	<td><xsl:call-template name="button">
							<xsl:with-param name="title" select="'Удалить'"/>
							<xsl:with-param name="onclick">removeNumber(this.parentNode.parentNode);</xsl:with-param>
						</xsl:call-template>
					</td>
		        </tr>
	        </xsl:for-each>
        </table>
		<xsl:call-template name="button">
			<xsl:with-param name="title" select="'Применить'"/>
			<xsl:with-param name="onclick" select="'setNumData();'"/>
			<xsl:with-param name="type" select="'submit'"/>
		</xsl:call-template>
	</form>
	</xsl:if>
</xsl:template>

<xsl:template name="report_filters">
	<xsl:param name="onlyPoints"/>

		<table class="filter">
		<tr>
			<td colspan="2">
				<xsl:choose>
					<xsl:when test="$onlyPoints">Пойнты</xsl:when>
					<xsl:when test="/data/@type = 1">
						Пойнты<xsl:if test="/data/@rules = 1">/<a href="#" onclick="document.forms['report'].type.value='2'; document.forms['report'].items.name='_items';document.forms['report'].submit();">Правила</a></xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="/data/@points = 1"><a href="#" onclick="document.forms['report'].type.value='1'; document.forms['report'].items.name='_items';document.forms['report'].submit();">Пойнты</a>/</xsl:if>Правила
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td rowspan="4">
				<select size="10" style="width: 500px" name="items" multiple="1">
					<xsl:for-each select="items/item">
					<option>
						<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
						<xsl:if test="@selected = '1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
						<xsl:value-of select="@title"/>
					</option>
					</xsl:for-each>
				</select>
				<br/><em class="comment">Для выделения сразу нескольких<br/>пойнтов/правил держите нажатой клавишу 'Ctrl'</em>
			</td>
			<td style="vertical-align: top">
				<table><tr>
				<td>Месяц:</td>
				<td>
					<select class="gradbtn " name='month' onchange="document.forms['report'].submit();">
						<xsl:call-template name="month_list"/>
					</select>
				</td>
				<td>Год:</td>
				<td>
					<select class="gradbtn " name='year' style="margin-right:0px" onchange="document.forms['report'].submit();">
						<xsl:call-template name="year_list"/>
					</select>
				</td>
				</tr></table>
			</td>
		</tr>
		<tr>
			<td style="padding-top: 10px; vertical-align: top">
				<table width="100%"><tr>
					<td nowrap="nowrap">Числа месяца:</td>
					<td width="50%" style="text-align:center">c</td>
					<td><input type="text" name="day_from" size="4" value="{date/@day_from}"/></td>
					<td width="50%" style="text-align:center">по</td>
					<td><input type="text" name="day_to" size="4" value="{date/@day_to}"/></td>
				</tr></table>
			</td>
		</tr>
		<tr>
			<td style="padding-top: 10px; vertical-align: top">
				<input type="checkbox" name="nofree" value="1"><xsl:if test="items/@nofree = '1'"><xsl:attribute name="checked">1</xsl:attribute></xsl:if></input>Только платные
			</td>
		</tr>
		<tr> 
			<td valign="bottom" style="text-align: right">
				<xsl:call-template name="submit">
					<xsl:with-param name="title" select="'Вывести'"/>
				</xsl:call-template>
			</td>
		</tr>
	</table>
</xsl:template>


<!-- сессии логина -->
<xsl:template name="ReportSession">
	<form method='post' action='{$WEBEXECUTER}#idDivReport' name="report" id="reportForm">
		<input type="hidden" name="pageSize"><xsl:attribute name="value"><xsl:value-of select="sessions/@pageSize"/></xsl:attribute></input>
		<xsl:call-template name="action"/>
		
		<input type="hidden" name="type" value="{/data/@type}"/>		
		<input type="hidden" name="dest" value="{/data/@dest}"/>
		<input type="hidden" name="sid" value="{/data/@sid}"/>
		
		<xsl:call-template name="report_filters"/>
	</form>	
		
	<xsl:if test="sessions">
		<xsl:variable name="items"><xsl:for-each select="items/item[@selected = '1']">&amp;items=<xsl:value-of select="@id"/></xsl:for-each></xsl:variable>
		<div>
			Отчет в виде:
			<a title="CSV" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportSession&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@sid}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=csv">CSV</a>,
			<a title="HTML" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportSession&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@sid}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=html">HTML</a>,
			<a title="CSV/ZIP" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportSession&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@sid}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=csv&amp;zip=1">CSV/ZIP</a>,
			<a title="HTML/ZIP" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportSession&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@sid}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=html&amp;zip=1">HTML/ZIP</a>,
			<a title="Одной страницей" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportSession&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@sid}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;showAll=1">Одной страницей</a> (После изменения фильтра сначала нажмите "Вывести")
		</div>

		<div class="bgPagesWidget" style="text-align: right; width: 800px;" formId="reportForm" recordCount="{sessions/@recordCount}"
			pageIndex="{sessions/@pageIndex}" pageSize="{sessions/@pageSize}" pageCount="{sessions/@pageCount}" />

		<xsl:choose>
			<xsl:when test="/data/@type = 1">
				<table class="table800">
				<thead>
				  <tr>
					   <td>Пойнт</td>
					   <td>Направление</td>
					   <td>Услуга</td>
					   <td>Время входа</td>
					   <td>Длительность<br/>сеанса</td>
					   <td>Длительность<br/>сеанса окр.</td>
					   <td>Сумма, руб.</td>
					   <td>C номера / На номер</td>               
				  </tr>
				 </thead>
				 <tbody>
				  <xsl:for-each select="sessions/session">
					 <tr>
						 <td><xsl:value-of select="@item"/></td>
						 <td><xsl:value-of select="@dest"/></td>
						 <td><xsl:value-of select="@service"/></td>
						 <td><xsl:value-of select="@session_start"/></td>
						 <td>
							 <xsl:call-template name="formatSessionTime">
							 	<xsl:with-param name="time" select="@session_time"/>
							 </xsl:call-template>							 
						 </td>
						 <td>
						 	<xsl:call-template name="formatSessionTime">
							 	<xsl:with-param name="time" select="@session_time_round"/>
							 </xsl:call-template>
						 </td>
						 <td><xsl:value-of select="@session_cost"/></td>
						 <td><xsl:value-of select="@from164"/> / <xsl:value-of select="@to164"/></td>
					</tr>
				  </xsl:for-each>
				</tbody>
				<tfoot>		
				  <tr>
					<td colspan="4">Итого сессий:&#160;<xsl:value-of select="sessions/@total_number"/></td>
					<td>
						<xsl:call-template name="formatSessionTime">
							 	<xsl:with-param name="time" select="sessions/@total_time"/>
						</xsl:call-template>						
					</td>
					<td>
						<xsl:call-template name="formatSessionTime">
							 	<xsl:with-param name="time" select="sessions/@total_time_round"/>
						</xsl:call-template>
					</td>
					<td><xsl:value-of select="format-number(sessions/@total_cost, '### ### ##0.00', 'summa')"/></td>
					<td>&#160;</td>
				  </tr>   
				 </tfoot>       
				</table>
			</xsl:when>
			<xsl:otherwise>
				<table class="table800">
				<thead>
				  <tr>
					<td>Правило</td>
					<td>Услуга</td>
					<td>Время входа</td>
					<td>Длительность<br/> сеанса</td>
					<td>Длительность<br/>сеанса окр.</td>
					<td>Сумма, руб.</td>
					<td>C номера / На номер</td>               
				  </tr>
				  </thead>
				  <tbody>
				  <xsl:for-each select="sessions/session">
					 <tr>
						 <td><xsl:value-of select="@item"/></td>
						 <td><xsl:value-of select="@service"/></td>
						 <td><xsl:value-of select="@session_start"/></td>
						 <td>
							 <xsl:call-template name="formatSessionTime">
							 	<xsl:with-param name="time" select="@session_time"/>
							 </xsl:call-template>							 
						 </td>
						 <td>
						 	<xsl:call-template name="formatSessionTime">
							 	<xsl:with-param name="time" select="@session_time_round"/>
							 </xsl:call-template>
						 </td>
						 <td><xsl:value-of select="@session_cost"/></td>
						 <td><xsl:value-of select="@from164"/> / <xsl:value-of select="@to164"/></td>
					</tr>
				  </xsl:for-each>
				  </tbody>
				  <tfoot>
				  <tr>
					<td colspan="3">Итого сессий:&#160;<xsl:value-of select="sessions/@total_number"/></td>
					<td>
						<xsl:call-template name="formatSessionTime">
							 	<xsl:with-param name="time" select="sessions/@total_time"/>
						</xsl:call-template>						
					</td>
					<td>
						<xsl:call-template name="formatSessionTime">
							 	<xsl:with-param name="time" select="sessions/@total_time_round"/>
						</xsl:call-template>
					</td>
					<td><xsl:value-of select="format-number(sessions/@total_cost, '### ### ##0.00', 'summa')"/></td>
					<td>&#160;</td>
				  </tr>          
				  </tfoot>
				</table>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:if>
</xsl:template>


<!-- наработка по логинам -->
<xsl:template name="ReportAmount">
	
	<form method="post" action="{$WEBEXECUTER}" name="report" id="reportForm">
		<input type="hidden" name="pageSize"><xsl:attribute name="value"><xsl:value-of select="table/@pageSize"/></xsl:attribute></input>
		<xsl:call-template name="action"/>		
		<input type="hidden" name="type" value="{/data/@type}"/>
		<xsl:call-template name="report_filters"/>
	</form>

	<xsl:if test="table">		

		<div class="bgPagesWidget" style="text-align: right; width: 800px;" formId="reportForm" recordCount="{table/@recordCount}"
		pageIndex="{table/@pageIndex}" pageSize="{table/@pageSize}" pageCount="{table/@pageCount}" />
		
		<xsl:variable name="items"><xsl:for-each select="items/item[@selected = '1']">&amp;items=<xsl:value-of select="@id"/></xsl:for-each></xsl:variable>
		<div>
			Отчет в виде:
			<a title="CSV" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportAmount&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@sid}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=csv">CSV</a>,
			<a title="HTML" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportAmount&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@sid}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=html">HTML</a>,
			<a title="CSV/ZIP" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportAmount&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@sid}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=csv&amp;zip=1">CSV/ZIP</a>,
			<a title="HTML/ZIP" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportAmount&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@sid}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=html&amp;zip=1">HTML/ZIP</a>,
			<a title="Одной страницей" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportAmount&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@sid}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;showAll=1">Одной страницей</a> (После изменения фильтра сначала нажмите "Вывести")
		</div>

		<table class="table800">
			<thead>
				<tr>
				<xsl:choose>
				<xsl:when test="/data/@type = 1">
					<td>Пойнт</td>
				</xsl:when>
				<xsl:otherwise>
					<td>Правило</td>
				</xsl:otherwise>
				</xsl:choose>
					<td>Количество</td>
					<td>Длительность</td>
					<td>Длительность<br/>округлённая</td>
					<td>Сумма, руб.</td>
	        	</tr>
			</thead>
			<tbody>
				<xsl:for-each select="table/data/row">
				<tr>
					<td><xsl:value-of select="@item"/></td>
					<td><xsl:value-of select="@number"/></td>
				 	<td>
					 	<xsl:call-template name="formatSessionTime">
					 		<xsl:with-param name="time" select="@time"/>
						</xsl:call-template>							 
					</td>
					<td>
						<xsl:call-template name="formatSessionTime">
							<xsl:with-param name="time" select="@time_round"/>
						</xsl:call-template>
					</td>
					<td><xsl:value-of select="@cost"/></td>
				</tr>
				</xsl:for-each>
			</tbody>
			<tfoot>
				<tr>
					<td>Итого:</td>
					<td><xsl:value-of select="table/@total_number"/></td>
					<td>
						<xsl:call-template name="formatSessionTime">
						 	<xsl:with-param name="time" select="table/@total_time"/>
						</xsl:call-template>						
					</td>
					<td>
						<xsl:call-template name="formatSessionTime">
						 	<xsl:with-param name="time" select="table/@total_time_round"/>
						</xsl:call-template>
					</td>
					<td><xsl:value-of select="format-number(table/@total_cost, '### ### ##0.00', 'summa')"/></td>
				</tr>
			</tfoot>
		</table>
	</xsl:if>
</xsl:template>


<!-- наработка логина по направлениям -->
<xsl:template name="ReportDirect">
	<form method='post' action='{$WEBEXECUTER}#idDivReport' name="report" id="reportForm">
		<input type="hidden" name="pageSize"><xsl:attribute name="value"><xsl:value-of select="table/@pageSize"/></xsl:attribute></input>
		<xsl:call-template name="action"/>
		<input type="hidden" name="type" value="1"/>		
		<xsl:call-template name="report_filters">
			<xsl:with-param name="onlyPoints" select="'1'"/>
		</xsl:call-template>
	</form>
	
	<xsl:if test="table">		
	<div class="bgPagesWidget" style="text-align: right; width: 800px;" formId="reportForm" recordCount="{table/@recordCount}"
		pageIndex="{table/@pageIndex}" pageSize="{table/@pageSize}" pageCount="{table/@pageCount}" />
	
	<xsl:variable name="items"><xsl:for-each select="items/item[@selected = '1']">&amp;items=<xsl:value-of select="@id"/></xsl:for-each></xsl:variable>
		<div>
			Отчет в виде:
			<a title="CSV" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportDirect&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@dest_id}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=csv">CSV</a>,
			<a title="HTML" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportDirect&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@dest_id}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=html">HTML</a>,
			<a title="CSV/ZIP" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportDirect&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@dest_id}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=csv&amp;zip=1">CSV/ZIP</a>,
			<a title="HTML/ZIP" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportDirect&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@dest_id}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=html&amp;zip=1">HTML/ZIP</a>,
			<a title="Одной страницей" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportDirect&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@dest_id}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;showAll=1">Одной страницей</a> (После изменения фильтра сначала нажмите "Вывести")
		</div>
	
	<table class="table800">
		<col/>
		<col align="center"/>
		<col align="center"/>
		<col align="center"/>
		<col align="center"/>
		<col align="center"/>
		<thead>
			<tr>
				<td>Пойнт</td>
				<td>Направление</td>
				<td>Количество</td>
				<td>Длительность</td>
				<td>Длительность<br/>округлённая</td>
				<td>Сумма, руб.</td>
			</tr>
		</thead>
		<tbody>
		<xsl:for-each select="table/data/row">
			<tr>
				<td><xsl:value-of select="@item"/></td>
				<td>
				  <a title="Просмотр сессий по данному направлению" href="{$WEBEXECUTER}?mid={/data/@mid}&amp;module={/data/@module}&amp;dest={@dest_id}&amp;action=ReportSession&amp;items={@item_id}&amp;year={/data/date/@year}&amp;month={/data/date/@month}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}">
				  <xsl:value-of select="@dest"/>
				  </a>
				</td>
 				<td><xsl:value-of select="@number"/></td>
				<td>
					 <xsl:call-template name="formatSessionTime">
					 	<xsl:with-param name="time" select="@time"/>
					 </xsl:call-template>							 
				 </td>
				 <td>
				 	<xsl:call-template name="formatSessionTime">
					 	<xsl:with-param name="time" select="@time_round"/>
					 </xsl:call-template>
				 </td>
				<td><xsl:value-of select="@cost"/></td>
			</tr>
		</xsl:for-each>
		</tbody>
		<tfoot>
			<tr>
				<td colspan="2" align="left">Итого:</td>
				<td><xsl:value-of select="table/@total_number"/></td>
				<td>
					<xsl:call-template name="formatSessionTime">
						 	<xsl:with-param name="time" select="table/@total_time"/>
					</xsl:call-template>						
				</td>
				<td>
					<xsl:call-template name="formatSessionTime">
						 	<xsl:with-param name="time" select="table/@total_time_round"/>
					</xsl:call-template>
				</td>
				<td><xsl:value-of select="format-number(table/@total_cost, '### ### ##0.00', 'summa')"/></td>
			</tr>
		</tfoot>
	</table>
	</xsl:if>	
</xsl:template>


<!-- наработка логина по услугам -->
<xsl:template name="ReportService">

	<form method='post' action='{$WEBEXECUTER}#idDivReport' name="report" id="reportForm">
		<input type="hidden" name="pageSize"><xsl:attribute name="value"><xsl:value-of select="table/@pageSize"/></xsl:attribute></input>
		<xsl:call-template name="action"/>
		<input type="hidden" name="type" value="{/data/@type}"/>
		<xsl:call-template name="report_filters"/>
	</form>	

	<xsl:if test="table">		
	<div class="bgPagesWidget" style="text-align: right; width: 800px;" formId="reportForm" recordCount="{table/@recordCount}"
		pageIndex="{table/@pageIndex}" pageSize="{table/@pageSize}" pageCount="{table/@pageCount}" />

	<xsl:variable name="items"><xsl:for-each select="items/item[@selected = '1']">&amp;items=<xsl:value-of select="@id"/></xsl:for-each></xsl:variable>
		<div>
			Отчет в виде:
			<a title="CSV" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportService&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@dest_id}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=csv">CSV</a>,
			<a title="HTML" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportService&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@dest_id}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=html">HTML</a>,
			<a title="CSV/ZIP" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportService&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@dest_id}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=csv&amp;zip=1">CSV/ZIP</a>,
			<a title="HTML/ZIP" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportService&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@dest_id}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=html&amp;zip=1">HTML/ZIP</a>,
			<a title="Одной страницей" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportService&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@dest_id}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;showAll=1">Одной страницей</a> (После изменения фильтра сначала нажмите "Вывести")
		</div>

	<table class="table800">
		<thead>
			<tr>
				<td>Пойнт</td>
				<td>Услуга</td>
				<td>Количество</td>
				<td>Длительность</td>
				<td>Длительность<br/>округлённая</td>
				<td>Сумма, руб.</td>
			</tr>
		</thead>
		<tbody>
		<xsl:for-each select="table/data/row">
			<tr>
				<td><xsl:value-of select="@item"/></td>
				<td>
				  <a title="Просмотр сессий по данной услуге" href="{$WEBEXECUTER}?mid={/data/@mid}&amp;module={/data/@module}&amp;sid={@dest_id}&amp;action=ReportSession&amp;items={@item_id}&amp;year={/data/date/@year}&amp;month={/data/date/@month}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}">
				  <xsl:value-of select="@dest"/>
				  </a></td>
 				<td><xsl:value-of select="@number"/></td>
				<td>
					 <xsl:call-template name="formatSessionTime">
					 	<xsl:with-param name="time" select="@time"/>
					 </xsl:call-template>							 
				 </td>
				 <td>
				 	<xsl:call-template name="formatSessionTime">
					 	<xsl:with-param name="time" select="@time_round"/>
					 </xsl:call-template>
				 </td>
				<td><xsl:value-of select="@cost"/></td>
			</tr>
		</xsl:for-each>
		</tbody>
		<tfoot>
			<tr>
				<td colspan="2" align="left">Итого:</td>
				<td><xsl:value-of select="table/@total_number"/></td>
				<td>
					<xsl:call-template name="formatSessionTime">
						 	<xsl:with-param name="time" select="table/@total_time"/>
					</xsl:call-template>						
				</td>
				<td>
					<xsl:call-template name="formatSessionTime">
						 	<xsl:with-param name="time" select="table/@total_time_round"/>
					</xsl:call-template>
				</td>
				<td><xsl:value-of select="format-number(table/@total_cost, '### ### ##0.00', 'summa')"/></td>
			</tr>
		</tfoot>
	</table>
	</xsl:if>	
</xsl:template>

<!-- Входящие звонки -->
<xsl:template name="ReportIncommingCall">
	<form method='post' action='{$WEBEXECUTER}#idDivReport' name="report" id="reportForm">
		<input type="hidden" name="pageSize"><xsl:attribute name="value"><xsl:value-of select="incomming/@pageSize"/></xsl:attribute></input>		
		<xsl:call-template name="action"/>		
		<xsl:call-template name="report_filters"/>
	</form>
	
	<xsl:if test="incomming">
	<xsl:variable name="items"><xsl:for-each select="items/item[@selected = '1']">&amp;items=<xsl:value-of select="@id"/></xsl:for-each></xsl:variable>
	<div>
		Отчет в виде:
		<a title="CSV" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportIncommingCall&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@sid}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=csv">CSV</a>,
		<a title="HTML" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportIncommingCall&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@sid}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=html">HTML</a>,
		<a title="CSV/ZIP" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportIncommingCall&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@sid}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=csv&amp;zip=1">CSV/ZIP</a>,
		<a title="HTML/ZIP" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportIncommingCall&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@sid}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=html&amp;zip=1">HTML/ZIP</a>,
		<a title="Одной страницей" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportIncommingCall&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@sid}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;showAll=1">Одной страницей</a> (После изменения фильтра сначала нажмите "Вывести")
	</div>

	<div class="bgPagesWidget" style="text-align: right; width: 800px;" formId="reportForm" recordCount="{incomming/@recordCount}"
		pageIndex="{incomming/@pageIndex}" pageSize="{incomming/@pageSize}" pageCount="{incomming/@pageCount}" />
	
	<table class="table800">
		<thead>
			<tr bgcolor="#f0f0f0">
				<td>Пойнт</td>
				<td>Время входа</td>
				<td>Длительность[в секундах]</td>
				<td>С номера / На номер</td>         
			</tr>
		</thead>
		<tbody>
     		<xsl:for-each select="incomming/row">
			<tr bgcolor="#ffffff">
				<td><xsl:value-of select="@item"/></td>
				<td><xsl:value-of select="@session_start"/></td>
				<td><xsl:value-of select="@session_time"/></td>
				<td><xsl:value-of select="@from164"/>/<xsl:value-of select="@to164"/></td>
			</tr>
     		</xsl:for-each>
     	</tbody>
     	<tfoot>		
			<tr>
				<td colspan="2">Итого сессий:&#160;<xsl:value-of select="incomming/@total_number"/></td>
				<td><xsl:value-of select="incomming/@total_time"/></td>
				<td><xsl:value-of select="incomming/@total_time_round"/></td>
			</tr>   
		</tfoot>
	</table>
	</xsl:if>
</xsl:template>


<!-- сессии по услугам/номерам -->
<xsl:template name="ReportServiceSession">
	<style>
		.idTablePhoneServiceSession tbody th { font-weight: bold ! important; }
		.idTablePhoneServiceSession tbody tr th:first-child, .idTablePhoneServiceSession col.col1 { text-align: left ! important; width: 9em; }
	</style>
	
	<form method='get' action='{$WEBEXECUTER}#idDivReport' name="report" id="reportForm">
		<input type="hidden" name="pageSize"><xsl:attribute name="value"><xsl:value-of select="sessions/@pageSize"/></xsl:attribute></input>		
		<xsl:call-template name="action"/>		
		<input type="hidden" name="type" value="{/data/@type}"/>		
		<input type="hidden" name="dest" value="{/data/@dest}"/>
		<input type="hidden" name="sid" value="{/data/@sid}"/>
		<xsl:call-template name="report_filters"/>
	</form>
	
	<xsl:if test="sessions">
	<xsl:variable name="items"><xsl:for-each select="items/item[@selected = '1']">&amp;items=<xsl:value-of select="@id"/></xsl:for-each></xsl:variable>
	<div>
		Отчет в виде:
		<a title="CSV" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportServiceSession&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@sid}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=csv">CSV</a>,
		<a title="HTML" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportServiceSession&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@sid}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=html">HTML</a>,
		<a title="CSV/ZIP" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportServiceSession&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@sid}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=csv&amp;zip=1">CSV/ZIP</a>,
		<a title="HTML/ZIP" href="{$WEBEXECUTER}?module=phone&amp;mid={/data/@mid}&amp;action=ReportServiceSession&amp;type={/data/@type}&amp;dest={/data/@dest}&amp;sid={/data/@sid}{$items}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;nofree={/data/items/@nofree}&amp;file=1&amp;output=html&amp;zip=1">HTML/ZIP</a> (После изменения фильтра сначала нажмите "Вывести")
	</div>
	
	<div class="bgPagesWidget" style="text-align: right; width: 800px;" formId="reportForm" recordCount="{sessions/@recordCount}"
		pageIndex="{sessions/@pageIndex}" pageSize="{sessions/@pageSize}" pageCount="{sessions/@pageCount}" />

	<table class="table800 idTablePhoneServiceSession">
		<col class="col1"/>
		<col class="col2"/>
		<col class="col3"/>
		<col class="col4"/>
		<col class="col5"/>
		<thead>
		  <tr>
			   <td>Дата/время звонка</td>
			   <td>Направление</td>
			   <td>Номер телефона B</td>
			   <td>Округленная<br/>длительность, мин.</td>
			   <td>Стоимость звонка,<br/>руб.</td>
		  </tr>
		 </thead>
		 <tbody>
		 <xsl:for-each select="sessions/service">
			<tr>
				 <td colspan="5" class="tablePhoneServiceSessionServiceTh">Услуга: <xsl:value-of select="@title"/></td>
			</tr>
			<xsl:for-each select="number">
				<tr>
					 <td colspan="5" class="tablePhoneServiceSessionAonTh">Номер телефона А: <xsl:value-of select="@id"/></td>
				</tr>

			  <xsl:for-each select="session">
				 <tr>
					 <td><xsl:value-of select="@session_start"/></td>
						 <td><xsl:value-of select="@dest"/></td>
						 <td><xsl:value-of select="@to164"/></td>
					 <td>
					 	<xsl:call-template name="formatSessionTime">
						 	<xsl:with-param name="time" select="@session_time_round"/>
						 </xsl:call-template>
					 </td>
					 <td><xsl:value-of select="@session_cost"/></td>
				</tr>
				</xsl:for-each>
				
					<tr>
					<td colspan="2">Итого по номеру:&#160;<xsl:value-of select="@total_number"/></td>
					<td>
						<xsl:call-template name="formatSessionTime">
							 	<xsl:with-param name="time" select="@total_time"/>
						</xsl:call-template>						
					</td>
					<td>
						<xsl:call-template name="formatSessionTime">
							 	<xsl:with-param name="time" select="@total_time_round"/>
						</xsl:call-template>
					</td>
					<td><xsl:value-of select="format-number(@total_cost, '### ### ##0.00', 'summa')"/></td>
				  </tr>

				</xsl:for-each>
				
				<tr>
				<td colspan="2">Итого по услуге:&#160;<xsl:value-of select="@total_number"/></td>
				<td>
					<xsl:call-template name="formatSessionTime">
						 	<xsl:with-param name="time" select="@total_time"/>
					</xsl:call-template>						
				</td>
				<td>
					<xsl:call-template name="formatSessionTime">
						 	<xsl:with-param name="time" select="@total_time_round"/>
					</xsl:call-template>
				</td>
				<td><xsl:value-of select="format-number(@total_cost, '### ### ##0.00', 'summa')"/></td>
			  </tr>
		  </xsl:for-each>
		</tbody>
		<tfoot>		
		  <tr>
			<td colspan="2">Итого сессий:&#160;<xsl:value-of select="sessions/@total_number"/></td>
			<td>
				<xsl:call-template name="formatSessionTime">
					 	<xsl:with-param name="time" select="sessions/@total_time"/>
				</xsl:call-template>						
			</td>
			<td>
				<xsl:call-template name="formatSessionTime">
					 	<xsl:with-param name="time" select="sessions/@total_time_round"/>
				</xsl:call-template>
			</td>
			<td><xsl:value-of select="format-number(sessions/@total_cost, '### ### ##0.00', 'summa')"/></td>
		  </tr>   
		 </tfoot>       
		</table>
	</xsl:if>
</xsl:template>


<!-- свойства рассылки сессий логина -->
<xsl:template name="Dispatch">
	<form action="{$WEBEXECUTER}" method="post" name="report">	
	<xsl:call-template name="action"/>
	<input type="hidden" name="id" value="{dispatch/@id}"/>
	<input type="hidden" name="type" value="{dispatch/@type}"/>
	<input type="hidden" name="command" value="save"/>
	<input type="hidden" name="itemType" value="{/data/@type}"/>

	
	<div class="report">
	<table cellspacing='1' class="table800">
	<thead>
	<tr>
	  	<td>Поле</td>
	  	<td>Данные</td>
	  	<td>Комментарий</td>
	</tr>
	</thead>
	<tbody>
	  <tr>
		<td>Название:</td>
		<td>
			<input type="text" name="title" size="32" style="width:100%" value="{dispatch/@title}"/>
		</td>
		<td><em class="comment">
			Название вашей рассылки, например 'Сессии логина test'.	
			Это название будет указано в теле письма.</em>
		</td>
	  </tr>
	  <tr>
		<td nowrap="1"><xsl:choose>
 				<xsl:when test="/data/@type = 1"><b>Пойнты</b><xsl:if test="/data/@rules = 1">/<a href="#" onclick="document.forms['report'].itemType.value='2'; document.forms['report'].items.name='_items';document.forms['report'].submit();">Правила</a>
  				</xsl:if>
  				</xsl:when>
  				<xsl:otherwise>
  				<xsl:if test="/data/@points = 1">
  				<a href="#" onclick="document.forms['report'].itemType.value='1'; document.forms['report'].items.name='_items';document.forms['report'].submit();">Пойнты</a>/</xsl:if><b>Правила</b>
  				</xsl:otherwise>
  		</xsl:choose>:</td>
		
		<td>
  			<select size='10' name='items' multiple='1' style="width:100%">
  			  <xsl:for-each select="items/item">
  				<option>
  					<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
  					<xsl:if test="@selected = '1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
  					<xsl:value-of select="@title"/>
  				</option>
  			  </xsl:for-each>
  			</select>
		</td>        
		<td><em class="comment">
			<xsl:choose>
				<xsl:when test="/data/@type = 1"><b>Пойнты</b><xsl:if test="/data/@rules = 1">/<a href="#" onclick="document.forms['report'].itemType.value='2'; document.forms['report'].items.name='_items';document.forms['report'].submit();">правила</a>
  				</xsl:if>
  				</xsl:when>
  				<xsl:otherwise>
  				<xsl:if test="/data/@points = 1">
  				<a href="#" onclick="document.forms['report'].itemType.value='1'; document.forms['report'].items.name='_items';document.forms['report'].submit();">Пойнты</a>/</xsl:if><b>правила</b>
  				</xsl:otherwise>
  			</xsl:choose>, сессии которых будут высылаться.
  			</em>
		</td>
		</tr>
		<tr>
			<td>Только платные</td>
		  	<td>
		  		<select name="nofree">
					<option value="0">нет</option>
					<option value="1"><xsl:if test="dispatch/@nofree='1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>да</option>
				</select>
		  	</td>
		  	<td><em class="comment">Отправлять только сессии, стоимость которых не равна нулю</em></td>
		</tr>
		  <tr>	
			<td>Адреса:</td>
			<td>
				<textarea name="mails" rows="4" cols="25">
					<xsl:for-each select="dispatch/mail">
						<xsl:value-of select="@value"/>
						<xsl:if test="position() != last()">
							<xsl:value-of select="'	
							'"/>
						</xsl:if>
					</xsl:for-each>
				</textarea>
			</td>
			<td><em class="comment">
				Перечень адресов на которые будут приходить данная рассылка.
				Каждый адрес с новой строки.</em>
			</td>
  		  </tr>
  		  
  		  <tr>			
			<td>Статус:</td>
			<td>
				<select name="status">
					<option value="0">неактивна</option>
					<option value="1"><xsl:if test="dispatch/@status='1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>активна</option>
				</select>
			</td>
			<td><em class="comment">Рассылка приходит только если ее статус активен.</em></td>
		 </tr>
		 <tr>	
			<td nowrap="1">Дни недели ( 1-7 ):</td>
			<td>
				<input type="text" name="dw">
					<xsl:attribute name="value"><xsl:value-of select="dispatch/@dw"/></xsl:attribute>
				</input>
			</td>
			<td><em class="comment">
				Дни недели, например 1 - 7 ( каждый день ), 1, 2 ( понедельник, вторник )
				в которые вам будет высылаться рассылка.</em>
			</td>
		 </tr>
		 </tbody>
		 <tfoot>  
		  <tr>
            <td colspan="3">
			<xsl:call-template name="okCancel">
				<xsl:with-param name="title1" select="'Сохранить'"/>
				<xsl:with-param name="onclick2">window.location.replace( '<xsl:value-of select="$WEBEXECUTER"/>?action=Subscription&#38;mid=contract&#38;module=contract' );</xsl:with-param>
			</xsl:call-template>
            </td>
		</tr>
		</tfoot>
		</table>
		</div>		
	</form>		
</xsl:template>
<!-- смена тарифных планов -->
	<xsl:template name="ChangeTariff">
		 
		 <xsl:choose>
		 <xsl:when test="/data/@point=1">
				<table class="table800">
			<thead>
				<tr>
					<td>Пойнт</td>
					<td>Смена тарифа</td>
	        	</tr>
			</thead>
			<tbody>
				<xsl:for-each select="/data/points/item">
				<tr>
					<td><xsl:value-of select="@title"/>
					</td>
					<td>
					<a href="{$WEBEXECUTER}?action=ChangeTariff&amp;module=phone&amp;mid={/data/@mid}&amp;contractId={/data/@id}&amp;pointId={@id}">
								Сменить тариф
							</a>
					
					</td>
				</tr>
				</xsl:for-each>
			</tbody>
			</table>		
		 </xsl:when>
		 <xsl:otherwise>
			<table class="table800">
				<thead>
				  <tr>
				  	<td>Тарифный план</td>
				  	<td>С даты</td>
				  	<td>По дату</td>
				  	<td>Сменить</td>
				  </tr>
				 </thead>
				 <tbody>
					  <xsl:for-each select="/data/history/row">
					<tr>
						<td><font>
						<xsl:if test="@active=0">
							<xsl:attribute name="color">#8e8e8e</xsl:attribute>
						</xsl:if><xsl:value-of select="@tariff"/><xsl:if test="@type=1"> (персональный)</xsl:if></font></td>
						<td><xsl:value-of select="@date1"/></td>
						<td><xsl:value-of select="@date2"/></td>
						<td>
							<xsl:if test="@group">
								<form method='get' action='{$WEBEXECUTER}'>
									<xsl:call-template name="action"/>
									<input type="hidden" name="command" value="change"/>
									<input type="hidden" name="pointId"><xsl:attribute name="value"><xsl:value-of select="/data/@pointId"/></xsl:attribute></input>
									<input type="hidden" name="tariff_group"><xsl:attribute name="value"><xsl:value-of select="@group"/></xsl:attribute></input>
									<input type="hidden" name="step"><xsl:attribute name="value"><xsl:value-of select="/data/@step"/></xsl:attribute></input>
									<table class="layout">
										<xsl:choose>
											<xsl:when test="/data/@step=0">
												<td nowrap="1" style="border: 0px;">	
													Перейти на тариф:
													<select name="to_tariff">
														<option value="-1">---</option>
														<xsl:for-each select="tariff_list/item" >
															<option value="{@id}"><xsl:value-of select="@title"/></option>
														</xsl:for-each>			
													</select>
												</td>
												<td style="border: 0px;">
													<xsl:call-template name="submit">				
														<xsl:with-param name="title" select="'Выбрать дату'"/>
														<xsl:with-param name="guid" select="'_change'"/>
													</xsl:call-template>
												</td>
											</xsl:when>
											<xsl:when test="/data/@step=1">
												<xsl:if test="@tariffId=/data/@from_tariff">
													<input type="hidden" name="to_tariff"><xsl:attribute name="value"><xsl:value-of select="/data/@to_tariff"/></xsl:attribute></input>
													<td nowrap="1" style="border: 0px;">	
														Перейти на тариф: <xsl:value-of select="/data/@to_tariff_title"/> 
														с даты:
														<select name="from_date" >
															<xsl:for-each select="date_list/item">
																<option>
																	<xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
																	<xsl:value-of select="@value"/>
																</option>
															</xsl:for-each>
														</select>
													</td>
													<td style="border: 0px;">
														<xsl:call-template name="submit">				
															<xsl:with-param name="title" select="'Сменить тариф'"/>
															<xsl:with-param name="confirm" select="'Вы уверены, что хотите сменить тариф?'"/>
															<xsl:with-param name="guid" select="'_change'"/>
														</xsl:call-template>
													</td>
												</xsl:if>
											</xsl:when>		
										</xsl:choose>
									</table>
								</form>
							</xsl:if>
							<xsl:if test="@canCancel=1">
								<form method='post' action='{$WEBEXECUTER}'>
									<xsl:call-template name="action"/>
									<input type="hidden" name="command" value="cancel"/>
									<input type="hidden" name="contractTariffId" value="{@contractTariffId}"/>
									
									<div style="float: left;">
										Предыдущий тариф: "<xsl:value-of select="@previousTariffTitle"/>"
									</div>
									<div style="float: left; padding-left: 10px;">
										<xsl:call-template name="submit">
											<xsl:with-param name="title" select="'Отменить переход'"/>
											<xsl:with-param name="confirm" select="'Вы уверены, что хотите отменить переход на тариф?'"/>
											<xsl:with-param name="guid" select="'_cancel'"/>
										</xsl:call-template>
									</div>
								</form>
							</xsl:if>
						</td>
					</tr>
				  </xsl:for-each>
				 </tbody>	
			</table>	
			<em class="comment">Серым цветом выделены неактивные тарифные планы.</em>	 
		 </xsl:otherwise>
		 </xsl:choose>
	
	
	
	
</xsl:template>

</xsl:stylesheet>
