/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.modules.voiceip;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Report_ChitaOnline_1
extends BGJasperReport {
    private PreparedStatement psGetAliases;

    public Report_ChitaOnline_1() {
        this.id = "voiceip_chitaonline_1";
    }

    @Override
    public void fillReportToStream(OutputStream out) {
        int mid = Utils.parseInt((String)this.getStringParam("mid"), (int)-1);
        Date date1 = TimeUtils.parseDate((String)this.getStringParam("date1"), (String)"dd.MM.yyyy");
        Date date2 = TimeUtils.parseDate((String)this.getStringParam("date2"), (String)"dd.MM.yyyy");
        int type = Utils.parseInt((String)this.getStringParam("type"), (int)0);
        boolean noZero = this.getStringParam("no_zero") != null;
        String dests = this.getStringParam("dests");
        String groups = this.getStringParam("groups");
        if (mid > 0 && date1 != null && date2 != null) {
            try {
                BGDataSource bds = new BGDataSource();
                HashMap<String, String> params = new HashMap<String, String>();
                String sessionTableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)date1, (int)mid);
                if (ServerUtils.tableExists((Connection)this.con, (String)sessionTableName)) {
                    String loginTable = "user_login_" + mid;
                    String destTableName = "voiceip_dest_" + mid;
                    StringBuffer query = new StringBuffer(2000);
                    query.append("SELECT CONCAT( contract.title, ' (', contract.comment, ')' ), login.id, login.login, session.type, ");
                    query.append("CONCAT( session.from_number, '/', session.to_number), ");
                    query.append("dest.title, session.session_start, session.session_time, session.min_cost, session.session_cost, ");
                    query.append("contract.gr ");
                    query.append("FROM ");
                    query.append(sessionTableName);
                    query.append(" AS session");
                    query.append(" LEFT JOIN ");
                    query.append(loginTable);
                    query.append(" login ON session.lid=login.id");
                    query.append(" LEFT JOIN contract ON login.cid=contract.id ");
                    query.append(" LEFT JOIN ");
                    query.append(destTableName);
                    query.append(" AS dest ON session.dest_code=dest.id");
                    query.append(" WHERE session.session_start>=? AND session.session_start<DATE_ADD( ?, INTERVAL 1 DAY ) ");
                    if (noZero) {
                        query.append(" AND session.session_cost>0");
                    }
                    if (Utils.notEmptyString((String)dests)) {
                        query.append(" AND session.dest_code IN ( ");
                        query.append(dests);
                        query.append(" )");
                    }
                    if (Utils.notEmptyString((String)groups)) {
                        long groupMask = Utils.enumToMask((String)groups);
                        query.append(" AND contract.gr&");
                        query.append(groupMask);
                        query.append(">0");
                    }
                    if (type > 0) {
                        query.append(" AND session.type=");
                        query.append(type);
                    }
                    query.append(" ORDER BY session.session_start");
                    PreparedStatement ps = this.con.prepareStatement(query.toString());
                    ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)date1));
                    ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date2));
                    ResultSet rs = ps.executeQuery();
                    double summa = 0.0;
                    int summTime = 0;
                    while (rs.next()) {
                        HashMap<String, Object> row = new HashMap<String, Object>(10);
                        row.put("col1", rs.getString(1));
                        row.put("col2", rs.getString(3) + " (" + this.getAliases(this.con, mid, rs.getInt(2)) + ")");
                        row.put("col3", rs.getInt(4) == 1 ? "<<" : ">>");
                        row.put("col4", rs.getString(5));
                        row.put("col5", rs.getString(6));
                        row.put("col6", TimeUtils.formatTimestamp((Timestamp)rs.getTimestamp(7), (String)"dd HH:mm:ss"));
                        row.put("col7", Utils.formatSessionTime((int)rs.getInt(8)));
                        row.put("col8", Utils.formatCost((float)rs.getFloat(9)));
                        row.put("col9", Utils.formatCost((float)rs.getFloat(10)));
                        bds.addRow(row);
                        summTime += rs.getInt(8);
                        summa += rs.getDouble(10);
                    }
                    rs.close();
                    ps.close();
                    params.put("count", String.valueOf(bds.rows()));
                    params.put("summa", Utils.formatCost((float)((float)summa)));
                    params.put("summa_time", Utils.formatSessionTime((int)summTime));
                }
                this.fillReportToStream("voiceip_chitaonline_1", out, params, (JRDataSource)bds);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private String getAliases(Connection con, int mid, int lid) throws Exception {
        StringBuffer result = new StringBuffer(150);
        if (this.psGetAliases == null) {
            String query = "SELECT login_alias FROM user_alias_" + mid + " WHERE login_id=?";
            this.psGetAliases = con.prepareStatement(query);
        }
        this.psGetAliases.setInt(1, lid);
        ResultSet rs = this.psGetAliases.executeQuery();
        while (rs.next()) {
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(rs.getString(1));
        }
        rs.close();
        return result.toString();
    }
}

