/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCameraBrand;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ForpostCameraBrandDao
extends AbstractIdDao<ForpostCameraBrand>
implements Directory<ForpostCameraBrand> {
    private Logger logger = LogManager.getLogger();

    public ForpostCameraBrandDao(Connection con, int moduleId) {
        super(con, moduleId, "smarthouse_forpost_camera_brand");
    }

    public ForpostCameraBrand get(String title) throws BGException {
        throw new UnsupportedOperationException();
    }

    public List<ForpostCameraBrand> list() throws BGException {
        return this.list(null, "id", new Object[0]);
    }

    protected ForpostCameraBrand getFromRS(ResultSet rs) throws SQLException, BGException {
        return new ForpostCameraBrand(rs.getInt("id"), rs.getString("name"));
    }

    protected void updateImpl(ForpostCameraBrand forpostCameraBrand) throws BGException {
        if (forpostCameraBrand != null) {
            try {
                int parameterIndex = 1;
                boolean insert = forpostCameraBrand.getId() > 0;
                String sql = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET id=?, name=?" + (insert ? "" : " WHERE id=?");
                PreparedStatement ps = this.con.prepareStatement(sql);
                ps.setInt(parameterIndex++, forpostCameraBrand.getId());
                ps.setString(parameterIndex++, forpostCameraBrand.getName());
                if (!insert) {
                    ps.setInt(parameterIndex++, forpostCameraBrand.getId());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(ps.toString());
                }
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void searchForpostCameraBrands(SearchResult<ForpostCameraBrand> searchResult) throws BGException {
        Page page = searchResult.getPage();
        List list = searchResult.getList();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT SQL_CALC_FOUND_ROWS* FROM " + this.tableName + (page != null ? page.sqlLimit() : ""), 1);){
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
            rs.close();
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw new BGException((Throwable)e);
        }
    }

    public void doSync(ForpostCameraBrand[] cameraBrands) throws BGException {
        if (cameraBrands == null) {
            return;
        }
        long now = System.currentTimeMillis();
        try (PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET id=?, name=?, sync_datetime=? ON DUPLICATE KEY UPDATE name=?, sync_datetime=?");
             PreparedStatement psDelete = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE sync_datetime<>?");){
            for (ForpostCameraBrand forpostCameraBrand : cameraBrands) {
                int parameterIndex = 1;
                psInsert.setInt(parameterIndex++, forpostCameraBrand.getId());
                psInsert.setString(parameterIndex++, forpostCameraBrand.getName());
                psInsert.setLong(parameterIndex++, now);
                psInsert.setString(parameterIndex++, forpostCameraBrand.getName());
                psInsert.setLong(parameterIndex++, now);
                psInsert.executeUpdate();
            }
            psDelete.setLong(1, now);
            psDelete.executeUpdate();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }
}

